/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.testObjects;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.impexp.ExportContext;
import oracle.dbtools.unit_test.impexp.ImportContext;
import oracle.dbtools.unit_test.impexp.LoggerLevel;
import oracle.dbtools.unit_test.process_validation.IValidation;
import oracle.dbtools.unit_test.process_validation.ValidationRegistry;
import oracle.dbtools.unit_test.testObjects.ObjectUpdateException;
import oracle.dbtools.unit_test.testObjects.UtLibraryRef;
import oracle.dbtools.unit_test.testObjects.UtTestImpl;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.NodeList;

public class UtValidation {
    private UtTestImpl _testImpl;
    private String _validationId;
    private int _savedIndexNo;
    private UtLibraryRef _libRef;
    private String _xml;
    private boolean _applyValidation;
    private boolean _dirty = false;

    public UtValidation(UtTestImpl utTestImpl, String string, int n, UtLibraryRef utLibraryRef, String string2, boolean bl, boolean bl2) {
        this._testImpl = utTestImpl;
        this._validationId = string != null ? string : UUID.randomUUID().toString();
        this._savedIndexNo = n;
        this._libRef = utLibraryRef;
        this._xml = string2;
        this._applyValidation = bl;
        this._dirty = bl2;
    }

    UtValidation(XMLElement xMLElement, UtTestImpl utTestImpl, ImportContext importContext) {
        String string;
        String string2;
        this._testImpl = utTestImpl;
        this._savedIndexNo = -1;
        this._validationId = xMLElement.getAttribute("id");
        if (this._validationId == null || this._validationId.equals("")) {
            importContext.log(LoggerLevel.SEVERE, "unexpected null value");
        }
        if ((string2 = xMLElement.getAttribute("apply")) != null && !string2.equals("")) {
            this._applyValidation = Boolean.parseBoolean(string2);
        }
        if ((string = xMLElement.getAttribute("lib_id")) != null && !string.equals("")) {
            if (string == null || string.equals("")) {
                importContext.log(LoggerLevel.SEVERE, "unexpected null value");
            }
            String string3 = xMLElement.getAttribute("lib_name");
            this._libRef = new UtLibraryRef(string, string3);
        } else {
            List<XMLElement> list = importContext.getNestedElements(xMLElement, "validation");
            for (XMLElement xMLElement2 : list) {
                NodeList nodeList = xMLElement2.getChildrenByTagName("name");
                if (nodeList.getLength() != 1) continue;
                XMLElement xMLElement3 = (XMLElement)nodeList.item(0);
                String string4 = xMLElement3.getText();
                IValidation iValidation = ValidationRegistry.getInstanceFor(string4);
                if (iValidation == null) {
                    importContext.log(LoggerLevel.SEVERE, "Invalid codehook type name: " + string4);
                    continue;
                }
                iValidation.loadFromXmlElement(xMLElement2);
                this._xml = iValidation.getXml();
            }
        }
    }

    void exportRelated(ExportContext exportContext) {
        if (this._libRef != null) {
            exportContext.exportRelatedLibValidation(this._libRef.getLibId());
        }
    }

    void exportFields(XMLElement xMLElement, ExportContext exportContext) {
        IValidation iValidation;
        XMLElement xMLElement2;
        XMLElement xMLElement3 = exportContext.createExportedElement(xMLElement, "validation");
        xMLElement3.setAttribute("id", this._validationId);
        xMLElement3.setAttribute("apply", Boolean.toString(this._applyValidation));
        if (this._libRef != null) {
            xMLElement3.setAttribute("lib_id", this._libRef.getLibId());
            xMLElement3.setAttribute("lib_name", this._libRef.getName());
        } else if (this._xml != null && (xMLElement2 = (iValidation = this.getValidationCodeHook()).getXmlElement()) != null) {
            exportContext.reparentExportedElement(xMLElement3, xMLElement2);
        }
    }

    public String getValidationId() {
        return this._validationId;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public UtTestImpl getTestImpl() {
        return this._testImpl;
    }

    public void setLibraryRef(UtLibraryRef utLibraryRef) {
        this._libRef = utLibraryRef;
        this._dirty = true;
    }

    public UtLibraryRef getLibraryRef() {
        return this._libRef;
    }

    public void setXml(String string) {
        this._xml = string;
        this._dirty = true;
    }

    public String getXml() {
        return this._xml;
    }

    public boolean getApplyValidation() {
        return this._applyValidation;
    }

    public void setApplyValidation(boolean bl) {
        this._applyValidation = bl;
        this._dirty = true;
    }

    public void setApplyValidation(int n) {
        this.setApplyValidation(n != 0);
    }

    public IValidation getValidationCodeHook() {
        String string = null;
        String string2 = UtUtils.getXmlValue(this.getXml(), "validation", "class");
        if (string2 != null) {
            string = ValidationRegistry.getKeyFor(string2);
        }
        if (string == null || string.equals("")) {
            string = UtUtils.getXmlValue(this.getXml(), "validation", "name");
        }
        IValidation iValidation = ValidationRegistry.getInstanceFor(string);
        iValidation.setOwnerId(this.getValidationId());
        iValidation.setLibraryRef(this.getLibraryRef());
        iValidation.loadFromXml(this.getXml());
        iValidation.setEnabled(this.getApplyValidation());
        return iValidation;
    }

    public void setValidationCodeHook(IValidation iValidation) {
        String string = iValidation.getXml();
        if (this._xml == null && string != null || this._xml != null && !this._xml.equals(string)) {
            this.setXml(string);
        }
        UtLibraryRef utLibraryRef = iValidation.getLibraryRef();
        if (this._libRef == null && utLibraryRef != null || this._libRef != null && !this._libRef.equals(utLibraryRef)) {
            this.setLibraryRef(utLibraryRef);
        }
        this.setApplyValidation(iValidation.isEnabled());
    }

    boolean save(int n, boolean bl) throws ObjectUpdateException {
        if (!bl && !this._dirty && n == this._savedIndexNo) {
            return true;
        }
        boolean bl2 = false;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string = UtUtils.getQuery("mergeValidation");
                hashMap.put("UTI_ID", this._testImpl.getUtiId());
                hashMap.put("VALIDATION_ID", this._validationId);
                hashMap.put("INDEX_NO", n);
                if (this._libRef != null) {
                    hashMap.put("LIB_VALIDATION_ID", this._libRef.getLibId());
                    hashMap.put("VALIDATION", DBUtil.NULL_VALUE);
                } else {
                    hashMap.put("LIB_VALIDATION_ID", DBUtil.NULL_VALUE);
                    hashMap.put("VALIDATION", UtUtils.asClob(connection, this._xml));
                }
                hashMap.put("APPLY_VALIDATION", this._applyValidation ? 1 : 0);
                dBUtil.setRaiseError(true);
                int n2 = dBUtil.executeUpdate(string, hashMap);
                if (0 == n2) {
                    throw new ObjectUpdateException();
                }
                bl2 = n2 > 0;
                this._savedIndexNo = n;
                this._dirty = false;
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getLocalizedMessage(), sQLException);
                throw new ObjectUpdateException(sQLException);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl2;
    }
}

