/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.testObjects;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.impexp.ExportContext;
import oracle.dbtools.unit_test.impexp.ImportContext;
import oracle.dbtools.unit_test.impexp.LoggerLevel;
import oracle.dbtools.unit_test.startup.IStartup;
import oracle.dbtools.unit_test.startup.StartupRegistry;
import oracle.dbtools.unit_test.testObjects.ObjectUpdateException;
import oracle.dbtools.unit_test.testObjects.UtLibraryRef;
import oracle.dbtools.unit_test.testObjects.UtSuite;
import oracle.dbtools.unit_test.testObjects.UtTest;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.NodeList;

public class UtStartup {
    private UtTest _test;
    private UtSuite _suite;
    private String _startupId;
    private int _savedIndexNo;
    private UtLibraryRef _libRef;
    private String _xml;
    private boolean _dirty = false;

    public UtStartup(UtTest utTest, UtSuite utSuite, String string, int n, UtLibraryRef utLibraryRef, String string2, boolean bl) {
        this._suite = utSuite;
        this._test = utTest;
        this._startupId = string != null ? string : UUID.randomUUID().toString();
        this._savedIndexNo = n;
        this._libRef = utLibraryRef;
        this._xml = string2;
        this._dirty = bl;
    }

    UtStartup(XMLElement xMLElement, UtTest utTest, UtSuite utSuite, ImportContext importContext) {
        String string;
        this._test = utTest;
        this._suite = utSuite;
        this._savedIndexNo = -1;
        this._startupId = xMLElement.getAttribute("id");
        if (this._startupId == null || this._startupId.equals("")) {
            importContext.log(LoggerLevel.SEVERE, "unexpected null value");
        }
        if ((string = xMLElement.getAttribute("lib_id")) != null && !string.equals("")) {
            if (string == null || string.equals("")) {
                importContext.log(LoggerLevel.SEVERE, "unexpected null value");
            }
            String string2 = xMLElement.getAttribute("lib_name");
            this._libRef = new UtLibraryRef(string, string2);
        } else {
            List<XMLElement> list = importContext.getNestedElements(xMLElement, "startup");
            for (XMLElement xMLElement2 : list) {
                NodeList nodeList = xMLElement2.getChildrenByTagName("name");
                if (nodeList.getLength() != 1) continue;
                XMLElement xMLElement3 = (XMLElement)nodeList.item(0);
                String string3 = xMLElement3.getText();
                IStartup iStartup = StartupRegistry.getInstanceFor(string3);
                if (iStartup == null) {
                    importContext.log(LoggerLevel.SEVERE, "Invalid codehook type name: " + string3);
                    continue;
                }
                iStartup.loadFromXmlElement(xMLElement2);
                this._xml = iStartup.getXml();
            }
        }
    }

    void exportRelated(ExportContext exportContext) {
        if (this._libRef != null) {
            exportContext.exportRelatedLibStartup(this._libRef.getLibId());
        }
    }

    void exportFields(XMLElement xMLElement, ExportContext exportContext) {
        IStartup iStartup;
        XMLElement xMLElement2;
        XMLElement xMLElement3 = exportContext.createExportedElement(xMLElement, "startup");
        xMLElement3.setAttribute("id", this._startupId);
        if (this._libRef != null) {
            xMLElement3.setAttribute("lib_id", this._libRef.getLibId());
            xMLElement3.setAttribute("lib_name", this._libRef.getName());
        } else if (this._xml != null && (xMLElement2 = (iStartup = this.getStartupCodeHook()).getXmlElement()) != null) {
            exportContext.reparentExportedElement(xMLElement3, xMLElement2);
        }
    }

    public String getStartupId() {
        return this._startupId;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public UtTest getTest() {
        return this._test;
    }

    public UtSuite getSuite() {
        return this._suite;
    }

    public void setLibraryRef(UtLibraryRef utLibraryRef) {
        this._libRef = utLibraryRef;
        this._dirty = true;
    }

    public UtLibraryRef getLibraryRef() {
        return this._libRef;
    }

    public void setXml(String string) {
        this._xml = string;
        this._dirty = true;
    }

    public String getXml() {
        return this._xml;
    }

    public IStartup getStartupCodeHook() {
        String string = null;
        String string2 = UtUtils.getXmlValue(this.getXml(), "startup", "class");
        if (string2 != null) {
            string = StartupRegistry.getKeyFor(string2);
        }
        if (string == null || string.equals("")) {
            string = UtUtils.getXmlValue(this.getXml(), "startup", "name");
        }
        if (string == null || string.equals("")) {
            return null;
        }
        IStartup iStartup = StartupRegistry.getInstanceFor(string);
        iStartup.setOwnerId(this.getStartupId());
        iStartup.setLibraryRef(this.getLibraryRef());
        iStartup.loadFromXml(this.getXml());
        return iStartup;
    }

    public void setStartupCodeHook(IStartup iStartup) {
        String string = iStartup.getXml();
        if (this._xml == null && string != null || this._xml != null && !this._xml.equals(string)) {
            this.setXml(string);
        }
        UtLibraryRef utLibraryRef = iStartup.getLibraryRef();
        if (this._libRef == null && utLibraryRef != null || this._libRef != null && !this._libRef.equals(utLibraryRef)) {
            this.setLibraryRef(utLibraryRef);
        }
    }

    boolean save(int n, boolean bl) throws ObjectUpdateException {
        if (!bl && !this._dirty && n == this._savedIndexNo) {
            return true;
        }
        boolean bl2 = false;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string = UtUtils.getQuery("mergeStartup");
                if (this._test == null) {
                    hashMap.put("UT_ID", null);
                } else {
                    hashMap.put("UT_ID", this._test.getId());
                }
                if (this._suite == null) {
                    hashMap.put("UT_SID", null);
                } else {
                    hashMap.put("UT_SID", this._suite.getSid());
                }
                hashMap.put("STARTUP_ID", this._startupId);
                hashMap.put("INDEX_NO", n);
                if (this._libRef != null) {
                    hashMap.put("LIB_STARTUP_ID", this._libRef.getLibId());
                    hashMap.put("STARTUP", DBUtil.NULL_VALUE);
                } else {
                    hashMap.put("LIB_STARTUP_ID", DBUtil.NULL_VALUE);
                    hashMap.put("STARTUP", UtUtils.asClob(connection, this._xml));
                }
                dBUtil.setRaiseError(true);
                int n2 = dBUtil.executeUpdate(string, hashMap);
                if (0 == n2) {
                    throw new ObjectUpdateException();
                }
                bl2 = n2 > 0;
                this._savedIndexNo = n;
                this._dirty = false;
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getLocalizedMessage(), sQLException);
                throw new ObjectUpdateException(sQLException);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl2;
    }
}

