/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.teardown;

import java.util.ArrayList;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import oracle.dbtools.unit_test.teardown.ITeardown;
import oracle.dbtools.unit_test.teardown.NullTeardown;
import oracle.dbtools.unit_test.teardown.PlSqlTeardown;
import oracle.dbtools.unit_test.teardown.TableDropTeardown;
import oracle.dbtools.unit_test.teardown.TableRestoreTeardown;
import oracle.dbtools.unit_test.teardown.TeardownArb;

public class TearDownRegistry {
    private static TreeMap<String, Class> _registry = new TreeMap();

    public static synchronized ArrayList<String> getLovValues() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : _registry.keySet()) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public static synchronized JComboBox getComboBox() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(TeardownArb.getString("NONE"));
        for (String string : _registry.keySet()) {
            jComboBox.addItem(string);
        }
        return jComboBox;
    }

    public static synchronized void registerHandler(String string, Class clazz) {
        if (!ITeardown.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class must be instance of IStartup");
        }
        _registry.put(string, clazz);
    }

    public static synchronized void unregisterHandler(String string) {
        _registry.remove(string);
    }

    public static synchronized Class getClassFor(String string) {
        return _registry.get(string);
    }

    public static synchronized String getKeyFor(String string) {
        String string2 = null;
        for (String string3 : _registry.keySet()) {
            Class clazz = _registry.get(string3);
            if (!clazz.getName().equals(string)) continue;
            string2 = string3;
            break;
        }
        return string2;
    }

    public static ITeardown getInstanceFor(String string) {
        Class clazz = TearDownRegistry.getClassFor(string);
        if (clazz != null) {
            try {
                return (ITeardown)clazz.newInstance();
            }
            catch (Exception exception) {
                Logger.getLogger(TearDownRegistry.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                return null;
            }
        }
        return null;
    }

    public static synchronized boolean isSupported(String string) {
        return _registry.get(string) != null;
    }

    static {
        TearDownRegistry.registerHandler(TeardownArb.getString("NONE"), NullTeardown.class);
        TearDownRegistry.registerHandler(TeardownArb.getString("CODE_TEARDOWN_NAME"), PlSqlTeardown.class);
        TearDownRegistry.registerHandler(TeardownArb.getString("TABLE_RESTORE_TEARDOWN_NAME"), TableRestoreTeardown.class);
        TearDownRegistry.registerHandler(TeardownArb.getString("TABLE_DROP_TEARDOWN_NAME"), TableDropTeardown.class);
    }
}

