/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.startup;

import java.util.ArrayList;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import oracle.dbtools.unit_test.startup.IStartup;
import oracle.dbtools.unit_test.startup.NullStartup;
import oracle.dbtools.unit_test.startup.PlSqlStartup;
import oracle.dbtools.unit_test.startup.StartupArb;
import oracle.dbtools.unit_test.startup.TableCopyStartup;

public class StartupRegistry {
    private static TreeMap<String, Class> _registry = new TreeMap();

    public static synchronized ArrayList<String> getLovValues() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : _registry.keySet()) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public static synchronized JComboBox getComboBox() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(StartupArb.getString("NONE"));
        for (String string : _registry.keySet()) {
            jComboBox.addItem(string);
        }
        return jComboBox;
    }

    public static synchronized void registerStartup(String string, Class clazz) {
        if (!IStartup.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class must be instance of IStartup");
        }
        _registry.put(string, clazz);
    }

    public static synchronized void unregisterStartup(String string) {
        _registry.remove(string);
    }

    public static synchronized Class getClassFor(String string) {
        return _registry.get(string);
    }

    public static synchronized String getKeyFor(String string) {
        String string2 = null;
        for (String string3 : _registry.keySet()) {
            Class clazz = _registry.get(string3);
            if (!clazz.getName().equals(string)) continue;
            string2 = string3;
            break;
        }
        return string2;
    }

    public static IStartup getInstanceFor(String string) {
        Class clazz = StartupRegistry.getClassFor(string);
        if (clazz != null) {
            try {
                return (IStartup)clazz.newInstance();
            }
            catch (Exception exception) {
                Logger.getLogger(StartupRegistry.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                return null;
            }
        }
        return null;
    }

    public static synchronized boolean isSupported(String string) {
        return _registry.get(string) != null;
    }

    static {
        StartupRegistry.registerStartup(StartupArb.getString("NONE"), NullStartup.class);
        StartupRegistry.registerStartup(StartupArb.getString("CODE_STARTUP_NAME"), PlSqlStartup.class);
        StartupRegistry.registerStartup(StartupArb.getString("TABLE_COPY_STARTUP_NAME"), TableCopyStartup.class);
    }
}

