/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.manage_objects;

import java.awt.Component;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.manage_objects.ManageObjectsArb;
import oracle.dbtools.unit_test.manage_objects.PurgeResultsPanel;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.ide.dialogs.OnePageWizardDialogFactory;

public class PurgeResultsDialog {
    private Date date;

    public static boolean purgeAll() {
        PurgeResultsDialog purgeResultsDialog = new PurgeResultsDialog();
        boolean bl = purgeResultsDialog.promptDate(ManageObjectsArb.getString("PURGE_ALL_TITLE"));
        if (bl) {
            purgeResultsDialog.doPurgeAllTests();
            purgeResultsDialog.doPurgeAllSuites();
        }
        return bl;
    }

    public static boolean purgeTest(String string) {
        PurgeResultsDialog purgeResultsDialog = new PurgeResultsDialog();
        boolean bl = purgeResultsDialog.promptDate(ManageObjectsArb.getString("PURGE_TEST_TITLE"));
        if (bl) {
            purgeResultsDialog.doPurgeTest(string);
        }
        return bl;
    }

    public static boolean purgeSuite(String string) {
        PurgeResultsDialog purgeResultsDialog = new PurgeResultsDialog();
        boolean bl = purgeResultsDialog.promptDate(ManageObjectsArb.getString("PURGE_SUITE_TITLE"));
        if (bl) {
            purgeResultsDialog.doPurgeSuite(string);
        }
        return bl;
    }

    private boolean promptDate(String string) {
        PurgeResultsPanel purgeResultsPanel = new PurgeResultsPanel();
        boolean bl = OnePageWizardDialogFactory.runDialog((Component)purgeResultsPanel, (Component)purgeResultsPanel, (String)string, (int)3);
        if (bl) {
            this.date = purgeResultsPanel.getSelectedDate();
        }
        return bl;
    }

    private void doPurgeAllTests() {
        String string = null;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string2 = this.getDateString();
        if (string2 == null) {
            string = "PurgeAllTests";
        } else {
            string = "PurgeAllTestsBefore";
            hashMap.put("BEFORE", string2);
        }
        this.purgeResultsInDB(string, hashMap);
    }

    private void doPurgeAllSuites() {
        String string = null;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string2 = this.getDateString();
        if (string2 == null) {
            string = "PurgeAllSuites";
        } else {
            string = "PurgeAllSuitesBefore";
            hashMap.put("BEFORE", string2);
        }
        this.purgeResultsInDB(string, hashMap);
    }

    private void doPurgeTest(String string) {
        String string2 = null;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("ID", string);
        String string3 = this.getDateString();
        if (string3 == null) {
            string2 = "PurgeTest";
        } else {
            string2 = "PurgeTestBefore";
            hashMap.put("BEFORE", string3);
        }
        this.purgeResultsInDB(string2, hashMap);
    }

    private void doPurgeSuite(String string) {
        String string2 = null;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("ID", string);
        String string3 = this.getDateString();
        if (string3 == null) {
            string2 = "PurgeSuite";
        } else {
            string2 = "PurgeSuiteBefore";
            hashMap.put("BEFORE", string3);
        }
        this.purgeResultsInDB(string2, hashMap);
    }

    private String getDateString() {
        StringBuffer stringBuffer = null;
        if (this.date != null) {
            stringBuffer = new StringBuffer();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.date);
            stringBuffer.append(calendar.get(1));
            stringBuffer.append(' ');
            stringBuffer.append(calendar.get(2) + 1);
            stringBuffer.append(' ');
            stringBuffer.append(calendar.get(5));
            stringBuffer.append(' ');
            stringBuffer.append(calendar.get(11));
            stringBuffer.append(' ');
            stringBuffer.append(calendar.get(12));
            stringBuffer.append(' ');
            stringBuffer.append(calendar.get(13));
            stringBuffer.append(' ');
        }
        return stringBuffer != null ? stringBuffer.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeResultsInDB(String string, HashMap<String, Object> hashMap) {
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string2 = UtUtils.getQuery(string);
                dBUtil.setRaiseError(true);
                dBUtil.executeUpdate(string2, hashMap);
                connection.commit();
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException((Throwable)sQLException);
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
    }
}

