/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.editor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.controls.SquareIconButton;
import oracle.dbtools.unit_test.codehook.CodeHookLookup;
import oracle.dbtools.unit_test.codehook.ICodeHook;
import oracle.dbtools.unit_test.editor.CodeHookEditor;
import oracle.dbtools.unit_test.editor.UiArb;
import oracle.dbtools.unit_test.testObjects.UtLibraryRef;
import oracle.dbtools.unit_test.utils.UiUtils;
import oracle.javatools.icons.OracleIcons;

public class CodeHookPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ICodeHook _codeHook;
    private CodeHookLookup _lookup;
    private JComboBox _subtypeCB;
    private JCheckBox _applyCB;
    private JButton _editBtn;
    private JTextArea _description;
    private UtLibraryRef _libRef;
    private boolean _initialized;
    private boolean _editable;
    public static final String CODE_HOOK = "CODE_HOOK";

    public CodeHookPanel(ICodeHook iCodeHook, CodeHookLookup codeHookLookup) {
        if (null == iCodeHook) {
            throw new NullPointerException();
        }
        this._codeHook = iCodeHook;
        this._lookup = codeHookLookup;
        this.jbInit();
        this.initializeData();
        this.updateView();
    }

    public ICodeHook getCodeHook() {
        return this._codeHook;
    }

    public void setCodeHook(ICodeHook iCodeHook) {
        if (null == iCodeHook) {
            throw new NullPointerException();
        }
        if (this._codeHook != iCodeHook) {
            this._codeHook = iCodeHook;
            this.initializeData();
        }
    }

    private void jbInit() {
        this.setName(this._codeHook.getTitle() + "CodeHookPanel");
        this._subtypeCB = new JComboBox<Object>(this._codeHook.getHookSubtypeNames().toArray());
        UiUtils.nameForQA(this._subtypeCB, "Subtype", this._codeHook.getTitle());
        this._applyCB = new JCheckBox(UiArb.getString("CODE_HOOK_PANEL_APPLY"), this._codeHook.isEnabled());
        this._description = new JTextArea();
        this._description.setEditable(false);
        this._description.setBorder(BorderFactory.createEmptyBorder());
        this._description.setEnabled(false);
        this._editBtn = new SquareIconButton(OracleIcons.getIcon((String)"edit.png"));
        String string = UiUtils.formatNameForQA(this._codeHook.getTitle(), "EditButton");
        this._editBtn.setName(string);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        if (this._codeHook.isEnablable()) {
            groupLayout.setHorizontalGroup(groupLayout.createParallelGroup().addComponent(this._subtypeCB, -2, -1, -2).addComponent(this._applyCB).addGroup(groupLayout.createSequentialGroup().addComponent(this._editBtn).addComponent(this._description)));
            groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addComponent(this._subtypeCB, -2, -1, -2).addComponent(this._applyCB).addGroup(groupLayout.createParallelGroup().addComponent(this._editBtn).addComponent(this._description)));
        } else {
            groupLayout.setHorizontalGroup(groupLayout.createParallelGroup().addComponent(this._subtypeCB, -2, -1, -2).addGroup(groupLayout.createSequentialGroup().addComponent(this._editBtn).addComponent(this._description)));
            groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addComponent(this._subtypeCB, -2, -1, -2).addGroup(groupLayout.createParallelGroup().addComponent(this._editBtn).addComponent(this._description)));
        }
        this.initializeListeners();
    }

    private void initializeListeners() {
        this._subtypeCB.addItemListener(new ItemListener(){
            Object oldItem;

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!CodeHookPanel.this.isInitialized()) {
                    return;
                }
                if (itemEvent.getStateChange() == 2) {
                    this.oldItem = itemEvent.getItem();
                    return;
                }
                String string = itemEvent.getItem().toString();
                if (!string.equals(this.oldItem)) {
                    final ICodeHook iCodeHook = CodeHookPanel.this._codeHook;
                    CodeHookPanel.this._codeHook = iCodeHook.getInstanceFor(string);
                    CodeHookPanel.this._codeHook.setOwnerId(iCodeHook.getOwnerId());
                    if (CodeHookPanel.this.hasEditor()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                boolean bl = CodeHookPanel.this.runEditDialog();
                                if (!bl) {
                                    CodeHookPanel.this.setCodeHook(iCodeHook);
                                }
                            }
                        });
                    } else {
                        CodeHookPanel.this.setDescription(CodeHookPanel.this._codeHook.getDescription());
                        CodeHookPanel.this.setLibraryRef(CodeHookPanel.this._codeHook.getLibraryRef());
                    }
                }
            }
        });
        this._editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CodeHookPanel.this.runEditDialog();
            }
        });
        this._applyCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                CodeHookPanel.this._codeHook.setEnabled(CodeHookPanel.this._applyCB.isSelected());
            }
        });
    }

    private void initializeData() {
        this.setInitialized(false);
        this._subtypeCB.setSelectedItem(this._codeHook.getHookName());
        this.setDescription(this._codeHook.getDescription());
        this.setLibraryRef(this._codeHook.getLibraryRef());
        this.setInitialized(true);
    }

    private void updateView() {
        this._editBtn.setVisible(this.hasEditor());
        this._editBtn.setEnabled(this.isEditable());
        this._subtypeCB.setEnabled(this.isEditable());
        this._applyCB.setEnabled(this.isEditable());
    }

    private boolean hasEditor() {
        return this._codeHook.canGetComponent();
    }

    private boolean isInitialized() {
        return this._initialized;
    }

    private void setInitialized(boolean bl) {
        this._initialized = bl;
    }

    private boolean isEditable() {
        return this._editable;
    }

    public void setEditable(boolean bl) {
        this._editable = bl;
        this.updateView();
    }

    private boolean runEditDialog() {
        String string = this._codeHook.getXml();
        CodeHookEditor codeHookEditor = new CodeHookEditor(this._codeHook, this._lookup);
        boolean bl = codeHookEditor.runDialog();
        if (bl) {
            this.setDescription(this._codeHook.getDescription());
            this.setLibraryRef(this._codeHook.getLibraryRef());
            if (this.isInitialized()) {
                this.firePropertyChange();
            }
        } else {
            this._codeHook.loadFromXml(string);
        }
        return bl;
    }

    private void setDescription(String string) {
        String string2 = string;
        String string3 = this._description.getText();
        if (!string2.equals(string3)) {
            this._description.setText(string2);
            if (this.isInitialized()) {
                this.updateView();
                this.firePropertyChange();
            }
        }
    }

    private void setLibraryRef(UtLibraryRef utLibraryRef) {
        if (this._libRef == null && utLibraryRef != null || this._libRef != null && !this._libRef.equals(utLibraryRef)) {
            this._libRef = utLibraryRef;
            if (this.isInitialized()) {
                this.firePropertyChange();
            }
        }
    }

    protected void firePropertyChange() {
        this.firePropertyChange(CODE_HOOK, null, this._codeHook);
    }

    @Override
    public void requestFocus() {
        this._subtypeCB.requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this._subtypeCB.requestFocusInWindow();
    }

    @Override
    public boolean isFocusable() {
        return false;
    }
}

