/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.create_wizard;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextArea;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import oracle.dbtools.unit_test.create_wizard.CreateWizArb;
import oracle.dbtools.unit_test.create_wizard.CreateWizContext;
import oracle.dbtools.unit_test.create_wizard.CreateWizPanel;
import oracle.dbtools.unit_test.editor.ListTablePanel;
import oracle.dbtools.unit_test.editor.StartupListTableModel;
import oracle.dbtools.unit_test.startup.IStartup;
import oracle.dbtools.unit_test.startup.StartupArb;
import oracle.dbtools.unit_test.startup.StartupRegistry;
import oracle.dbtools.unit_test.testObjects.UtTest;

public class CreateWizStartup
extends CreateWizPanel {
    private static final long serialVersionUID = 1L;
    private ListTablePanel<IStartup> _startupPanel;

    public CreateWizStartup() {
        this.setLayout(new GridBagLayout());
    }

    private void init() {
        this.removeAll();
        Insets insets = new Insets(10, 10, 10, 10);
        JTextArea jTextArea = new JTextArea(CreateWizArb.getString("STARTUP_LABEL"));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        jTextArea.setBorder(null);
        this.add(jTextArea, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        ArrayList arrayList = new ArrayList();
        final StartupListTableModel startupListTableModel = new StartupListTableModel(this.getCreateWizContext().getCodeHookLookup()){

            @Override
            protected List<IStartup> add() {
                String string = StartupArb.getString("NONE");
                IStartup iStartup = StartupRegistry.getInstanceFor(string);
                iStartup.loadFromXml(null);
                ArrayList<IStartup> arrayList = new ArrayList<IStartup>();
                arrayList.add(iStartup);
                return arrayList;
            }
        };
        startupListTableModel.setRowList(arrayList);
        this._startupPanel = new ListTablePanel<IStartup>(startupListTableModel);
        this.add(this._startupPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, insets, 0, 0));
        if (this.getCreateWizContext().getUseSeeding()) {
            this._startupPanel.setEditable(false);
        } else {
            UtTest utTest = this.getCreateWizContext().getTest();
            if (utTest != null) {
                utTest.setStartupCodeHooks(null);
                this.getCreateWizContext().setStartupHooks(null);
                startupListTableModel.addTableModelListener(new TableModelListener(){

                    @Override
                    public void tableChanged(TableModelEvent tableModelEvent) {
                        List<IStartup> list = startupListTableModel.getRowList();
                        CreateWizContext createWizContext = CreateWizStartup.this.getCreateWizContext();
                        createWizContext.setStartupHooks(list);
                        UtTest utTest = createWizContext.getTest();
                        utTest.setStartupCodeHooks(list);
                    }
                });
            }
            this._startupPanel.setEditable(utTest != null);
        }
    }

    @Override
    protected void onEntryTestChanged() {
        this.init();
    }

    @Override
    protected void onEntrySeedingChanged() {
        this.init();
    }

    public Object getExitTransition() {
        return "PARAMETERS_TRANS";
    }
}

