/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionException;
import oracle.dbtools.raptor.datatypes.LockableDataTypeConnectionProvider;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.javatools.db.DBException;
import oracle.jdbc.OracleConnection;
import oracle.jdeveloper.db.ConnectionException;

public class UtDataTypeConnectionProvider
extends LockableDataTypeConnectionProvider<OracleConnection> {
    protected String dbQualName;
    public static final String DB_QUAL_NAME = "dbQualName";

    public UtDataTypeConnectionProvider() {
        super(OracleConnection.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleConnection getDataTypeConnection() {
        OracleConnection oracleConnection = (OracleConnection)this.peekDataTypeConnection();
        if (oracleConnection == null) {
            String string = UtUtils.getDataConnection(this.peekDataTypeConnectionQualName());
            try {
                if (string != null) {
                    oracleConnection = (OracleConnection)UtUtils.openDataConnection(string);
                }
            }
            catch (RuntimeException runtimeException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, runtimeException.getLocalizedMessage(), runtimeException);
                if (runtimeException instanceof DataTypeConnectionException) {
                    throw runtimeException;
                }
            }
            catch (DBException dBException) {
                if (dBException.getCause() instanceof ConnectionCanceledException) {
                    throw new DataTypeConnectionException(dBException.getCause());
                }
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, dBException.getLocalizedMessage(), dBException);
            }
            catch (ConnectionException connectionException) {
                if (connectionException.getCause() instanceof ConnectionCanceledException) {
                    throw new DataTypeConnectionException(connectionException.getCause());
                }
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, connectionException.getLocalizedMessage(), connectionException);
            }
            finally {
                if (oracleConnection == null) {
                    this.setDataTypeConnectionQualName(null);
                } else {
                    this.setDataTypeConnectionQualName(string);
                    this.setDataTypeConnection((Connection)oracleConnection);
                }
            }
        }
        return oracleConnection;
    }

    public OracleConnection getValidDataTypeConnection() {
        boolean bl;
        OracleConnection oracleConnection = (OracleConnection)this.peekDataTypeConnection();
        try {
            bl = oracleConnection != null && !oracleConnection.isClosed();
        }
        catch (SQLException sQLException) {
            bl = false;
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getLocalizedMessage(), sQLException);
        }
        if (!bl) {
            this.setDataTypeConnection(null);
            oracleConnection = this.getDataTypeConnection();
        }
        return oracleConnection;
    }

    public String getDataTypeConnectionQualName() {
        return this.peekDataTypeConnectionQualName();
    }

    public String peekDataTypeConnectionQualName() {
        return this.dbQualName;
    }

    public void setDataTypeConnectionQualName(String string) {
        if (!this.areEqual(string, this.dbQualName)) {
            String string2 = this.dbQualName;
            this.dbQualName = string;
            this.firePropertyChange(DB_QUAL_NAME, string2, this.dbQualName);
            this.setDataTypeConnection(null);
        }
    }

    private boolean areEqual(Object object, Object object2) {
        if (null == object) {
            return null == object2;
        }
        return object.equals(object2);
    }

    public OracleConnection getNLSConnection() {
        return this.peekNLSConnection();
    }

    public OracleConnection peekNLSConnection() {
        return (OracleConnection)UtAddin.getRepositoryManager().getConnection();
    }

    public OracleConnection getValidNLSConnection() {
        return this.getNLSConnection();
    }
}

