/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.UtAddinArb;
import oracle.dbtools.unit_test.editor.UtEditor;
import oracle.dbtools.unit_test.impexp.ImportListener;
import oracle.dbtools.unit_test.impexp.ImportManager;
import oracle.dbtools.unit_test.manage_objects.PurgeResultsDialog;
import oracle.dbtools.unit_test.manage_user.UserDialog;
import oracle.dbtools.unit_test.manage_user.UserStrings;
import oracle.dbtools.unit_test.manage_user.UserUtils;
import oracle.dbtools.unit_test.navigator.nodes.RootFolder;
import oracle.dbtools.unit_test.repository.RepositoryManager;
import oracle.dbtools.unit_test.testObjects.UtLibraryItem;
import oracle.dbtools.unit_test.testObjects.UtSuite;
import oracle.dbtools.unit_test.testObjects.UtTest;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.TriggerController;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.db.ConnectionException;

public class UtController
implements TriggerController {
    private static List _noTaskInProgressRequiredActions = new ArrayList();
    private static List _isOpenAndNoTaskRequiredActions = new ArrayList();

    private void createRepo() {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(UtAddinArb.getString("CREATE_REPO_TASK"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

            protected Void doWork() throws TaskException {
                try {
                    boolean bl;
                    Connection connection = UtAddin.getRepositoryManager().getConnection();
                    boolean bl2 = bl = RepositoryManager.doesRepositoryExist(connection) && RepositoryManager.isCurrentVersion(connection);
                    if (bl) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("REPO_MUST_NOT_EXIST"), (String)UtAddinArb.getString("ERROR"), null);
                        return null;
                    }
                    if (UserUtils.ensureRolesSetup(connection, UtAddin.getRepositoryManager().getName())) {
                        RaptorTask<Void> raptorTask = new RaptorTask<Void>(UtAddinArb.getString("CREATE_REPO_TASK"), true, IRaptorTaskRunMode.MODAL_OPTIONAL){

                            protected Void doWork() throws TaskException {
                                try {
                                    RepositoryManager repositoryManager = new RepositoryManager();
                                    repositoryManager.installRepository(UtAddin.getRepositoryManager().getConnection());
                                    UtAddin.openRepository(UtAddin.getRepositoryConnectionName());
                                    this.setMessage(UtAddinArb.getString("CREATE_REPO_TASK_SUCCEEDED"));
                                }
                                catch (Exception exception) {
                                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                                    this.setMessage(UtAddinArb.format("RUN_FAILED", exception.getLocalizedMessage()));
                                    throw new TaskException((Throwable)exception);
                                }
                                return null;
                            }
                        };
                        UtController.this.runTask((RaptorTask<Void>)((RaptorTask)raptorTask));
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    this.setMessage(UtAddinArb.format("RUN_FAILED", exception.getLocalizedMessage()));
                    throw new TaskException((Throwable)exception);
                }
                return null;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    private void dropRepo() {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(UtAddinArb.getString("DROP_REPO_TASK"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

            protected Void doWork() throws TaskException {
                try {
                    boolean bl = RepositoryManager.doesRepositoryExist(UtAddin.getRepositoryManager().getConnection());
                    boolean bl2 = UtUtils.isAdmin();
                    boolean bl3 = UtUtils.isLocalRepos();
                    if (!bl || !bl3) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("LOCAL_REPO_MUST_EXIST"), (String)UtAddinArb.getString("ERROR"), null);
                        return null;
                    }
                    if (!bl2) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("MUST_BE_ADMIN"), (String)UtAddinArb.getString("ERROR"), null);
                        return null;
                    }
                    boolean bl4 = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("CONFIRM_DROP_REPOS"), (String)UtAddinArb.getString("CONFIRM_DROP_REPOS_TITLE"), null, (boolean)true);
                    if (bl4) {
                        RaptorTask<Void> raptorTask = new RaptorTask<Void>(UtAddinArb.getString("DROP_REPO_TASK"), true, IRaptorTaskRunMode.MODAL_OPTIONAL){

                            protected Void doWork() throws TaskException {
                                try {
                                    RepositoryManager repositoryManager = new RepositoryManager();
                                    repositoryManager.dropRepository(UtAddin.getRepositoryManager().getConnection());
                                    String string = UtAddin.getRepositoryManager().getName();
                                    UtController.this.clearCurrentRepo();
                                    UtAddin.openRepository(string);
                                    if (RepositoryManager.doesRepositoryExist(UtAddin.getRepositoryManager().getConnection())) {
                                        this.setMessage(UtAddinArb.getString("DROP_REPO_TASK_SUCCEEDED_SHARED_REPO"));
                                    } else {
                                        this.setMessage(UtAddinArb.getString("DROP_REPO_TASK_SUCCEEDED"));
                                    }
                                }
                                catch (Exception exception) {
                                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                                    this.setMessage(UtAddinArb.format("RUN_FAILED", exception.getLocalizedMessage()));
                                    throw new TaskException((Throwable)exception);
                                }
                                return null;
                            }
                        };
                        UtController.this.runTask((RaptorTask<Void>)((RaptorTask)raptorTask));
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    this.setMessage(UtAddinArb.format("RUN_FAILED", exception.getLocalizedMessage()));
                    throw new TaskException((Throwable)exception);
                }
                return null;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    private void purgeResults() {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(UtAddinArb.getString("PURGE_REPO_TASK"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

            protected Void doWork() throws TaskException {
                try {
                    boolean bl = RepositoryManager.doesRepositoryExist(UtAddin.getRepositoryManager().getConnection());
                    boolean bl2 = UtUtils.isAdmin();
                    if (!bl) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("REPO_MUST_EXIST"), (String)UtAddinArb.getString("ERROR"), null);
                        return null;
                    }
                    if (!bl2) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("MUST_BE_ADMIN"), (String)UtAddinArb.getString("ERROR"), null);
                        return null;
                    }
                    PurgeResultsDialog.purgeAll();
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    this.setMessage(UtAddinArb.format("RUN_FAILED", exception.getLocalizedMessage()));
                    throw new TaskException((Throwable)exception);
                }
                return null;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    private void purgeRepo() {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(UtAddinArb.getString("PURGE_REPO_TASK"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

            protected Void doWork() throws TaskException {
                try {
                    boolean bl = RepositoryManager.doesRepositoryExist(UtAddin.getRepositoryManager().getConnection());
                    boolean bl2 = UtUtils.isAdmin();
                    if (!bl) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("REPO_MUST_EXIST"), (String)UtAddinArb.getString("ERROR"), null);
                        return null;
                    }
                    if (!bl2) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("MUST_BE_ADMIN"), (String)UtAddinArb.getString("ERROR"), null);
                        return null;
                    }
                    if (RepositoryManager.getCurentRepoVersion(UtAddin.getRepositoryManager().getConnection()) < 0) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("BAD_REPO"), (String)UtAddinArb.getString("ERROR"), null);
                        return null;
                    }
                    boolean bl3 = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("CONFIRM_PURGE_REPOS"), (String)UtAddinArb.getString("CONFIRM_PURGE_REPOS_TITLE"), null, (boolean)true);
                    if (bl3) {
                        RaptorTask<Void> raptorTask = new RaptorTask<Void>(UtAddinArb.getString("PURGE_REPO_TASK"), true, IRaptorTaskRunMode.MODAL_OPTIONAL){

                            protected Void doWork() throws TaskException {
                                try {
                                    RepositoryManager repositoryManager = new RepositoryManager();
                                    repositoryManager.purgeRepository(UtAddin.getRepositoryManager().getConnection());
                                    UtAddin.closeAllEditorsDefer();
                                    String string = UtAddin.getRepositoryConnectionName();
                                    if (string != null) {
                                        UtAddin.closeRepository();
                                        UtAddin.closeAllEditorsDefer();
                                        UtAddin.openRepository(string);
                                    }
                                    this.setMessage(UtAddinArb.getString("PURGE_REPO_TASK_SUCCEEDED"));
                                }
                                catch (Exception exception) {
                                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                                    this.setMessage(UtAddinArb.format("RUN_FAILED", exception.getLocalizedMessage()));
                                    throw new TaskException((Throwable)exception);
                                }
                                return null;
                            }
                        };
                        UtController.this.runTask((RaptorTask<Void>)((RaptorTask)raptorTask));
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    this.setMessage(UtAddinArb.format("RUN_FAILED", exception.getLocalizedMessage()));
                    throw new TaskException((Throwable)exception);
                }
                return null;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    private void setCurrentRepo() {
        final String string = ConnectionSelectorUI.getConnection((String)UtAddinArb.getString("UT_REPOSITORY_CONNECTION_CHOICE_TITLE"), (String)UtAddinArb.getString("UT_REPOSITORY_CONNECTION_CHOICE_LABEL"), null, (boolean)true, (boolean)false);
        if (string == null) {
            return;
        }
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(UtAddinArb.getString("REPO_TASK"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

            protected Void doWork() throws TaskException {
                try {
                    UtAddin.openRepository(string);
                    Connection connection = UtAddin.getRepositoryManager().getConnection();
                    if (connection == null) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("BAD_CONNECTION"), (String)UtAddinArb.getString("ERROR"), null);
                        return null;
                    }
                    boolean bl = false;
                    if (!RepositoryManager.doesRepositoryExist(connection)) {
                        bl = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("NO_REPO_QUERY"), (String)UserStrings.getString("INFO_TITLE"), null);
                    } else if (!RepositoryManager.isCurrentVersion(connection)) {
                        if (RepositoryManager.getCurentRepoVersion(connection) < 0) {
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("BAD_REPO"), (String)UtAddinArb.getString("ERROR"), null);
                        } else {
                            bl = UtUtils.isLocalRepos() ? MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("BAD_VERSION_QUERY"), (String)UtAddinArb.getString("ERROR"), null) : MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("BAD_SHARED_VERSION_QUERY"), (String)UtAddinArb.getString("ERROR"), null);
                        }
                    }
                    if (bl) {
                        UtController.this.createRepo();
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    this.setMessage(UtAddinArb.format("RUN_FAILED", exception.getLocalizedMessage()));
                    throw new TaskException((Throwable)exception);
                }
                return null;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    private void clearCurrentRepo() {
        if (UtAddin.isRepositoryOpen()) {
            UtAddin.closeRepository();
            UtAddin.closeAllEditorsDefer();
        }
    }

    private void showSharedRepo() {
        System.out.println("SHOW SHARED REPO DAMN YOU!");
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(UtAddinArb.getString("REPO_TASK"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

            protected Void doWork() throws TaskException {
                try {
                    boolean bl = RepositoryManager.doesRepositoryExist(UtAddin.getRepositoryManager().getConnection());
                    boolean bl2 = UtUtils.isLocalRepos();
                    boolean bl3 = UtUtils.isGrantsValid();
                    String string = UtUtils.getUserName(UtAddin.getRepositoryManager().getConnection());
                    String string2 = UtUtils.getSharedRepositoryOwner();
                    if (string2 != null && bl && bl3) {
                        if (bl2 && !string.equals(string2)) {
                            MessageDialog.information((Component)Ide.getMainWindow(), (Object)UtAddinArb.format("SHARED_REPO_ACCESS_LOCAL", string2, UtUtils.getUserName(UtAddin.getRepositoryManager().getConnection())), (String)UtAddinArb.getString("SHARED_REPO_TITLE"), null);
                        } else {
                            MessageDialog.information((Component)Ide.getMainWindow(), (Object)UtAddinArb.format("SHARED_REPO_ACCESS_SHARED", string2), (String)UtAddinArb.getString("SHARED_REPO_TITLE"), null);
                        }
                    } else {
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("NO_SHARED_REPO"), (String)UtAddinArb.getString("SHARED_REPO_TITLE"), null);
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    this.setMessage(UtAddinArb.format("RUN_FAILED", exception.getLocalizedMessage()));
                    throw new TaskException((Throwable)exception);
                }
                return null;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    private void createSynonyms() {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(UtAddinArb.getString("CREATE_SYNS_TASK"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

            protected Void doWork() throws TaskException {
                try {
                    boolean bl = RepositoryManager.doesRepositoryExist(UtAddin.getRepositoryManager().getConnection());
                    boolean bl2 = UtUtils.isAdmin();
                    boolean bl3 = UtUtils.isLocalRepos();
                    boolean bl4 = UtUtils.isSynonymsValid();
                    boolean bl5 = UtUtils.isGrantsValid();
                    if (!bl || !bl3) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("LOCAL_REPO_MUST_EXIST"), (String)UtAddinArb.getString("ERROR"), null);
                        return null;
                    }
                    if (!bl2) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("MUST_BE_ADMIN"), (String)UtAddinArb.getString("ERROR"), null);
                        return null;
                    }
                    if (bl4 && bl5) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("SHARED_REPOS_MUST_NOT_EXIST"), (String)UtAddinArb.getString("ERROR"), null);
                        return null;
                    }
                    if (RepositoryManager.getCurentRepoVersion(UtAddin.getRepositoryManager().getConnection()) < 0) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("BAD_REPO"), (String)UtAddinArb.getString("ERROR"), null);
                        return null;
                    }
                    RaptorTask<Void> raptorTask = new RaptorTask<Void>(UtAddinArb.getString("CREATE_SYNS_TASK"), true, IRaptorTaskRunMode.MODAL_OPTIONAL){

                        protected Void doWork() throws TaskException {
                            try {
                                RepositoryManager repositoryManager = new RepositoryManager();
                                repositoryManager.createSynonyms(UtAddin.getRepositoryManager().getConnection());
                                this.setMessage(UtAddinArb.getString("CREATE_SYNS_TASK_SUCCEEDED"));
                            }
                            catch (Exception exception) {
                                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                                this.setMessage(UtAddinArb.format("RUN_FAILED", exception.getLocalizedMessage()));
                                throw new TaskException((Throwable)exception);
                            }
                            return null;
                        }
                    };
                    UtController.this.runTask((RaptorTask<Void>)((RaptorTask)raptorTask));
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    this.setMessage(UtAddinArb.format("RUN_FAILED", exception.getLocalizedMessage()));
                    throw new TaskException((Throwable)exception);
                }
                return null;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    private void dropSynonyms() {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(UtAddinArb.getString("DROP_SYNS_TASK"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

            protected Void doWork() throws TaskException {
                try {
                    boolean bl = UtUtils.isAdmin();
                    boolean bl2 = UtUtils.isGrantsValid();
                    boolean bl3 = UtUtils.isSynonymsValid();
                    if (!bl) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("MUST_BE_ADMIN"), (String)UtAddinArb.getString("ERROR"), null);
                        return null;
                    }
                    if (!bl2 || !bl3) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("SHARED_REPO_MUST_EXIST"), (String)UtAddinArb.getString("ERROR"), null);
                        return null;
                    }
                    if (RepositoryManager.getCurentRepoVersion(UtAddin.getRepositoryManager().getConnection()) < 0) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("BAD_REPO"), (String)UtAddinArb.getString("ERROR"), null);
                        return null;
                    }
                    RaptorTask<Void> raptorTask = new RaptorTask<Void>(UtAddinArb.getString("DROP_SYNS_TASK"), true, IRaptorTaskRunMode.MODAL_OPTIONAL){

                        protected Void doWork() throws TaskException {
                            try {
                                RepositoryManager repositoryManager = new RepositoryManager();
                                repositoryManager.dropSynonyms(UtAddin.getRepositoryManager().getConnection());
                                this.setMessage(UtAddinArb.getString("DROP_SYNS_TASK_SUCCEEDED"));
                            }
                            catch (Exception exception) {
                                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                                this.setMessage(UtAddinArb.format("RUN_FAILED", exception.getLocalizedMessage()));
                                throw new TaskException((Throwable)exception);
                            }
                            return null;
                        }
                    };
                    UtController.this.runTask((RaptorTask<Void>)((RaptorTask)raptorTask));
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    this.setMessage(UtAddinArb.format("RUN_FAILED", exception.getLocalizedMessage()));
                    throw new TaskException((Throwable)exception);
                }
                return null;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    private void manageUsers() {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(UtAddinArb.getString("REPO_TASK"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void doWork() throws TaskException {
                try {
                    String string = ConnectionSelectorUI.getConnection((String)UtAddinArb.getString("UT_USER_ADMIN_CONNECTION_CHOICE_TITLE"), (String)UtAddinArb.getString("UT_USER_ADMIN_CONNECTION_CHOICE_LABEL"), null, (boolean)true, (boolean)false);
                    if (string == null) {
                        return null;
                    }
                    try {
                        Connection connection = Connections.getInstance().getUniqueConnection(string);
                        try {
                            UserDialog userDialog = new UserDialog(connection, string);
                            userDialog.loadDialog();
                        }
                        finally {
                            try {
                                connection.close();
                            }
                            catch (SQLException sQLException) {
                                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                            }
                        }
                    }
                    catch (ConnectionException connectionException) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("BAD_CONNECTION"), (String)UtAddinArb.getString("ERROR"), null);
                        return null;
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    this.setMessage(UtAddinArb.format("RUN_FAILED", exception.getLocalizedMessage()));
                    throw new TaskException((Throwable)exception);
                }
                return null;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    private void importFile() {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(UtAddinArb.getString("CREATE_REPO_TASK"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

            protected Void doWork() throws TaskException {
                try {
                    Object object;
                    boolean bl = RepositoryManager.doesRepositoryExist(UtAddin.getRepositoryManager().getConnection());
                    if (!bl) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("REPO_MUST_EXIST"), (String)UtAddinArb.getString("ERROR"), null);
                        return null;
                    }
                    boolean bl2 = false;
                    Object object2 = EditorManager.getEditorManager().getAllEditors().iterator();
                    while (object2.hasNext()) {
                        object = (Editor)object2.next();
                        if (!(object instanceof UtEditor)) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) {
                        if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("IMPORT_CLOSE_OPEN_EDITORS"), (String)UtAddinArb.getString("IMPORT_CLOSE_OPEN_EDITORS_TITLE"), null)) {
                            return null;
                        }
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                ArrayList<Editor> arrayList = new ArrayList<Editor>();
                                for (Editor editor : EditorManager.getEditorManager().getAllEditors()) {
                                    if (!(editor instanceof UtEditor)) continue;
                                    arrayList.add(editor);
                                }
                                if (!arrayList.isEmpty()) {
                                    EditorManager.getEditorManager().closeEditors(arrayList);
                                }
                            }
                        });
                    }
                    if ((object2 = UtController.this.getImportInfo()) != null) {
                        object = new RaptorTask<Void>(DataImportArb.getString((String)"DATA_FILE_IMPORT_LABEL"), true, IRaptorTaskRunMode.MODAL_OPTIONAL, (ImportInfo)object2){
                            final /* synthetic */ ImportInfo val$importInfo;
                            {
                                this.val$importInfo = importInfo;
                                super(string, bl, iRaptorTaskRunMode);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            protected Void doWork() throws TaskException {
                                Object object;
                                ImportManager importManager = null;
                                String string = null;
                                try {
                                    importManager = new ImportManager(this.val$importInfo.fileInfo.reader, this.val$importInfo.conflictOption);
                                    object = new TreeSet();
                                    TreeSet treeSet = new TreeSet();
                                    try {
                                        importManager.importObjects(new ImportListener((TreeSet)object, treeSet){
                                            final /* synthetic */ TreeSet val$objectNames;
                                            final /* synthetic */ TreeSet val$skippedObjectNames;
                                            {
                                                this.val$objectNames = treeSet;
                                                this.val$skippedObjectNames = treeSet2;
                                            }

                                            @Override
                                            public void onImportTest(UtTest utTest) {
                                                this.val$objectNames.add(utTest.getTestName());
                                            }

                                            @Override
                                            public void onImportSuite(UtSuite utSuite) {
                                                this.val$objectNames.add(utSuite.getSuiteName());
                                            }

                                            @Override
                                            public void onImportLibraryItem(UtLibraryItem utLibraryItem) {
                                                this.val$objectNames.add(utLibraryItem.getRef().getName());
                                            }

                                            @Override
                                            public void onSkipTest(UtTest utTest) {
                                                this.val$skippedObjectNames.add(utTest.getTestName());
                                            }

                                            @Override
                                            public void onSkipSuite(UtSuite utSuite) {
                                                this.val$skippedObjectNames.add(utSuite.getSuiteName());
                                            }

                                            @Override
                                            public void onSkipLibraryItem(UtLibraryItem utLibraryItem) {
                                                this.val$skippedObjectNames.add(utLibraryItem.getRef().getName());
                                            }
                                        });
                                    }
                                    finally {
                                        importManager.close();
                                    }
                                    if (importManager.getErrorMessage() == null) {
                                        StringBuffer stringBuffer = new StringBuffer();
                                        stringBuffer.append(UtAddinArb.getString("IMPORT_IMPORTED_OBJECTS"));
                                        if (((TreeSet)object).size() > 0) {
                                            Iterator iterator = ((TreeSet)object).iterator();
                                            while (iterator.hasNext()) {
                                                String string2 = (String)iterator.next();
                                                stringBuffer.append("\n  ");
                                                stringBuffer.append(string2);
                                            }
                                        } else {
                                            stringBuffer.append("\n  ");
                                            stringBuffer.append(UtAddinArb.getString("IMPORT_NONE"));
                                        }
                                        stringBuffer.append("\n");
                                        if (treeSet.size() > 0) {
                                            stringBuffer.append(UtAddinArb.getString("IMPORT_SKIPPED_OBJECTS"));
                                            for (String string2 : treeSet) {
                                                stringBuffer.append("\n  ");
                                                stringBuffer.append(string2);
                                            }
                                            stringBuffer.append("\n");
                                        }
                                        string = stringBuffer.toString();
                                        this.setMessage(string);
                                    }
                                }
                                catch (Exception exception) {
                                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                                    String string3 = UtAddinArb.getString("IMPORT_FAILED") + "\n  " + exception.getLocalizedMessage();
                                    if (string != null) {
                                        string3 = string3 + "\n\n" + string;
                                    }
                                    this.setMessage(string3);
                                    throw new TaskException((Throwable)exception);
                                }
                                if (importManager.getErrorMessage() != null) {
                                    object = UtAddinArb.getString("IMPORT_FAILED") + "\n  " + importManager.getErrorMessage();
                                    if (string != null) {
                                        object = (String)object + "\n\n" + string;
                                    }
                                    this.setMessage((String)object);
                                    throw new TaskException((Throwable)new Exception());
                                }
                                UpdateMessage.fireStructureChanged((Subject)RootFolder.getInstance());
                                return null;
                            }
                        };
                        UtController.this.runTask((RaptorTask<Void>)((RaptorTask)object));
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    this.setMessage(UtAddinArb.format("RUN_FAILED", exception.getLocalizedMessage()));
                    throw new TaskException((Throwable)exception);
                }
                return null;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    private ImportInfo getImportInfo() {
        ImportInfo importInfo = null;
        JPanel jPanel = new JPanel(new GridBagLayout());
        final JTextField jTextField = new JTextField(UtUtils.getDefaultImportExportDirectory() + File.separator + "*.xml", 40);
        JButton jButton = new JButton(UtAddinArb.getString("IMPORT_BROWSE_LABEL"));
        JComboBox<Object> jComboBox = new JComboBox<Object>(new Object[]{new ImportOption(UtAddinArb.getString("IMPORT_OVERWRITE_LABEL"), ImportManager.ConflictOption.OVERWRITE), new ImportOption(UtAddinArb.getString("IMPORT_SKIP_LABEL"), ImportManager.ConflictOption.SKIP)});
        jPanel.add((Component)new JLabel(UtAddinArb.getString("IMPORT_FILE_LABEL")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        jPanel.add((Component)jTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(10, 10, 0, 0), 0, 0));
        jPanel.add((Component)jButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
        jPanel.add((Component)new JLabel(UtAddinArb.getString("IMPORT_CONFLICT_LABEL")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        jPanel.add(jComboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_import_info_dialog_html");
        final ImportInfo importInfo2 = new ImportInfo();
        importInfo2.fileInfo = new UtUtils.ImportFileInfo();
        importInfo2.fileInfo.encoding = IdeUtil.getIdeEncoding();
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UtUtils.ImportFileInfo importFileInfo = UtUtils.getImportFileReader(jTextField.getText());
                if (importFileInfo != null) {
                    importInfo2.fileInfo = importFileInfo;
                    jTextField.setText(importFileInfo.fileName);
                }
            }
        });
        boolean bl = OnePageWizardDialogFactory.runDialog((Component)jPanel, (Component)jTextField, (String)UtAddinArb.getString("IMPORT_UNIT_TESTS_TITLE"));
        if (bl) {
            String string = jTextField.getText();
            if (string.equals("")) {
                string = null;
            }
            if (string == null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("IMPORT_EMPTY_PATH"), (String)UtAddinArb.getString("IMPORT_EMPTY_PATH_TITLE"), null);
            } else if (!string.equals(importInfo2.fileInfo.fileName)) {
                try {
                    importInfo2.fileInfo.reader = new InputStreamReader((InputStream)new FileInputStream(string), importInfo2.fileInfo.encoding);
                }
                catch (IOException iOException) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("IMPORT_BAD_PATH"), (String)UtAddinArb.getString("IMPORT_BAD_PATH_TITLE"), null);
                    string = null;
                }
            }
            if (string != null) {
                importInfo2.fileInfo.fileName = string;
                importInfo2.conflictOption = ((ImportOption)jComboBox.getSelectedItem()).conflictOption();
                importInfo = importInfo2;
            }
        }
        return importInfo;
    }

    private void createDemo() {
        String string = ConnectionSelectorUI.getConnection((String)UtAddinArb.getString("UT_DEMO_CONNECTION_CHOICE_TITLE"), (String)UtAddinArb.getString("UT_DEMO_CONNECTION_CHOICE_LABEL"), null, (boolean)true, (boolean)false);
        if (string == null) {
            return;
        }
        try {
            final ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
            final Connection connection = Connections.getInstance().getUniqueConnection(string);
            if (RepositoryManager.doesRepositoryExist(connection)) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("REPOS_USER"), (String)UtAddinArb.getString("ERROR"), null);
                return;
            }
            RaptorTask<Void> raptorTask = new RaptorTask<Void>(UtAddinArb.getString("CREATE_DEMO_TASK"), true, IRaptorTaskRunMode.MODAL_OPTIONAL){

                protected Void doWork() throws TaskException {
                    URL uRL = RepositoryManager.class.getResource("testSchema.sql");
                    scriptRunnerContext.setTopLevel(true);
                    scriptRunnerContext.setLastUrl(uRL);
                    scriptRunnerContext.setSqlError(1);
                    scriptRunnerContext.setOsError(5);
                    BufferedOutputStream bufferedOutputStream = null;
                    ByteArrayOutputStream byteArrayOutputStream = null;
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
                    ScriptExecutor scriptExecutor = new ScriptExecutor(uRL, connection);
                    scriptExecutor.setScriptRunnerContext(scriptRunnerContext);
                    scriptExecutor.setOut(bufferedOutputStream);
                    scriptExecutor.setName("Migration Execution Thread");
                    scriptExecutor.run();
                    if (scriptRunnerContext.getProperty("sqldev.error").equals(Boolean.TRUE)) {
                        String string = (String)scriptRunnerContext.getProperty("sqldev.last.err.message");
                        this.setMessage(UtAddinArb.format("RUN_FAILED", string));
                        throw new TaskException((Throwable)new Exception("script run error"));
                    }
                    this.setMessage(UtAddinArb.getString("CREATE_DEMO_TASK_SUCCEEDED"));
                    return null;
                }
            };
            this.runTask(raptorTask);
        }
        catch (ConnectionException connectionException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("BAD_CONNECTION"), (String)UtAddinArb.getString("ERROR"), null);
            return;
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        boolean bl = false;
        String string = Ide.findCmdName((int)ideAction.getCommandId());
        if ("CreateUTRepository".equals(string)) {
            this.createRepo();
            bl = true;
        } else if ("DropUTRepository".equals(string)) {
            this.dropRepo();
            bl = true;
        } else if ("PurgeUTResults".equals(string)) {
            this.purgeResults();
            bl = true;
        } else if ("PurgeUTRepository".equals(string)) {
            this.purgeRepo();
            bl = true;
        } else if ("DefaultUTRepository".equals(string)) {
            this.setCurrentRepo();
            bl = true;
        } else if ("UnsetUTRepository".equals(string)) {
            this.clearCurrentRepo();
            bl = true;
        } else if ("ShowShared".equals(string)) {
            this.showSharedRepo();
            bl = true;
        } else if ("CreateSynonyms".equals(string)) {
            this.createSynonyms();
            bl = true;
        } else if ("DropSynonyms".equals(string)) {
            this.dropSynonyms();
            bl = true;
        } else if ("ManageUsers".equals(string)) {
            this.manageUsers();
            bl = true;
        } else if ("ImportFile".equals(string)) {
            this.importFile();
            bl = true;
        } else if ("CreateDemo".equals(string)) {
            this.createDemo();
            bl = true;
        }
        return bl;
    }

    public boolean update(IdeAction ideAction, Context context) {
        boolean bl = false;
        String string = Ide.findCmdName((int)ideAction.getCommandId());
        if ("CreateDemo".equals(string)) {
            ideAction.setEnabled(true);
            bl = true;
        } else if ("DefaultUTRepository".equals(string)) {
            if (this.isTaskInProgress()) {
                ideAction.setEnabled(false);
            } else {
                ideAction.setEnabled(!UtAddin.isRepositoryOpen());
            }
            bl = true;
        } else if (_noTaskInProgressRequiredActions.contains(string)) {
            ideAction.setEnabled(!this.isTaskInProgress());
            bl = true;
        } else if (_isOpenAndNoTaskRequiredActions.contains(string)) {
            if (this.isTaskInProgress()) {
                ideAction.setEnabled(false);
            } else {
                ideAction.setEnabled(UtAddin.isRepositoryOpen());
            }
            bl = true;
        }
        return bl;
    }

    private void runTask(RaptorTask<Void> raptorTask) {
        UtAddin.getRepositoryManager().runTask(raptorTask);
    }

    private boolean isTaskInProgress() {
        return UtAddin.getRepositoryManager().isTaskInProgress();
    }

    public Object getInvalidStateMessage(IdeAction ideAction, Context context) {
        return UtAddinArb.getString("UT_OPERATION_INVALID");
    }

    static {
        _noTaskInProgressRequiredActions.add("ManageUsers");
        _isOpenAndNoTaskRequiredActions.add("UnsetUTRepository");
        _isOpenAndNoTaskRequiredActions.add("CreateUTRepository");
        _isOpenAndNoTaskRequiredActions.add("DropUTRepository");
        _isOpenAndNoTaskRequiredActions.add("PurgeUTResults");
        _isOpenAndNoTaskRequiredActions.add("PurgeUTRepository");
        _isOpenAndNoTaskRequiredActions.add("ShowShared");
        _isOpenAndNoTaskRequiredActions.add("CreateSynonyms");
        _isOpenAndNoTaskRequiredActions.add("DropSynonyms");
        _isOpenAndNoTaskRequiredActions.add("ImportFile");
    }

    private class ImportInfo {
        UtUtils.ImportFileInfo fileInfo;
        ImportManager.ConflictOption conflictOption;

        private ImportInfo() {
        }
    }

    private class ImportOption {
        private String label;
        private ImportManager.ConflictOption conflictOption;

        private ImportOption(String string, ImportManager.ConflictOption conflictOption) {
            this.label = string;
            this.conflictOption = conflictOption;
        }

        public ImportManager.ConflictOption conflictOption() {
            return this.conflictOption;
        }

        public String toString() {
            return this.label;
        }
    }
}

