/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.wizards.job;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.dialogs.newjob.NewJobScriptGenerator;
import oracle.dbtools.scheduler.wizards.AbstractWizardPanel;
import oracle.dbtools.scheduler.wizards.job.JobWizardModel;

public class JobSummaryWizardPanel
extends AbstractWizardPanel<JobWizardModel> {
    private JTextComponent summaryPane;
    private JTextComponent scriptPane;

    @Override
    protected void initializeUI(JobWizardModel jobWizardModel) {
        jobWizardModel.initialize();
        this.setLayout(new GridBagLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.summaryPane = this.createTextPane(false);
        jTabbedPane.add(SchedulerArb.getString("JOB_WIZ_SUMMARY_LABEL"), new JScrollPane(this.summaryPane, 20, 30));
        this.scriptPane = this.createTextPane(false);
        jTabbedPane.add(SchedulerArb.getString("JOB_WIZ_SCRIPT_LABEL"), new JScrollPane(this.scriptPane, 20, 30));
        this.add(jTabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.refreshSummary(jobWizardModel);
    }

    @Override
    protected void onEntry(JobWizardModel jobWizardModel) {
        this.refreshSummary(jobWizardModel);
        this.enableButtons(true, true, true);
    }

    private void refreshSummary(JobWizardModel jobWizardModel) {
        this.summaryPane.setText(new NewJobScriptGenerator(jobWizardModel.getJobModel()).getSummary(jobWizardModel.getValue()));
        this.scriptPane.setText(new NewJobScriptGenerator(jobWizardModel.getJobModel()).getScript(jobWizardModel.getValue()));
    }

    private JTextComponent createTextPane(boolean bl) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(bl);
        jTextArea.setWrapStyleWord(bl);
        jTextArea.setEditable(false);
        return jTextArea;
    }
}

