/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.program;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ActionDialogTab;
import oracle.dbtools.raptor.ui.actions.ActionValuesLookup;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.CardLayoutActionControl;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.FilePathActionControl;
import oracle.dbtools.raptor.ui.controls.JComponentActionControl;
import oracle.dbtools.raptor.ui.controls.NameBoxActionControl;
import oracle.dbtools.raptor.ui.controls.PropertyPanelActionControl;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TableActionControl;
import oracle.dbtools.raptor.ui.controls.TableActionControlPanel;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.ui.panels.CardLayoutPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;
import oracle.dbtools.scheduler.panels.common.ActionDialogBase;
import oracle.dbtools.scheduler.panels.common.ObjectNameValidator;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.IdentifierImpl;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.QualifiedIdentifier;
import oracle.dbtools.scheduler.panels.program.ProgramEditorPanel;
import oracle.dbtools.scheduler.panels.program.ProgramPropertyPanelDBQuery;
import oracle.dbtools.scheduler.panels.program.ProgramTabProperties;
import oracle.ide.Context;
import oracle.ide.help.HelpSystem;
import oracle.javatools.util.ArrayMap;

public class ProgramCreateAction
extends ActionDialogBase {
    public static final Boolean GROUP_SCRIPT_TYPES = Boolean.TRUE;
    public static final String SQL_PROG_TYPE_STORED_PROCEDURE = "STORED_PROCEDURE";
    public static final String SQL_PROG_TYPE_PLSQL_BLOCK = "PLSQL_BLOCK";
    public static final String SQL_PROG_TYPE_EXECUTABLE = "EXECUTABLE";
    public static final String SQL_PROG_TYPE_EXTERNAL_SCRIPT = "EXTERNAL_SCRIPT";
    public static final String SQL_PROG_TYPE_SQL_SCRIPT = "SQL_SCRIPT";
    public static final String SQL_PROG_TYPE_BACKUP_SCRIPT = "BACKUP_SCRIPT";
    public static final String PROG_TYPE_PLSQL_BLOCK = SchedulerArb.getString("PROGRAMPANEL_PROG_TYPE_PLSQL_TAB");
    public static final String PROG_TYPE_EXECUTABLE = SchedulerArb.getString("PROGRAMPANEL_PROG_TYPE_EXECUTABLE_TAB");
    public static final String PROG_TYPE_REMOTE_STORED_PROCEDURE = SchedulerArb.getString("PROGRAMPANEL_PROG_TYPE_REMOTESTOREDPROCEDURE_TAB");
    public static final String PROG_TYPE_STORED_PROCEDURE = SchedulerArb.getString("PROGRAMPANEL_PROG_TYPE_STOREDPROCEDURE_TAB");
    public static final String PROG_TYPE_EXTERNAL_SCRIPT = SchedulerArb.getString("PROGRAMPANEL_PROG_TYPE_EXTERNAL_SCRIPT_TAB");
    public static final String PROG_TYPE_SQL_SCRIPT = SchedulerArb.getString("PROGRAMPANEL_PROG_TYPE_SQL_SCRIPT_TAB");
    public static final String PROG_TYPE_BACKUP_SCRIPT = SchedulerArb.getString("PROGRAMPANEL_PROG_TYPE_BACKUP_SCRIPT_TAB");
    private static final String PROG_TYPE_SCRIPT = SchedulerArb.getString("JOB_CREATE_TYPE_SCRIPT_BLOCK");
    public static final String STORED_PROCEDURE_ARG_NAME = SchedulerArb.getString("PROGRAMARGPANEL_PROGRAM_ARG_TABLE_COLUMN_ARGNAME_LABEL");
    public static final String STORED_PROCEDURE_ARG_TYPE = SchedulerArb.getString("PROGRAMARGPANEL_PROGRAM_ARG_TABLE_COLUMN_ARGTYPE_LABEL");
    public static final String STORED_PROCEDURE_ARG_DEFAULT_VALUE = SchedulerArb.getString("PROGRAMARGPANEL_PROGRAM_ARG_TABLE_COLUMN_ARGDEFAULTVALUE_LABEL");
    public static final String EXECUTABLE_ARG_NAME = SchedulerArb.getString("PROGRAMARGPANEL_PROGRAM_ARG_TABLE_COLUMN_ARGNAME_LABEL");
    public static final String EXECUTABLE_ARG_TYPE = SchedulerArb.getString("PROGRAMARGPANEL_PROGRAM_ARG_TABLE_COLUMN_ARGTYPE_LABEL");
    public static final String EXECUTABLE_ARG_VALUE = SchedulerArb.getString("PROGRAMARGPANEL_PROGRAM_ARG_TABLE_COLUMN_ARGNEWVALUE_LABEL");
    public static final String OWNER = "owner";
    public static final String NAME = "program_name";
    public static final String ENABLED = "enabled";
    public static final String COMMENTS = "comments";
    public static final String PROGRAM_ACTION = "program_action";
    public static final String PROGRAM_TYPE = "program_type";
    public static final String NUMBER_OF_ARGUMENTS = "number_of_arguments";
    public static final String ARGUMENTS = "arguments";
    public static final String ADVANCED_PROPERTIES = "advanced_properties";
    public static final String PROG_DETAIL = "prog_detail";
    public static final String REMOTE_STORED_PROCEDURE_PANEL = "remote_stored_procedure_panel";
    public static final String REMOTE_STORED_PROCEDURE_NAME = "remote_stored_procedure_name";
    public static final String REMOTE_STORED_PROCEDURE_ARGS = "remote_stored_procedure_args";
    public static final String EXECUTABLE_PANEL = "executable_panel";
    public static final String EXECUTABLE_NAME = "executable_name";
    public static final String EXECUTABLE_ARGS = "executable_args";
    public static final String PLSQL_PANEL = "plsql_panel";
    public static final String PLSQL_CODE = "plsql_code";
    public static final String LOCAL_STORED_PROCEDURE_PANEL = "local_stored_procedure_panel";
    public static final String LOCAL_STORED_PROCEDURE_OWNER = "local_stored_procedure_owner";
    public static final String LOCAL_STORED_PROCEDURE_NAME = "local_stored_procedure_name";
    public static final String LOCAL_STORED_PROCEDURE_ARGS = "local_stored_procedure_args";
    public static final String EXTERNAL_SCRIPT_PANEL = "external_script_panel";
    public static final String EXTERNAL_SCRIPT_TEXT = "external_script_text";
    public static final String SQL_SCRIPT_PANEL = "sql_script_panel";
    public static final String SQL_SCRIPT_TEXT = "sql_script_text";
    public static final String BACKUP_SCRIPT_PANEL = "backup_script_panel";
    public static final String BACKUP_SCRIPT_TEXT = "backup_script_text";
    public static final String SCRIPT_PANEL = "script_panel";
    public static final String SCRIPT_TYPE = "script_type";
    public static final String SCRIPT_TEXT = "script_text";
    private static final String METADATA_ATTRIBUTE_PREFIX = "META_ATTRIBUTE.";
    private static final String OWNER_BIND_NAME = "OWNER";
    private static final String PACKAGE_BIND_NAME = "PACKAGE_NAME";
    private static final String PROCEDURE_BIND_NAME = "PROCEDURE_NAME";
    String owner = null;
    String program_name = null;
    String program_type = PROG_TYPE_PLSQL_BLOCK;
    String script_type = PROG_TYPE_SQL_SCRIPT;
    Boolean enabled = Boolean.FALSE;
    String comments = null;
    String executable = null;
    String plsqlBlock = null;
    String externalScript = null;
    String sqlScript = null;
    String backupScript = null;
    String script = null;
    String localStoredProcedureSchema = null;
    String localStoredProcedureName = null;
    int localStoredProcedureNumberOfArgs = 0;
    String remoteStoredProcedure = null;
    String action = null;
    List<ProgramArgument> arguments = new ArrayList<ProgramArgument>();
    int numberOfArguments = 0;
    int originalNumberOfArguments = 0;
    boolean initialising = false;
    ActionControl ownerCtl = null;
    NameBoxActionControl nameCtl = null;
    ActionControl commentsCtl = null;
    ActionControl enabledCtl = null;
    CardLayoutActionControl programDetailCtl = null;
    PropertyPanelActionControl remoteProcedureCtl = null;
    TextBoxActionControl remoteProcedureNameCtl = null;
    TableActionControl remoteProcedureTableCtl = null;
    JComponentActionControl plsqlBlockEditorCtl = null;
    PropertyPanelActionControl plsqlBlockCtl = null;
    SqlComboBoxActionControl localProcedureOwnerCtl = null;
    ComboBoxActionControl localProcedureNameCtl = null;
    JComboBox localProcedureNameComboBox = null;
    DefaultComboBoxModel localProcedureNameModel = null;
    TableActionControl localProcedureTableCtl = null;
    PropertyPanelActionControl localProcedureCtl = null;
    PropertyPanelActionControl executableCtl = null;
    FilePathActionControl executableNameCtl = null;
    TableActionControl executableTableCtl = null;
    PropertyPanelActionControl externalScriptCtl = null;
    JComponentActionControl externalScriptEditorCtl = null;
    JEditorPane externalScriptEditor = null;
    PropertyPanelActionControl sqlScriptCtl = null;
    JComponentActionControl sqlScriptEditorCtl = null;
    JEditorPane sqlScriptEditor = null;
    PropertyPanelActionControl backupScriptCtl = null;
    JComponentActionControl backupScriptEditorCtl = null;
    JEditorPane backupScriptEditor = null;
    PropertyPanelActionControl scriptCtl = null;
    JComponentActionControl scriptTextCtl = null;
    ComboBoxActionControl scriptTypeCtl = null;
    List<ActionDialogTab> additionalTabsList = null;
    ProgramTabProperties advancedPropertiesTab = null;
    Map<Object, ActionControl> progDetailControls = new ArrayMap();
    Connection connection;
    LocalProcedureSchemaChangeListener localProcedureSchemaChangeListener = new LocalProcedureSchemaChangeListener();
    LocalProcedureNameChangeListener localProcedureNameChangeListener = new LocalProcedureNameChangeListener();
    JComboBox argumentTypeEditorJComboBox = new JComboBox<String>(new String[]{"CHAR", "VARCHAR2", "NCHAR", "NVARCHAR2"});
    JComboBox argumentTypeRendererJComboBox = new JComboBox<String>(new String[]{"CHAR", "VARCHAR2", "NCHAR", "NVARCHAR2"});
    JComboBox argumentValueEditorJComboBox = new JComboBox();
    JComboBox argumentValueRendererJComboBox = new JComboBox();
    ExecutableArgTypeCellRenderer executableArgTypeCellRenderer = new ExecutableArgTypeCellRenderer();
    ExecutableArgTypeCellEditor executableArgTypeCellEditor = new ExecutableArgTypeCellEditor();
    ArgumentValueCellEditor argumentValueCellEditor = new ArgumentValueCellEditor();
    ArgumentValueCellRenderer argumentValueCellRenderer = new ArgumentValueCellRenderer();
    ScriptArgTypeCellRenderer scriptArgTypeCellRenderer = new ScriptArgTypeCellRenderer();
    ScriptArgTypeCellEditor scriptArgTypeCellEditor = new ScriptArgTypeCellEditor();
    Timer localStoredProcedureArgumentTimer = null;

    public ProgramCreateAction() {
        this.setScriptEditingEnabled(false);
    }

    protected String getEditPaneTitle() {
        return SchedulerArb.getString("PROGRAM_TAB_PROGRAM_DETAILS");
    }

    protected String getTitle() {
        try {
            switch (this.getOperation()) {
                case UPDATE: {
                    return SchedulerArb.getString("PROGRAMUPDATEDIALOG_TITLE");
                }
                case CREATE_NEW: {
                    return SchedulerArb.getString("PROGRAMCREATEDIALOG_TITLE");
                }
                case CREATE_LIKE: {
                    return SchedulerArb.getString("PROGRAMCREATELIKEDIALOG_TITLE");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return SchedulerArb.getString("PROGRAMCREATEDIALOG_TITLE");
    }

    protected boolean isCloseOnError() {
        return false;
    }

    @Override
    protected DatabaseQueryTask<List<String>> getListTask() {
        return new ListTask();
    }

    @Override
    protected String getObjectType() {
        return "SCHPROGRAM";
    }

    private Operation getOperation() {
        return Operation.valueOf(this.getArgs());
    }

    private static String unQuote(String string) {
        if (string != null && string.length() > 2 && string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    protected String getQuery(Connection connection, String string) {
        String string2 = DBUtil.getDbVersion((Connection)connection).toCanonicalString();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        return dBMSSchedulerCodeGenerator.generate(string2, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        Object object;
        Operation operation;
        block68: {
            this.connection = connection;
            operation = this.getOperation();
            try {
                this.program_name = this.getObjectName();
            }
            catch (Exception exception) {
                this.program_name = "null";
            }
            try {
                this.owner = this.getDBObjectSchemaName();
                if (this.owner == null) {
                    this.owner = this.getDBObject().getSchemaName();
                }
            }
            catch (Exception exception) {
                this.owner = "null";
            }
            this.localStoredProcedureSchema = this.owner;
            if (operation != Operation.CREATE_NEW && Connections.getInstance().lock(connection)) {
                try {
                    object = DBUtil.getInstance((Connection)connection);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    ResultSet resultSet = null;
                    String string = this.getQuery(connection, "PROGRAM_MODEL_UPDATE");
                    hashMap.put(OWNER_BIND_NAME, this.owner);
                    hashMap.put("PROGRAM_NAME", this.program_name);
                    object.setRaiseError(true);
                    try {
                        resultSet = object.executeOracleQuery(string, hashMap);
                        if (resultSet != null && resultSet.next()) {
                            this.comments = ProgramCreateAction.getStringFromRS(resultSet, "COMMENTS");
                            this.enabled = ProgramCreateAction.getStringFromRS(resultSet, "ENABLED") == null ? null : Boolean.valueOf(ProgramCreateAction.getStringFromRS(resultSet, "ENABLED").equalsIgnoreCase("true"));
                            this.program_type = ProgramCreateAction.getStringFromRS(resultSet, "PROGRAM_TYPE");
                            this.originalNumberOfArguments = this.numberOfArguments = ProgramCreateAction.getIntFromRS(resultSet, "NUMBER_OF_ARGUMENTS");
                            this.action = ProgramCreateAction.getStringFromRS(resultSet, "PROGRAM_ACTION");
                        }
                    }
                    catch (Exception exception) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                    finally {
                        if (resultSet != null) {
                            DBUtil.closeResultSet((ResultSet)resultSet);
                            resultSet = null;
                        }
                    }
                    try {
                        String string2;
                        Object object2;
                        Object object3;
                        Object object4;
                        Object object5;
                        if (this.program_type != null) {
                            if (this.program_type.equals(SQL_PROG_TYPE_STORED_PROCEDURE)) {
                                object5 = new QualifiedIdentifier(this.action);
                                object4 = ((QualifiedIdentifier)object5).getUserName();
                                object3 = null;
                                object2 = ((QualifiedIdentifier)object5).getObjectName();
                                string2 = ((QualifiedIdentifier)object5).getSubObjectName();
                                boolean bl = false;
                                boolean bl2 = false;
                                boolean bl3 = false;
                                boolean bl4 = false;
                                if (object4 != null && ((String)object4).length() > 2 && ((String)object4).startsWith("\"") && ((String)object4).endsWith("\"")) {
                                    bl = true;
                                }
                                if (object2 != null && ((String)object2).length() > 2 && ((String)object2).startsWith("\"") && ((String)object2).endsWith("\"")) {
                                    bl3 = true;
                                }
                                if (string2 != null && string2.length() > 2 && string2.startsWith("\"") && string2.endsWith("\"")) {
                                    bl4 = true;
                                }
                                if (string2 != null && string2.length() > 0) {
                                    object3 = object2;
                                    bl2 = bl3;
                                    object2 = string2;
                                    bl3 = bl4;
                                } else {
                                    string2 = null;
                                }
                                if (object4 != null && !bl) {
                                    object4 = ((String)object4).toUpperCase();
                                }
                                if (object2 != null && !bl3) {
                                    object2 = ((String)object2).toUpperCase();
                                }
                                if (object3 != null && !bl2) {
                                    object3 = ((String)object3).toUpperCase();
                                }
                                if (object4 != null && string2 == null && ProgramCreateAction.isLocalPackage(connection, this.owner, (String)object4)) {
                                    this.program_type = PROG_TYPE_STORED_PROCEDURE;
                                    this.localStoredProcedureSchema = this.owner;
                                    this.localStoredProcedureName = (String)object4 + "." + (String)object2;
                                } else {
                                    Object object6 = object4;
                                    if (object4 == null) {
                                        object6 = this.owner;
                                    }
                                    if (ProgramCreateAction.isLocalStoredProcedure(connection, (String)object6, (String)object3, (String)object2)) {
                                        this.program_type = PROG_TYPE_STORED_PROCEDURE;
                                        this.localStoredProcedureSchema = object4 != null && ((String)object4).length() > 0 ? object4 : this.owner;
                                        this.localStoredProcedureName = object3 != null && ((String)object3).length() > 0 ? (String)object3 + "." + (String)object2 : object2;
                                    } else {
                                        this.program_type = PROG_TYPE_REMOTE_STORED_PROCEDURE;
                                        this.remoteStoredProcedure = this.action;
                                    }
                                }
                            } else if (this.program_type.equals(SQL_PROG_TYPE_EXECUTABLE)) {
                                this.program_type = PROG_TYPE_EXECUTABLE;
                                this.executable = this.action;
                            } else if (this.program_type.equals(SQL_PROG_TYPE_PLSQL_BLOCK)) {
                                this.program_type = PROG_TYPE_PLSQL_BLOCK;
                                this.plsqlBlock = this.action;
                            } else if (this.program_type.equals(SQL_PROG_TYPE_EXTERNAL_SCRIPT)) {
                                if (GROUP_SCRIPT_TYPES.booleanValue()) {
                                    this.program_type = PROG_TYPE_SCRIPT;
                                    this.script_type = PROG_TYPE_EXTERNAL_SCRIPT;
                                    this.script = this.action;
                                } else {
                                    this.program_type = PROG_TYPE_EXTERNAL_SCRIPT;
                                    this.script_type = null;
                                    this.externalScript = this.action;
                                }
                            } else if (this.program_type.equals(SQL_PROG_TYPE_SQL_SCRIPT)) {
                                if (GROUP_SCRIPT_TYPES.booleanValue()) {
                                    this.program_type = PROG_TYPE_SCRIPT;
                                    this.script_type = PROG_TYPE_SQL_SCRIPT;
                                    this.script = this.action;
                                } else {
                                    this.program_type = PROG_TYPE_SQL_SCRIPT;
                                    this.script_type = null;
                                    this.sqlScript = this.action;
                                }
                            } else if (this.program_type.equals(SQL_PROG_TYPE_BACKUP_SCRIPT)) {
                                if (GROUP_SCRIPT_TYPES.booleanValue()) {
                                    this.program_type = PROG_TYPE_SCRIPT;
                                    this.script_type = PROG_TYPE_BACKUP_SCRIPT;
                                    this.script = this.action;
                                } else {
                                    this.program_type = PROG_TYPE_BACKUP_SCRIPT;
                                    this.script_type = null;
                                    this.backupScript = this.action;
                                }
                            }
                        }
                        if (this.numberOfArguments <= 0) break block68;
                        object5 = this.getQuery(connection, "PROGRAM_MODEL_PROGRAM_ARGUMENTS");
                        resultSet = object.executeOracleQuery((String)object5, hashMap);
                        try {
                            if (resultSet != null) {
                                object4 = new Vector();
                                object3 = new Vector<String>();
                                object2 = new Vector();
                                while (resultSet.next()) {
                                    string2 = ProgramCreateAction.getStringFromRS(resultSet, "ARGUMENT_NAME");
                                    String string3 = ProgramCreateAction.getStringFromRS(resultSet, "ARGUMENT_TYPE");
                                    String string4 = ProgramCreateAction.getStringFromRS(resultSet, "METADATA_ATTRIBUTE");
                                    String string5 = ProgramCreateAction.getStringFromRS(resultSet, "DEFAULT_VALUE");
                                    String string6 = string4 != null && string4.length() > 0 ? METADATA_ATTRIBUTE_PREFIX + string4 : string5;
                                    object4.add(string2);
                                    object3.add(string3);
                                    object2.add(string6);
                                }
                                this.processArgs(this.arguments, (List<String>)object4, (List<String>)object3, (List<String>)object2);
                            }
                        }
                        finally {
                            if (resultSet != null) {
                                DBUtil.closeResultSet((ResultSet)resultSet);
                                resultSet = null;
                            }
                        }
                    }
                    catch (Exception exception) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                }
                finally {
                    Connections.getInstance().unlock(connection);
                }
            }
        }
        this.initialising = true;
        try {
            this.remoteProcedureCtl = this.createRemoteStoredProcedureControl(connection);
            this.plsqlBlockCtl = this.createPLSQLControl(connection);
            this.localProcedureCtl = this.createLocalStoredProcedureControl(connection);
            this.executableCtl = this.createExecutableControl(connection);
            if (this.is12orGreater()) {
                this.externalScriptCtl = this.createExternalScriptControl(connection);
                this.sqlScriptCtl = this.createSQLScriptControl(connection);
                this.backupScriptCtl = this.createBackupScriptControl(connection);
                this.scriptCtl = this.createScriptControl(connection);
            }
            this.progDetailControls.put(PROG_TYPE_PLSQL_BLOCK, (ActionControl)this.plsqlBlockCtl);
            this.progDetailControls.put(PROG_TYPE_STORED_PROCEDURE, (ActionControl)this.localProcedureCtl);
            this.progDetailControls.put(PROG_TYPE_REMOTE_STORED_PROCEDURE, (ActionControl)this.remoteProcedureCtl);
            this.progDetailControls.put(PROG_TYPE_EXECUTABLE, (ActionControl)this.executableCtl);
            if (this.is12orGreater()) {
                if (GROUP_SCRIPT_TYPES.booleanValue()) {
                    this.progDetailControls.put(PROG_TYPE_SCRIPT, (ActionControl)this.scriptCtl);
                } else {
                    this.progDetailControls.put(PROG_TYPE_SQL_SCRIPT, (ActionControl)this.sqlScriptCtl);
                    this.progDetailControls.put(PROG_TYPE_BACKUP_SCRIPT, (ActionControl)this.backupScriptCtl);
                    this.progDetailControls.put(PROG_TYPE_EXTERNAL_SCRIPT, (ActionControl)this.externalScriptCtl);
                }
            }
        }
        finally {
            this.initialising = false;
        }
        switch (operation) {
            case UPDATE: {
                object = ObjectNameValidator.displayName(this.program_name);
                this.nameCtl = new NameBoxActionControl(NAME, SchedulerArb.getString("PROGRAMPANEL_NAME_LABEL"), (String)object);
                this.nameCtl.setEditable(false);
                this.commentsCtl = new TextBoxActionControl(COMMENTS, SchedulerArb.getString("PROGRAMPANEL_DESC_LABEL"), this.comments);
                this.enabledCtl = new BooleanCheckBoxActionControl(ENABLED, SchedulerArb.getString("PROGRAMPANEL_ENABLED_LABEL"), this.enabled.booleanValue());
                this.programDetailCtl = new CardLayoutActionControl(PROG_DETAIL, null, CardLayoutPanel.Type.TITLE_BORDER, this.progDetailControls);
                break;
            }
            case CREATE_LIKE: {
                this.nameCtl = new NameBoxActionControl(NAME, SchedulerArb.getString("PROGRAMPANEL_NAME_LABEL"), "");
                this.commentsCtl = new TextBoxActionControl(COMMENTS, SchedulerArb.getString("PROGRAMPANEL_DESC_LABEL"), this.comments);
                this.enabledCtl = new BooleanCheckBoxActionControl(ENABLED, SchedulerArb.getString("PROGRAMPANEL_ENABLED_LABEL"), this.enabled.booleanValue());
                this.programDetailCtl = new CardLayoutActionControl(PROG_DETAIL, null, CardLayoutPanel.Type.TITLE_BORDER, this.progDetailControls);
                break;
            }
            case CREATE_NEW: {
                this.nameCtl = new NameBoxActionControl(NAME, SchedulerArb.getString("PROGRAMPANEL_NAME_LABEL"), this.program_name);
                this.commentsCtl = new TextBoxActionControl(COMMENTS, SchedulerArb.getString("PROGRAMPANEL_DESC_LABEL"), this.comments);
                this.enabledCtl = new BooleanCheckBoxActionControl(ENABLED, SchedulerArb.getString("PROGRAMPANEL_ENABLED_LABEL"), Boolean.TRUE.booleanValue());
                this.programDetailCtl = new CardLayoutActionControl(PROG_DETAIL, null, CardLayoutPanel.Type.TITLE_BORDER, this.progDetailControls);
                this.programDetailCtl.setSelected((Object)PROG_TYPE_PLSQL_BLOCK);
            }
        }
        this.programDetailCtl.setSpringVertical(true);
        this.programDetailCtl.setFillVertical(true);
        this.programDetailCtl.setSelected((Object)this.program_type);
        object = new ArrayList();
        ((ArrayList)object).add(this.nameCtl);
        ((ArrayList)object).add(this.enabledCtl);
        ((ArrayList)object).add(this.commentsCtl);
        ((ArrayList)object).add(this.programDetailCtl);
        return object;
    }

    protected List<ActionDialogTab> createAdditionalTabs() {
        Connection connection = this.getDBObject().getConnection();
        boolean bl = DBUtil.checkVersion((Connection)connection, null, (Version)new Version("10.2"));
        if (bl) {
            this.additionalTabsList = new ArrayList<ActionDialogTab>();
            boolean bl2 = false;
            Operation operation = this.getOperation();
            if (operation == Operation.CREATE_NEW) {
                bl2 = true;
            }
            this.advancedPropertiesTab = new ProgramTabProperties(ADVANCED_PROPERTIES, SchedulerArb.getString("PROGRAM_TAB_PROPERTIES"), this.getDBObject(), bl2);
            this.additionalTabsList.add(this.advancedPropertiesTab);
            return this.additionalTabsList;
        }
        return null;
    }

    private PropertyPanelActionControl createPLSQLControl(Connection connection) {
        this.plsqlBlockCtl = new PropertyPanelActionControl(PLSQL_PANEL, null);
        final ProgramEditorPanel programEditorPanel = new ProgramEditorPanel("x.pls");
        if (this.plsqlBlock != null) {
            programEditorPanel.setText(this.plsqlBlock);
        }
        this.plsqlBlockEditorCtl = new JComponentActionControl(PLSQL_CODE, null, programEditorPanel){
            ActionControl.Value v;
            private List<ActionControl> childControls;
            {
                super(string, string2, jComponent);
                this.v = new ActionControl.Value();
            }

            public List<ActionControl> getChildControls() {
                return this.childControls;
            }

            public ActionControl.Value getValue() {
                this.v.set(programEditorPanel.getText());
                return this.v;
            }
        };
        ArrayList<JComponentActionControl> arrayList = new ArrayList<JComponentActionControl>();
        arrayList.add(this.plsqlBlockEditorCtl);
        this.plsqlBlockEditorCtl.setSpringVertical(true);
        this.plsqlBlockEditorCtl.setFillVertical(true);
        this.plsqlBlockCtl.addChildControls(arrayList);
        return this.plsqlBlockCtl;
    }

    private PropertyPanelActionControl createLocalStoredProcedureControl(Connection connection) {
        ProgramArgument programArgument2;
        this.localProcedureCtl = new PropertyPanelActionControl(LOCAL_STORED_PROCEDURE_PANEL, null);
        this.localProcedureOwnerCtl = new SqlComboBoxActionControl(LOCAL_STORED_PROCEDURE_OWNER, SchedulerArb.getString("PROGRAMPANEL_SCHEMA_LABEL"), connection, this.getQuery(connection, "SCHEMAS_LIST"), null, this.localStoredProcedureSchema);
        this.localProcedureOwnerCtl.addPropertyChangeListener((PropertyChangeListener)this.localProcedureSchemaChangeListener);
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put(OWNER_BIND_NAME, this.localStoredProcedureSchema);
        this.localProcedureNameCtl = new ComboBoxActionControl(LOCAL_STORED_PROCEDURE_NAME, SchedulerArb.getString("PROGRAMPANEL_STORED_PROCEDURE_NAME_LABEL"), new String[0], null, true);
        this.localProcedureNameComboBox = (JComboBox)this.localProcedureNameCtl.getUI();
        this.localProcedureNameModel = (DefaultComboBoxModel)this.localProcedureNameComboBox.getModel();
        this.localProcedureNameCtl.addPropertyChangeListener((PropertyChangeListener)this.localProcedureNameChangeListener);
        ArrayList<LocalProcArgumentRow> arrayList = new ArrayList<LocalProcArgumentRow>();
        for (ProgramArgument programArgument2 : this.arguments) {
            arrayList.add(new LocalProcArgumentRow(programArgument2.argument_name, programArgument2.argument_type, programArgument2.metadata_attribute ? programArgument2.metadata_attribute_name : null, programArgument2.metadata_attribute ? null : programArgument2.default_value));
        }
        ArrayList arrayList2 = new ArrayList();
        Collections.addAll(arrayList2, STORED_PROCEDURE_ARG_NAME, STORED_PROCEDURE_ARG_TYPE, STORED_PROCEDURE_ARG_DEFAULT_VALUE);
        this.localProcedureTableCtl = new TableActionControl(LOCAL_STORED_PROCEDURE_ARGS, SchedulerArb.getString("PROGRAMPANEL_ARGUMENTS_LABEL"), (List)arrayList2, arrayList, 20);
        programArgument2 = (TableActionControlPanel)this.localProcedureTableCtl.getUI();
        JTable jTable = programArgument2.getTable();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(2);
        tableColumn.setCellRenderer(this.argumentValueCellRenderer);
        tableColumn.setCellEditor(this.argumentValueCellEditor);
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        if (this.localStoredProcedureSchema != null) {
            this.updateProcedureNameListForSchema(this.localStoredProcedureSchema, this.localStoredProcedureName);
        }
        arrayList3.add(this.localProcedureOwnerCtl);
        arrayList3.add(this.localProcedureNameCtl);
        arrayList3.add(this.localProcedureTableCtl);
        this.localProcedureCtl.addChildControls(arrayList3);
        return this.localProcedureCtl;
    }

    private PropertyPanelActionControl createRemoteStoredProcedureControl(Connection connection) {
        ProgramArgument programArgument2;
        this.remoteProcedureCtl = new PropertyPanelActionControl(REMOTE_STORED_PROCEDURE_PANEL, null);
        this.remoteProcedureNameCtl = new TextBoxActionControl(REMOTE_STORED_PROCEDURE_NAME, SchedulerArb.getString("PROGRAMPANEL_STORED_PROCEDURE_NAME_LABEL"), this.remoteStoredProcedure);
        ArrayList<RemoteProcArgumentRow> arrayList = new ArrayList<RemoteProcArgumentRow>();
        for (ProgramArgument programArgument2 : this.arguments) {
            arrayList.add(new RemoteProcArgumentRow(programArgument2.argument_name, programArgument2.argument_type, programArgument2.metadata_attribute ? programArgument2.metadata_attribute_name : null, programArgument2.metadata_attribute ? null : programArgument2.default_value));
        }
        ArrayList arrayList2 = new ArrayList();
        Collections.addAll(arrayList2, STORED_PROCEDURE_ARG_NAME, STORED_PROCEDURE_ARG_TYPE, STORED_PROCEDURE_ARG_DEFAULT_VALUE);
        this.remoteProcedureTableCtl = new TableActionControl(REMOTE_STORED_PROCEDURE_ARGS, SchedulerArb.getString("PROGRAMPANEL_ARGUMENTS_LABEL"), (TableActionControl.RowFactory)new RemoteProcArgumentRowFactory(), (List)arrayList2, arrayList, 20, true);
        programArgument2 = (TableActionControlPanel)this.remoteProcedureTableCtl.getUI();
        JTable jTable = programArgument2.getTable();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(2);
        tableColumn.setCellRenderer(this.argumentValueCellRenderer);
        tableColumn.setCellEditor(this.argumentValueCellEditor);
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        arrayList3.add(this.remoteProcedureNameCtl);
        arrayList3.add(this.remoteProcedureTableCtl);
        this.remoteProcedureCtl.addChildControls(arrayList3);
        return this.remoteProcedureCtl;
    }

    private PropertyPanelActionControl createExecutableControl(Connection connection) {
        ProgramArgument programArgument2;
        this.executableCtl = new PropertyPanelActionControl(EXECUTABLE_PANEL, null);
        this.executableNameCtl = new FilePathActionControl(EXECUTABLE_NAME, SchedulerArb.getString("PROGRAMPANEL_EXECUTABLE_LABEL"), this.executable);
        this.executableNameCtl.setEditable(true);
        ArrayList<ExecJobArgumentRow> arrayList = new ArrayList<ExecJobArgumentRow>();
        for (ProgramArgument programArgument2 : this.arguments) {
            arrayList.add(new ExecJobArgumentRow(programArgument2.argument_name, programArgument2.argument_type, programArgument2.metadata_attribute ? programArgument2.metadata_attribute_name : programArgument2.default_value));
        }
        ArrayList arrayList2 = new ArrayList();
        Collections.addAll(arrayList2, EXECUTABLE_ARG_NAME, EXECUTABLE_ARG_TYPE, EXECUTABLE_ARG_VALUE);
        this.executableTableCtl = new TableActionControl(EXECUTABLE_ARGS, SchedulerArb.getString("PROGRAMPANEL_ARGUMENTS_LABEL"), (TableActionControl.RowFactory)new ExecJobArgumentRowFactory(), (List)arrayList2, arrayList, 20, true);
        programArgument2 = (TableActionControlPanel)this.executableTableCtl.getUI();
        JTable jTable = programArgument2.getTable();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setCellRenderer(this.executableArgTypeCellRenderer);
        tableColumn.setCellEditor(this.executableArgTypeCellEditor);
        tableColumn = tableColumnModel.getColumn(2);
        tableColumn.setCellRenderer(this.argumentValueCellRenderer);
        tableColumn.setCellEditor(this.argumentValueCellEditor);
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        arrayList3.add(this.executableNameCtl);
        arrayList3.add(this.executableTableCtl);
        this.executableCtl.addChildControls(arrayList3);
        return this.executableCtl;
    }

    private PropertyPanelActionControl createExternalScriptControl(Connection connection) {
        this.externalScriptCtl = new PropertyPanelActionControl(EXTERNAL_SCRIPT_PANEL, null);
        this.externalScriptEditor = new JEditorPane();
        this.externalScriptEditor.setBorder(new LineBorder(Color.BLACK));
        if (this.externalScript != null) {
            this.externalScriptEditor.setText(this.externalScript);
        }
        this.externalScriptEditorCtl = new JComponentActionControl(EXTERNAL_SCRIPT_TEXT, null, this.externalScriptEditor){
            ActionControl.Value v;
            private List<ActionControl> childControls;
            {
                this.v = new ActionControl.Value();
            }

            public List<ActionControl> getChildControls() {
                return this.childControls;
            }

            public ActionControl.Value getValue() {
                this.v.set(ProgramCreateAction.this.externalScriptEditor.getText());
                return this.v;
            }

            public void enableUI(boolean bl) {
                super.enableUI(bl);
                ProgramCreateAction.this.externalScriptEditor.setEnabled(bl);
            }
        };
        this.externalScriptEditorCtl.setSpringVertical(true);
        this.externalScriptEditorCtl.setFillVertical(true);
        ArrayList<JComponentActionControl> arrayList = new ArrayList<JComponentActionControl>();
        arrayList.add(this.externalScriptEditorCtl);
        this.externalScriptCtl.addChildControls(arrayList);
        return this.externalScriptCtl;
    }

    private PropertyPanelActionControl createSQLScriptControl(Connection connection) {
        this.sqlScriptCtl = new PropertyPanelActionControl(SQL_SCRIPT_PANEL, null);
        this.sqlScriptEditor = new JEditorPane();
        this.sqlScriptEditor.setBorder(new LineBorder(Color.BLACK));
        if (this.sqlScript != null) {
            this.sqlScriptEditor.setText(this.sqlScript);
        }
        this.sqlScriptEditorCtl = new JComponentActionControl(SQL_SCRIPT_TEXT, null, this.sqlScriptEditor){
            ActionControl.Value v;
            private List<ActionControl> childControls;
            {
                this.v = new ActionControl.Value();
            }

            public List<ActionControl> getChildControls() {
                return this.childControls;
            }

            public ActionControl.Value getValue() {
                this.v.set(ProgramCreateAction.this.sqlScriptEditor.getText());
                return this.v;
            }

            public void enableUI(boolean bl) {
                super.enableUI(bl);
                ProgramCreateAction.this.sqlScriptEditor.setEnabled(bl);
            }
        };
        this.sqlScriptEditorCtl.setSpringVertical(true);
        this.sqlScriptEditorCtl.setFillVertical(true);
        ArrayList<JComponentActionControl> arrayList = new ArrayList<JComponentActionControl>();
        arrayList.add(this.sqlScriptEditorCtl);
        this.sqlScriptCtl.addChildControls(arrayList);
        return this.sqlScriptCtl;
    }

    private PropertyPanelActionControl createBackupScriptControl(Connection connection) {
        this.backupScriptCtl = new PropertyPanelActionControl(BACKUP_SCRIPT_PANEL, null);
        this.backupScriptEditor = new JEditorPane();
        this.backupScriptEditor.setBorder(new LineBorder(Color.BLACK));
        if (this.backupScript != null) {
            this.backupScriptEditor.setText(this.backupScript);
        }
        this.backupScriptEditorCtl = new JComponentActionControl(BACKUP_SCRIPT_TEXT, null, this.backupScriptEditor){
            ActionControl.Value v;
            private List<ActionControl> childControls;
            {
                this.v = new ActionControl.Value();
            }

            public List<ActionControl> getChildControls() {
                return this.childControls;
            }

            public ActionControl.Value getValue() {
                this.v.set(ProgramCreateAction.this.backupScriptEditor.getText());
                return this.v;
            }

            public void enableUI(boolean bl) {
                super.enableUI(bl);
                ProgramCreateAction.this.backupScriptEditor.setEnabled(bl);
            }
        };
        this.backupScriptEditorCtl.setSpringVertical(true);
        this.backupScriptEditorCtl.setFillVertical(true);
        ArrayList<JComponentActionControl> arrayList = new ArrayList<JComponentActionControl>();
        arrayList.add(this.backupScriptEditorCtl);
        this.backupScriptCtl.addChildControls(arrayList);
        return this.backupScriptCtl;
    }

    private PropertyPanelActionControl createScriptControl(Connection connection) {
        if (this.program_type != null && (this.program_type.equals(PROG_TYPE_EXTERNAL_SCRIPT) || this.program_type.equals(PROG_TYPE_EXTERNAL_SCRIPT) || this.program_type.equals(PROG_TYPE_EXTERNAL_SCRIPT))) {
            this.script_type = this.program_type;
        }
        this.scriptCtl = new PropertyPanelActionControl(SCRIPT_PANEL, null);
        this.scriptTypeCtl = new ComboBoxActionControl(SCRIPT_TYPE, SchedulerArb.get("SCRIPT_TYPE"), new String[]{PROG_TYPE_SQL_SCRIPT, PROG_TYPE_BACKUP_SCRIPT, PROG_TYPE_EXTERNAL_SCRIPT}, this.script_type);
        final ProgramEditorPanel programEditorPanel = new ProgramEditorPanel("x.pls");
        if (this.script != null) {
            programEditorPanel.setText(this.script);
        }
        this.scriptTextCtl = new JComponentActionControl(SCRIPT_TEXT, null, programEditorPanel){
            ActionControl.Value v;
            private List<ActionControl> childControls;
            {
                super(string, string2, jComponent);
                this.v = new ActionControl.Value();
            }

            public List<ActionControl> getChildControls() {
                return this.childControls;
            }

            public ActionControl.Value getValue() {
                this.v.set(programEditorPanel.getText());
                return this.v;
            }

            public void enableUI(boolean bl) {
                super.enableUI(bl);
                programEditorPanel.setEnabled(bl);
            }
        };
        this.scriptTextCtl.setSpringVertical(true);
        this.scriptTextCtl.setFillVertical(true);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.scriptTypeCtl);
        arrayList.add(this.scriptTextCtl);
        this.scriptCtl.addChildControls(arrayList);
        return this.scriptCtl;
    }

    private String quoteIdentifier(String string) {
        if (string != null) {
            string = string.trim();
            IdentifierImpl identifierImpl = new IdentifierImpl(string);
            string = identifierImpl.getId();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProcedureNameListForSchema(String string, String string2) {
        block13: {
            if (Connections.getInstance().lock(this.connection)) {
                try {
                    ResultSet resultSet;
                    block12: {
                        this.localProcedureNameModel.removeAllElements();
                        DBUtil dBUtil = DBUtil.getInstance((Connection)this.connection);
                        TreeMap<String, String> treeMap = new TreeMap<String, String>();
                        treeMap.put(OWNER_BIND_NAME, string);
                        resultSet = null;
                        String string3 = this.getQuery(this.connection, "PROGRAM_MODEL_PROCEDURES_LIST");
                        dBUtil.setRaiseError(true);
                        try {
                            resultSet = dBUtil.executeOracleQuery(string3, treeMap);
                            if (resultSet == null) break block12;
                            while (resultSet.next()) {
                                String string4 = resultSet.getString(PACKAGE_BIND_NAME);
                                String string5 = resultSet.getString("OBJECT_NAME");
                                String string6 = "";
                                if (string4 != null) {
                                    string4 = new IdentifierImpl(string4).getId();
                                    string6 = string4 + ".";
                                }
                                if (string5 != null) {
                                    string5 = new IdentifierImpl(string5).getId();
                                }
                                this.localProcedureNameModel.addElement(string6 + string5);
                            }
                        }
                        catch (Exception exception) {
                            try {
                                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                            }
                            catch (Throwable throwable) {
                                DBUtil.closeResultSet(resultSet);
                                throw throwable;
                            }
                            DBUtil.closeResultSet((ResultSet)resultSet);
                            break block13;
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                finally {
                    Connections.getInstance().unlock(this.connection);
                }
            }
        }
        if (string2 != null) {
            this.localProcedureNameModel.setSelectedItem(string2);
        }
    }

    protected String getScript(ActionDialog.Values values) {
        Object object;
        Object object2;
        Object object3;
        Operation operation = this.getOperation();
        String string = this.getDBObject().getDBVersion();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        String string2 = values.get(OWNER);
        String string3 = values.get(NAME);
        string3 = ObjectNameValidator.validateName(string3);
        String string4 = values.get(COMMENTS);
        String string5 = values.get("prog_detail/plsql_panel/plsql_code");
        Boolean bl = Boolean.valueOf(values.get(ENABLED));
        String string6 = values.get(PROG_DETAIL);
        String string7 = values.get(PROG_DETAIL);
        String string8 = values.get("prog_detail/script_panel/script_type");
        ArrayList<ProgramArgument> arrayList = new ArrayList<ProgramArgument>();
        int n = 0;
        if (string2 == null || string2 != null && string2.length() == 0) {
            string2 = this.owner;
        }
        if (string2 != null) {
            string2 = this.quoteIdentifier(string2);
        }
        if (string3 != null && string3.length() == 0) {
            string3 = null;
        }
        string3 = this.quoteIdentifier(string3);
        if (bl == null) {
            bl = Boolean.FALSE;
        }
        if (string4 != null && string4.length() == 0) {
            string4 = null;
        }
        string7 = this.convertToSchedulerProgType(string6, string8);
        if (string6 != null) {
            if (string6.equals(PROG_TYPE_REMOTE_STORED_PROCEDURE)) {
                object3 = values.getList("prog_detail/remote_stored_procedure_panel/remote_stored_procedure_args", STORED_PROCEDURE_ARG_NAME);
                object2 = values.getList("prog_detail/remote_stored_procedure_panel/remote_stored_procedure_args", STORED_PROCEDURE_ARG_TYPE);
                object = values.getList("prog_detail/remote_stored_procedure_panel/remote_stored_procedure_args", STORED_PROCEDURE_ARG_DEFAULT_VALUE);
                n = object3.size();
                this.processArgs(arrayList, (List<String>)object3, (List<String>)object2, (List<String>)object);
                string5 = values.get("prog_detail/remote_stored_procedure_panel/remote_stored_procedure_name");
                if (string5 != null && string5.trim().length() == 0) {
                    string5 = null;
                }
                if (string5 != null) {
                    string5 = new QualifiedIdentifier(string5).getId();
                }
            } else if (string6.equals(PROG_TYPE_STORED_PROCEDURE)) {
                object3 = values.getList("prog_detail/local_stored_procedure_panel/local_stored_procedure_args", STORED_PROCEDURE_ARG_NAME);
                object2 = values.getList("prog_detail/local_stored_procedure_panel/local_stored_procedure_args", STORED_PROCEDURE_ARG_TYPE);
                object = values.getList("prog_detail/local_stored_procedure_panel/local_stored_procedure_args", STORED_PROCEDURE_ARG_DEFAULT_VALUE);
                n = object3.size();
                this.processArgs(arrayList, (List<String>)object3, (List<String>)object2, (List<String>)object);
                string5 = values.get("prog_detail/local_stored_procedure_panel/local_stored_procedure_owner") + "." + values.get("prog_detail/local_stored_procedure_panel/local_stored_procedure_name");
                if (string5 != null && string5.trim().length() == 0) {
                    string5 = null;
                }
                if (string5 != null) {
                    string5 = new QualifiedIdentifier(string5).getId();
                }
            } else if (string6.equals(PROG_TYPE_PLSQL_BLOCK)) {
                string5 = values.get("prog_detail/plsql_panel/plsql_code");
                string5 = string5.replaceAll("'", "''");
            } else if (string6.equals(PROG_TYPE_EXECUTABLE)) {
                object3 = values.getList("prog_detail/executable_panel/executable_args", EXECUTABLE_ARG_NAME);
                object2 = values.getList("prog_detail/executable_panel/executable_args", EXECUTABLE_ARG_TYPE);
                object = values.getList("prog_detail/executable_panel/executable_args", EXECUTABLE_ARG_VALUE);
                n = object3.size();
                this.processArgs(arrayList, (List<String>)object3, (List<String>)object2, (List<String>)object);
                string5 = values.get("prog_detail/executable_panel/executable_name");
            } else if (string6.equals(PROG_TYPE_EXTERNAL_SCRIPT)) {
                n = 0;
                string5 = values.get("prog_detail/external_script_panel/external_script_text");
            } else if (string6.equals(PROG_TYPE_SQL_SCRIPT)) {
                n = 0;
                string5 = values.get("prog_detail/sql_script_panel/sql_script_text");
            } else if (string6.equals(PROG_TYPE_BACKUP_SCRIPT)) {
                n = 0;
                string5 = values.get("prog_detail/backup_script_panel/backup_script_text");
            } else if (string6.equals(PROG_TYPE_SCRIPT)) {
                n = 0;
                string5 = values.get("prog_detail/script_panel/script_text");
            }
        }
        if (string5.equals("") || string5.equals("\"\"")) {
            string5 = null;
        }
        object3 = new TreeMap();
        object3.put(OWNER, string2);
        object3.put(NAME, string3);
        object3.put(ENABLED, bl);
        object3.put(COMMENTS, string4);
        object3.put(PROGRAM_ACTION, string5);
        object3.put(PROGRAM_TYPE, string7);
        object3.put(NUMBER_OF_ARGUMENTS, n);
        object2 = new TreeMap();
        object2.put(NAME, ProgramCreateAction.equals(string3, this.program_name) == false);
        object2.put(ENABLED, ProgramCreateAction.equals(bl, this.enabled) == false);
        object2.put(COMMENTS, ProgramCreateAction.equals(string4, this.comments) == false);
        object2.put(PROGRAM_ACTION, ProgramCreateAction.equals(string5, this.action) == false);
        object2.put(PROGRAM_TYPE, ProgramCreateAction.equals(string7, this.convertToSchedulerProgType(this.program_type, this.script_type)) == false);
        object2.put(NUMBER_OF_ARGUMENTS, ProgramCreateAction.equals(n, this.numberOfArguments) == false);
        object = new TreeMap();
        ActionValuesLookup actionValuesLookup = values.getTabLookup(ADVANCED_PROPERTIES);
        Connection connection = this.getDBObject().getConnection();
        boolean bl2 = DBUtil.checkVersion((Connection)connection, null, (Version)new Version("10.2"));
        if (bl2) {
            this.advancedPropertiesTab.getScriptForProperties(actionValuesLookup, (Map<String, Object>)object3, (Map<String, Boolean>)object2, (Map<String, Boolean>)object, operation);
        }
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("model", object3);
        treeMap.put("changes", object2);
        treeMap.put("isnull", object);
        treeMap.put(ARGUMENTS, arrayList);
        String string9 = null;
        switch (operation) {
            case UPDATE: {
                int n2;
                Vector<ProgramArgument> vector = new Vector<ProgramArgument>();
                Vector<Integer> vector2 = new Vector<Integer>();
                treeMap.put("arguments_to_update", vector);
                treeMap.put("arguments_to_drop", vector2);
                for (n2 = 0; n2 < this.originalNumberOfArguments; ++n2) {
                    vector2.add(n2 + 1);
                }
                for (n2 = 0; n2 < n; ++n2) {
                    ProgramArgument programArgument = (ProgramArgument)arrayList.get(n2);
                    vector.add(programArgument);
                }
                string9 = dBMSSchedulerCodeGenerator.generate(string, "PROGRAM_UPDATE", treeMap);
                break;
            }
            case CREATE_LIKE: {
                string9 = dBMSSchedulerCodeGenerator.generate(string, "PROGRAM_CREATE", treeMap);
                break;
            }
            case CREATE_NEW: {
                string9 = dBMSSchedulerCodeGenerator.generate(string, "PROGRAM_CREATE", treeMap);
            }
        }
        return string9;
    }

    private static Boolean equals(Object object, Object object2) {
        if (object == null) {
            if (object2 == null) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (object2 == null) {
            return Boolean.FALSE;
        }
        return object.equals(object2);
    }

    public boolean isEnabled(Context context) {
        Version version = new Version("10");
        return DBUtil.checkVersion((Connection)this.getDBObject().getConnection(), null, (Version)version) && super.isEnabled(context);
    }

    public boolean is12orGreater() {
        Version version = new Version("12");
        return DBUtil.checkVersion((Connection)this.getDBObject().getConnection(), null, (Version)version);
    }

    protected void initializeValues(JEWTDialog jEWTDialog) {
        int n = jEWTDialog.getButtonMask();
        jEWTDialog.setButtonMask(n |= 4);
        Operation operation = this.getOperation();
        if (operation == Operation.CREATE_NEW) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), "f1_createProgramDialog_html");
        } else {
            HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), "f1_updateProgramDialog_html");
        }
    }

    private void processArgs(List<ProgramArgument> list, List<String> list2, List<String> list3, List<String> list4) {
        for (int i = 0; i < list2.size(); ++i) {
            ProgramArgument programArgument = new ProgramArgument();
            String string = list4.get(i);
            programArgument.argument_name = this.quoteIdentifier(list2.get(i));
            programArgument.argument_position = i + 1;
            programArgument.argument_type = list3.get(i);
            if (string != null && string.toUpperCase().startsWith(METADATA_ATTRIBUTE_PREFIX)) {
                programArgument.metadata_attribute = Boolean.TRUE;
                programArgument.metadata_attribute_name = string.substring(METADATA_ATTRIBUTE_PREFIX.length());
            } else {
                programArgument.default_value = string != null && string.equals("<NO VALUE>") ? null : string;
            }
            list.add(programArgument);
        }
    }

    protected Timer getLocalStoredProcedureArgumentTimer() {
        if (this.localStoredProcedureArgumentTimer == null) {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ProgramCreateAction.this.updateLocalStoredProcedureArguments();
                }
            };
            this.localStoredProcedureArgumentTimer = new Timer(500, actionListener);
            this.localStoredProcedureArgumentTimer.setRepeats(false);
        }
        return this.localStoredProcedureArgumentTimer;
    }

    private static String getStringFromRS(ResultSet resultSet, String string) {
        try {
            return resultSet.getString(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static int getIntFromRS(ResultSet resultSet, String string) {
        try {
            return resultSet.getInt(string);
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    private String convertToSchedulerProgType(String string, String string2) {
        if (string != null) {
            if (string.equals(PROG_TYPE_REMOTE_STORED_PROCEDURE) || string.equals(PROG_TYPE_STORED_PROCEDURE)) {
                string = SQL_PROG_TYPE_STORED_PROCEDURE;
            } else if (string.equals(PROG_TYPE_PLSQL_BLOCK)) {
                string = SQL_PROG_TYPE_PLSQL_BLOCK;
            } else if (string.equals(PROG_TYPE_EXECUTABLE)) {
                string = SQL_PROG_TYPE_EXECUTABLE;
            } else if (string.equals(PROG_TYPE_EXTERNAL_SCRIPT)) {
                string = SQL_PROG_TYPE_EXTERNAL_SCRIPT;
            } else if (string.equals(PROG_TYPE_SQL_SCRIPT)) {
                string = SQL_PROG_TYPE_SQL_SCRIPT;
            } else if (string.equals(PROG_TYPE_BACKUP_SCRIPT)) {
                string = SQL_PROG_TYPE_BACKUP_SCRIPT;
            } else if (string.equals(PROG_TYPE_SCRIPT) && string2 != null) {
                string = this.convertToSchedulerProgType(string2, null);
            }
        }
        return string;
    }

    protected void updateLocalStoredProcedureArguments() {
        Object object;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        DBObject dBObject = this.getDBObject();
        String string = dBObject.getDBVersion();
        String string2 = this.localProcedureOwnerCtl.getValue().get();
        String string3 = this.localProcedureNameCtl.getValue().get();
        String string4 = null;
        if (string2 != null) {
            object = new IdentifierImpl(string2.trim());
            string2 = ((IdentifierImpl)object).getId(false);
        }
        if (string3 != null) {
            string3 = string3.trim();
        }
        if (string3 == null || string3.trim().length() == 0) {
            this.localStoredProcedureNumberOfArgs = 0;
            return;
        }
        if (string3.indexOf(".") > 0) {
            object = new QualifiedIdentifier(string3);
            string4 = ((QualifiedIdentifier)object).getUserNameId().getId(false);
            string3 = ((QualifiedIdentifier)object).getObjectNameId().getId(false);
        }
        if (string2 != null && string2.startsWith("\"") && (string2 = string2.substring(1)).endsWith("\"")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string4 != null && string4.startsWith("\"") && (string4 = string4.substring(1)).endsWith("\"")) {
            string4 = string4.substring(0, string4.length() - 1);
        }
        if (string3 != null && string3.startsWith("\"") && (string3 = string3.substring(1)).endsWith("\"")) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        this.getLocalStoredProcedureArgumentTimer().stop();
        hashtable.put("schemaName", string2);
        hashtable.put("procName", string3);
        if (string4 != null) {
            hashtable.put("packageName", string4);
        }
        object = dBMSSchedulerCodeGenerator.generate(string, "PROGRAM_MODEL_PROCEDURE_ARGUMENTS", hashtable);
        ProgramPropertyPanelDBQuery programPropertyPanelDBQuery = new ProgramPropertyPanelDBQuery(dBObject.getConnectionName(), string3, string4, string2, SchedulerArb.getString("PROGRAMPANEL_MODEL_UPDATE.TASK") + "_15", (String)object){

            @Override
            public void processRS(ResultSet resultSet) throws SQLException {
                final Vector<LocalProcArgumentRow> vector = new Vector<LocalProcArgumentRow>();
                while (resultSet.next()) {
                    String string = ProgramCreateAction.getStringFromRS(resultSet, "ARGUMENT_NAME");
                    int n = ProgramCreateAction.getIntFromRS(resultSet, "POSITION") - 1;
                    String string2 = ProgramCreateAction.getStringFromRS(resultSet, "DATA_TYPE");
                    String string3 = ProgramCreateAction.getStringFromRS(resultSet, "DEFAULT_VALUE");
                    String string4 = ProgramCreateAction.getStringFromRS(resultSet, "IN_OUT");
                    vector.add(new LocalProcArgumentRow(string, string2, null, string3));
                }
                ProgramCreateAction.this.localStoredProcedureNumberOfArgs = vector.size();
                ProgramCreateAction.runOnDispatchThread(new Runnable(){

                    @Override
                    public void run() {
                        ProgramCreateAction.this.localProcedureTableCtl.setRows(vector);
                        TableActionControlPanel tableActionControlPanel = (TableActionControlPanel)ProgramCreateAction.this.localProcedureTableCtl.getUI();
                        JTable jTable = tableActionControlPanel.getTable();
                        TableColumnModel tableColumnModel = jTable.getColumnModel();
                        TableColumn tableColumn = tableColumnModel.getColumn(2);
                        tableColumn.setCellRenderer(ProgramCreateAction.this.argumentValueCellRenderer);
                        tableColumn.setCellEditor(ProgramCreateAction.this.argumentValueCellEditor);
                    }
                });
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)programPropertyPanelDBQuery);
    }

    public static Throwable runOnDispatchThread(Runnable runnable) {
        Throwable throwable = null;
        try {
            if (!EventQueue.isDispatchThread()) {
                SwingUtilities.invokeAndWait(runnable);
            } else {
                runnable.run();
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throwable = invocationTargetException.getCause();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        return throwable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLocalPackage(Connection connection, String string, String string2) throws SQLException {
        String string3 = DBUtil.getDbVersion((Connection)connection).toCanonicalString();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        boolean bl = false;
        if (connection != null && string != null) {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            ResultSet resultSet = null;
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put(OWNER_BIND_NAME, ProgramCreateAction.unQuote(string));
            treeMap.put(PACKAGE_BIND_NAME, ProgramCreateAction.unQuote(string2));
            String string4 = dBMSSchedulerCodeGenerator.generate(string3, "IS_LOCAL_PROGRAM_PACKAGE_EXACT", null);
            dBUtil.setRaiseError(true);
            if (string2 != null) {
                block6: {
                    try {
                        resultSet = dBUtil.executeOracleQuery(string4, treeMap);
                        if (resultSet == null) break block6;
                        bl = resultSet.next();
                    }
                    catch (Exception exception) {
                        try {
                            Logger.getLogger(ProgramCreateAction.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        }
                        catch (Throwable throwable) {
                            DBUtil.closeResultSet(resultSet);
                            throw throwable;
                        }
                        DBUtil.closeResultSet((ResultSet)resultSet);
                    }
                }
                DBUtil.closeResultSet((ResultSet)resultSet);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLocalStoredProcedure(Connection connection, String string, String string2, String string3) throws SQLException {
        block23: {
            String string4;
            String string5;
            TreeMap<String, Object> treeMap;
            ResultSet resultSet;
            DBUtil dBUtil;
            boolean bl;
            boolean bl2;
            boolean bl3;
            block21: {
                String string6 = DBUtil.getDbVersion((Connection)connection).toCanonicalString();
                DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
                bl3 = false;
                bl2 = false;
                bl = false;
                if (connection == null || string == null || string3 == null) break block23;
                dBUtil = DBUtil.getInstance((Connection)connection);
                resultSet = null;
                treeMap = new TreeMap<String, Object>();
                treeMap.put(OWNER_BIND_NAME, ProgramCreateAction.unQuote(string));
                treeMap.put(PROCEDURE_BIND_NAME, ProgramCreateAction.unQuote(string3));
                String string7 = dBMSSchedulerCodeGenerator.generate(string6, "IS_LOCAL_PROGRAM_SCHEMA_EXACT", null);
                string5 = dBMSSchedulerCodeGenerator.generate(string6, "IS_LOCAL_PROGRAM_PACKAGE_EXACT", null);
                if (string2 == null) {
                    string4 = dBMSSchedulerCodeGenerator.generate(string6, "IS_LOCAL_PROGRAM_PROCEDURE_EXACT", treeMap);
                } else {
                    treeMap.put(PACKAGE_BIND_NAME, ProgramCreateAction.unQuote(string2));
                    string4 = dBMSSchedulerCodeGenerator.generate(string6, "IS_LOCAL_PROGRAM_PKG_PROCEDURE_EXACT", treeMap);
                }
                dBUtil.setRaiseError(true);
                try {
                    resultSet = dBUtil.executeOracleQuery(string7, treeMap);
                    if (resultSet == null) break block21;
                    bl3 = resultSet.next();
                }
                catch (Exception exception) {
                    try {
                        Logger.getLogger(ProgramCreateAction.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        throw throwable;
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            if (bl3) {
                bl2 = true;
                if (string2 != null) {
                    try {
                        resultSet = dBUtil.executeOracleQuery(string5, treeMap);
                        if (resultSet != null) {
                            bl2 = resultSet.next();
                        }
                    }
                    catch (Exception exception) {
                        Logger.getLogger(ProgramCreateAction.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                    finally {
                        DBUtil.closeResultSet((ResultSet)resultSet);
                    }
                }
                if (bl2) {
                    try {
                        resultSet = dBUtil.executeOracleQuery(string4, treeMap);
                        if (resultSet != null) {
                            boolean bl4 = bl = resultSet.next();
                            return bl4;
                        }
                    }
                    catch (Exception exception) {
                        Logger.getLogger(ProgramCreateAction.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                    finally {
                        DBUtil.closeResultSet((ResultSet)resultSet);
                    }
                }
            }
        }
        return false;
    }

    private static class ProgramArgument {
        public int argument_position;
        public String owner;
        public String program_name;
        public String argument_name;
        public boolean metadata_attribute = false;
        public String metadata_attribute_name = null;
        public String argument_type;
        public String default_value;
        public String out_argument;

        private ProgramArgument() {
        }
    }

    private class ArgumentValueCellRenderer
    implements TableCellRenderer {
        private ArgumentValueCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
            String string = ";" + dBMSSchedulerCodeGenerator.generate(ProgramCreateAction.this.getDBObject().getConnection(), "ARGUMENT_METADATA_ATTRIBUTES", null);
            String[] stringArray = string.split(";");
            ProgramCreateAction.this.argumentValueRendererJComboBox.setModel(new DefaultComboBoxModel<String>(stringArray));
            ProgramCreateAction.this.argumentValueRendererJComboBox.setEditable(true);
            ProgramCreateAction.this.argumentValueRendererJComboBox.setSelectedItem(object);
            return ProgramCreateAction.this.argumentValueRendererJComboBox;
        }
    }

    private class ArgumentValueCellEditor
    extends DefaultCellEditor {
        public ArgumentValueCellEditor() {
            super(ProgramCreateAction.this.argumentValueEditorJComboBox);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
            String string = ";" + dBMSSchedulerCodeGenerator.generate(ProgramCreateAction.this.getDBObject().getConnection(), "ARGUMENT_METADATA_ATTRIBUTES", null);
            String[] stringArray = string.split(";");
            ProgramCreateAction.this.argumentValueEditorJComboBox.setModel(new DefaultComboBoxModel<String>(stringArray));
            ProgramCreateAction.this.argumentValueEditorJComboBox.setEditable(true);
            ProgramCreateAction.this.argumentValueEditorJComboBox.setSelectedItem(object);
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }
    }

    private class ScriptArgTypeCellRenderer
    implements TableCellRenderer {
        private ScriptArgTypeCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ProgramCreateAction.this.argumentTypeRendererJComboBox.setSelectedItem(object);
            return ProgramCreateAction.this.argumentTypeRendererJComboBox;
        }
    }

    private class ScriptArgTypeCellEditor
    extends DefaultCellEditor {
        public ScriptArgTypeCellEditor() {
            super(ProgramCreateAction.this.argumentTypeEditorJComboBox);
        }
    }

    private class ExecutableArgTypeCellRenderer
    implements TableCellRenderer {
        private ExecutableArgTypeCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ProgramCreateAction.this.argumentTypeRendererJComboBox.setSelectedItem(object);
            return ProgramCreateAction.this.argumentTypeRendererJComboBox;
        }
    }

    private class ExecutableArgTypeCellEditor
    extends DefaultCellEditor {
        public ExecutableArgTypeCellEditor() {
            super(ProgramCreateAction.this.argumentTypeEditorJComboBox);
        }
    }

    private class LocalProcedureNameChangeListener
    implements PropertyChangeListener {
        private LocalProcedureNameChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Throwable throwable;
            Object object = propertyChangeEvent.getNewValue();
            if (ProgramCreateAction.this.initialising) {
                return;
            }
            if (object instanceof ActionControl.Value && (throwable = ProgramCreateAction.runOnDispatchThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ComboBoxActionControl comboBoxActionControl = ProgramCreateAction.this.localProcedureNameCtl;
                    synchronized (comboBoxActionControl) {
                        ArrayList arrayList = new ArrayList();
                        ProgramCreateAction.this.localProcedureTableCtl.setRows(arrayList);
                        ProgramCreateAction.this.getLocalStoredProcedureArgumentTimer().restart();
                    }
                }
            })) != null) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, throwable.getStackTrace()[0].toString(), throwable);
            }
        }
    }

    private class LocalProcedureSchemaChangeListener
    implements PropertyChangeListener {
        private LocalProcedureSchemaChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ArrayList arrayList = new ArrayList();
            ProgramCreateAction.this.localProcedureTableCtl.setRows(arrayList);
            ProgramCreateAction.this.updateProcedureNameListForSchema(ProgramCreateAction.this.localProcedureOwnerCtl.getValue().get(), null);
        }
    }

    private class ListTask
    extends DatabaseQueryTask<List<String>> {
        public ListTask() {
            super("ProgramListTask", IRaptorTaskRunMode.NO_GUI, false, false);
        }

        public String getConnectionName() {
            return ProgramCreateAction.this.getDBObject().getConnectionName();
        }

        public String getQuery() {
            DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
            String string = dBMSSchedulerCodeGenerator.generate(ProgramCreateAction.this.getDBObject().getDBVersion(), "PROGRAM_LIST", null);
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<String> doWork() throws TaskException {
            Vector<String> vector = new Vector<String>();
            Connection connection = ProgramCreateAction.this.getDBObject().getConnection();
            DBUtil.getConnectionResolver().lock(connection);
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                ResultSet resultSet = dBUtil.executeOracleQuery(this.getQuery(), null);
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString("PROGRAM_NAME");
                        vector.add(string);
                    }
                }
                finally {
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
            }
            catch (Throwable throwable) {
                throw new TaskException(throwable);
            }
            finally {
                DBUtil.getConnectionResolver().unlock(connection);
            }
            return vector;
        }
    }

    private class ExecJobArgumentRowFactory
    implements TableActionControl.RowFactory {
        int rowCount = 1;

        private ExecJobArgumentRowFactory() {
        }

        public TableActionControl.Row createRow(int n, TableActionControl.Row row) {
            ExecJobArgumentRow execJobArgumentRow = null;
            execJobArgumentRow = new ExecJobArgumentRow(null, "CHAR", null);
            ++this.rowCount;
            return execJobArgumentRow;
        }
    }

    private class ExecJobArgumentRow
    implements TableActionControl.Row {
        private String[] _cols;

        ExecJobArgumentRow(String string, String string2, String string3) {
            this._cols = new String[]{string, string2, string3};
        }

        String[] getCols() {
            return this._cols;
        }

        public String getValue(int n) {
            return this._cols[n];
        }

        public boolean isValueEditable(int n) {
            return true;
        }

        public void setValue(int n, String string) {
            this._cols[n] = string;
        }
    }

    private class RemoteProcArgumentRowFactory
    implements TableActionControl.RowFactory {
        int rowCount = 1;

        private RemoteProcArgumentRowFactory() {
        }

        public TableActionControl.Row createRow(int n, TableActionControl.Row row) {
            RemoteProcArgumentRow remoteProcArgumentRow = null;
            remoteProcArgumentRow = new RemoteProcArgumentRow(null, "CHAR", null, null);
            ++this.rowCount;
            return remoteProcArgumentRow;
        }
    }

    private class RemoteProcArgumentRow
    implements TableActionControl.Row {
        private String[] _cols;

        RemoteProcArgumentRow(String string, String string2, String string3, String string4) {
            String string5 = string4;
            if (string3 != null && string3.trim().length() > 0) {
                string5 = ProgramCreateAction.METADATA_ATTRIBUTE_PREFIX + string3;
            }
            this._cols = new String[]{string, string2, string5};
        }

        public String[] getCols() {
            return this._cols;
        }

        public String getValue(int n) {
            return this._cols[n];
        }

        public boolean isValueEditable(int n) {
            return n != 1;
        }

        public void setValue(int n, String string) {
            this._cols[n] = string;
        }
    }

    private class LocalProcArgumentRow
    implements TableActionControl.Row {
        private String[] _cols;

        LocalProcArgumentRow(String string, String string2, String string3, String string4) {
            String string5 = string4;
            if (string3 != null && string3.trim().length() > 0) {
                string5 = ProgramCreateAction.METADATA_ATTRIBUTE_PREFIX + string3;
            }
            this._cols = new String[]{string, string2, string5};
        }

        String[] getCols() {
            return this._cols;
        }

        public String getValue(int n) {
            return this._cols[n];
        }

        public boolean isValueEditable(int n) {
            return n != 1;
        }

        public void setValue(int n, String string) {
            this._cols[n] = string;
        }
    }

    public static enum Operation {
        CREATE_NEW,
        CREATE_LIKE,
        UPDATE;

    }
}

