/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.filewatcher;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.datatypes.objects.OraINTERVALDS;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.DateTimeEditor;
import oracle.dbtools.raptor.ui.controls.DirectoryPathActionControl;
import oracle.dbtools.raptor.ui.controls.FileSizeActionControl;
import oracle.dbtools.raptor.ui.controls.IntervalActionControl;
import oracle.dbtools.raptor.ui.controls.NameBoxActionControl;
import oracle.dbtools.raptor.ui.controls.OptionalActionControl;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;
import oracle.dbtools.scheduler.panels.IdSqlComboBoxActionControl;
import oracle.dbtools.scheduler.panels.common.ActionDialogBase;
import oracle.dbtools.scheduler.panels.common.ObjectNameValidator;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.IdentifierImpl;
import oracle.ide.Context;
import oracle.ide.help.HelpSystem;
import oracle.jdbc.OracleResultSet;
import oracle.sql.INTERVALDS;

public class FileWatcherCreateAction
extends ActionDialogBase {
    public static final String OWNER = "owner";
    public static final String FILE_WATCHER_NAME = "file_watcher_name";
    public static final String ENABLED = "enabled";
    public static final String DESTINATION = "destination";
    public static final String DIRECTORY_PATH = "directory_path";
    public static final String FILE_NAME = "file_name";
    public static final String CREDENTIAL_NAME = "credential_name";
    public static final String MIN_FILE_SIZE = "min_file_size";
    public static final String STEADY_STATE_DURATION = "steady_state_duration";
    public static final String COMMENTS = "comments";
    DateTimeEditor dd;
    boolean showOwner = false;
    String owner = null;
    String file_watcher_name = null;
    Boolean enabled = true;
    String destination = null;
    String directory_path = null;
    String file_name = null;
    String credential_name = null;
    long min_file_size = 0L;
    OraINTERVALDS steady_state_duration = null;
    String comments = null;
    ActionControl ownerCtl = null;
    NameBoxActionControl file_watcher_nameCtl = null;
    ActionControl enabledCtl = null;
    IdSqlComboBoxActionControl destinationCtl = null;
    DirectoryPathActionControl directory_pathCtl = null;
    ActionControl file_nameCtl = null;
    IdSqlComboBoxActionControl credential_nameCtl = null;
    ActionControl min_file_sizeCtl = null;
    ActionControl steady_state_durationCtl = null;
    ActionControl commentsCtl = null;
    ActionControl optional_steady_state_durationCtl = null;

    protected String getTitle() {
        return SchedulerArb.getString("FILE_WATCHER_CREATEDIALOG_TITLE");
    }

    protected String getQuery(Connection connection, String string) {
        String string2 = DBUtil.getDbVersion((Connection)connection).toCanonicalString();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        return dBMSSchedulerCodeGenerator.generate(string2, string, null);
    }

    protected boolean isCloseOnError() {
        return false;
    }

    @Override
    protected DatabaseQueryTask<List<String>> getListTask() {
        return new ListFileWatchersTask();
    }

    @Override
    protected String getObjectType() {
        return "SCHFILEWATCHER";
    }

    private Operation getOperation() {
        return Operation.valueOf(this.getArgs());
    }

    private OraINTERVALDS getIntervalFromRS(OracleResultSet oracleResultSet, String string) {
        try {
            INTERVALDS iNTERVALDS = oracleResultSet.getINTERVALDS(string);
            String string2 = iNTERVALDS.stringValue();
            OraINTERVALDS oraINTERVALDS = OraINTERVALDS.getInstance((INTERVALDS)iNTERVALDS);
            string2 = oraINTERVALDS.toString();
            return oraINTERVALDS;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        Object object;
        Operation operation;
        HashMap<String, Object> hashMap;
        block20: {
            String string;
            block21: {
                String string2;
                hashMap = new HashMap<String, Object>();
                operation = this.getOperation();
                try {
                    string2 = this.getObjectName();
                }
                catch (Exception exception) {
                    string2 = "null";
                }
                try {
                    string = this.getDBObjectSchemaName();
                    if (string == null) {
                        string = this.getDBObject().getSchemaName();
                    }
                }
                catch (Exception exception) {
                    string = "null";
                }
                hashMap.put("OBJECT_OWNER", string);
                if (operation == Operation.CREATE_NEW) break block21;
                if (!Connections.getInstance().lock(connection)) break block20;
                object = null;
                try {
                    hashMap.put("OBJECT_NAME", string2);
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    object = dBUtil.executeOracleQuery(this.getQuery(connection, "FILE_WATCHER_DATA"), hashMap);
                    if (object != null && object.next()) {
                        this.owner = object.getString("OWNER");
                        this.file_watcher_name = operation != Operation.UPDATE ? "" : object.getString("FILE_WATCHER_NAME");
                        String string3 = object.getString("DESTINATION_OWNER");
                        String string4 = object.getString("DESTINATION");
                        if (string4 != null) {
                            this.destination = "\"" + string3 + "\"." + "\"" + string4 + "\"";
                        }
                        this.directory_path = object.getString("DIRECTORY_PATH");
                        this.file_name = object.getString("FILE_NAME");
                        string3 = object.getString("CREDENTIAL_OWNER");
                        String string5 = object.getString("CREDENTIAL_NAME");
                        if (string5 != null) {
                            this.credential_name = "\"" + string3 + "\"." + "\"" + string5 + "\"";
                        }
                        this.min_file_size = object.getLong("MIN_FILE_SIZE");
                        this.steady_state_duration = this.getIntervalFromRS((OracleResultSet)object, "STEADY_STATE_DURATION");
                        this.comments = object.getString("COMMENTS");
                        this.enabled = Boolean.valueOf(object.getString("ENABLED"));
                    }
                    DBUtil.closeResultSet((ResultSet)object);
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    break block20;
                }
                finally {
                    DBUtil.closeResultSet(object);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
                break block20;
            }
            this.owner = string;
            this.enabled = Boolean.TRUE;
        }
        switch (operation) {
            case UPDATE: {
                this.ownerCtl = new TextBoxActionControl(OWNER, SchedulerArb.getString("FILE_WATCHER_OWNER_LABEL"), this.owner);
                object = ObjectNameValidator.displayName(this.file_watcher_name);
                this.file_watcher_nameCtl = new NameBoxActionControl(FILE_WATCHER_NAME, SchedulerArb.getString("FILE_WATCHER_FILE_WATCHER_NAME_LABEL"), (String)object);
                this.destinationCtl = new IdSqlComboBoxActionControl(DESTINATION, SchedulerArb.getString("FILE_WATCHER_DESTINATION_LABEL"), connection, this.getQuery(connection, "FILE_WATCHER_EXT_DESTINATION_LIST"), hashMap, this.destination);
                this.directory_pathCtl = new DirectoryPathActionControl(DIRECTORY_PATH, SchedulerArb.getString("FILE_WATCHER_DIRECTORY_PATH_LABEL"), this.directory_path, 0);
                this.file_nameCtl = new TextBoxActionControl(FILE_NAME, SchedulerArb.getString("FILE_WATCHER_FILE_NAME_LABEL"), this.file_name);
                this.credential_nameCtl = new IdSqlComboBoxActionControl(CREDENTIAL_NAME, SchedulerArb.getString("FILE_WATCHER_CREDENTIAL_NAME_LABEL"), connection, this.getQuery(connection, "FILE_WATCHER_CRED_LIST"), hashMap, this.credential_name);
                this.min_file_sizeCtl = new FileSizeActionControl(MIN_FILE_SIZE, SchedulerArb.getString("FILE_WATCHER_MIN_FILE_SIZE_LABEL"), this.min_file_size);
                this.steady_state_durationCtl = new IntervalActionControl(STEADY_STATE_DURATION, SchedulerArb.getString("FILE_WATCHER_STEADY_STATE_DURATION_LABEL"), this.steady_state_duration, true, false);
                this.optional_steady_state_durationCtl = this.steady_state_duration != null ? new OptionalActionControl(true, this.steady_state_durationCtl) : new OptionalActionControl(false, this.steady_state_durationCtl);
                this.enabledCtl = new BooleanCheckBoxActionControl(ENABLED, SchedulerArb.getString("FILE_WATCHER_ENABLED_LABEL"), this.enabled.booleanValue(), false);
                this.commentsCtl = new TextBoxActionControl(COMMENTS, SchedulerArb.getString("FILE_WATCHER_COMMENTS_LABEL"), this.comments);
                this.ownerCtl.setEditable(false);
                this.file_watcher_nameCtl.setEditable(false);
                break;
            }
            case CREATE_LIKE: {
                this.ownerCtl = new SqlComboBoxActionControl(OWNER, SchedulerArb.getString("FILE_WATCHER_OWNER_LABEL"), connection, this.getQuery(connection, "SCHEMAS_LIST"), null, this.owner);
                this.file_watcher_nameCtl = new NameBoxActionControl(FILE_WATCHER_NAME, SchedulerArb.getString("FILE_WATCHER_FILE_WATCHER_NAME_LABEL"), this.file_watcher_name);
                this.destinationCtl = new IdSqlComboBoxActionControl(DESTINATION, SchedulerArb.getString("FILE_WATCHER_DESTINATION_LABEL"), connection, this.getQuery(connection, "FILE_WATCHER_EXT_DESTINATION_LIST"), hashMap, this.destination);
                this.directory_pathCtl = new DirectoryPathActionControl(DIRECTORY_PATH, SchedulerArb.getString("FILE_WATCHER_DIRECTORY_PATH_LABEL"), this.directory_path, 0);
                this.file_nameCtl = new TextBoxActionControl(FILE_NAME, SchedulerArb.getString("FILE_WATCHER_FILE_NAME_LABEL"), this.file_name);
                this.credential_nameCtl = new IdSqlComboBoxActionControl(CREDENTIAL_NAME, SchedulerArb.getString("FILE_WATCHER_CREDENTIAL_NAME_LABEL"), connection, this.getQuery(connection, "FILE_WATCHER_CRED_LIST"), hashMap, this.credential_name);
                this.min_file_sizeCtl = new FileSizeActionControl(MIN_FILE_SIZE, SchedulerArb.getString("FILE_WATCHER_MIN_FILE_SIZE_LABEL"), this.min_file_size);
                this.steady_state_durationCtl = new IntervalActionControl(STEADY_STATE_DURATION, SchedulerArb.getString("FILE_WATCHER_STEADY_STATE_DURATION_LABEL"), this.steady_state_duration, true, false);
                this.optional_steady_state_durationCtl = this.steady_state_duration != null ? new OptionalActionControl(true, this.steady_state_durationCtl) : new OptionalActionControl(false, this.steady_state_durationCtl);
                this.enabledCtl = new BooleanCheckBoxActionControl(ENABLED, SchedulerArb.getString("FILE_WATCHER_ENABLED_LABEL"), this.enabled.booleanValue(), false);
                this.commentsCtl = new TextBoxActionControl(COMMENTS, SchedulerArb.getString("FILE_WATCHER_COMMENTS_LABEL"), this.comments);
                break;
            }
            case CREATE_NEW: {
                this.ownerCtl = new SqlComboBoxActionControl(OWNER, SchedulerArb.getString("FILE_WATCHER_OWNER_LABEL"), connection, this.getQuery(connection, "SCHEMAS_LIST"), null, this.owner);
                this.file_watcher_nameCtl = new NameBoxActionControl(FILE_WATCHER_NAME, SchedulerArb.getString("FILE_WATCHER_FILE_WATCHER_NAME_LABEL"), this.file_watcher_name);
                this.destinationCtl = new IdSqlComboBoxActionControl(DESTINATION, SchedulerArb.getString("FILE_WATCHER_DESTINATION_LABEL"), connection, this.getQuery(connection, "FILE_WATCHER_EXT_DESTINATION_LIST"), hashMap, this.destination);
                this.directory_pathCtl = new DirectoryPathActionControl(DIRECTORY_PATH, SchedulerArb.getString("FILE_WATCHER_DIRECTORY_PATH_LABEL"), this.directory_path, 0);
                this.file_nameCtl = new TextBoxActionControl(FILE_NAME, SchedulerArb.getString("FILE_WATCHER_FILE_NAME_LABEL"), this.file_name);
                this.credential_nameCtl = new IdSqlComboBoxActionControl(CREDENTIAL_NAME, SchedulerArb.getString("FILE_WATCHER_CREDENTIAL_NAME_LABEL"), connection, this.getQuery(connection, "FILE_WATCHER_CRED_LIST"), hashMap, this.credential_name);
                this.min_file_sizeCtl = new FileSizeActionControl(MIN_FILE_SIZE, SchedulerArb.getString("FILE_WATCHER_MIN_FILE_SIZE_LABEL"), this.min_file_size);
                this.steady_state_durationCtl = new IntervalActionControl(STEADY_STATE_DURATION, SchedulerArb.getString("FILE_WATCHER_STEADY_STATE_DURATION_LABEL"), this.steady_state_duration, true, false);
                this.optional_steady_state_durationCtl = this.steady_state_duration != null ? new OptionalActionControl(true, this.steady_state_durationCtl) : new OptionalActionControl(false, this.steady_state_durationCtl);
                this.enabledCtl = new BooleanCheckBoxActionControl(ENABLED, SchedulerArb.getString("FILE_WATCHER_ENABLED_LABEL"), this.enabled.booleanValue(), false);
                this.commentsCtl = new TextBoxActionControl(COMMENTS, SchedulerArb.getString("FILE_WATCHER_COMMENTS_LABEL"), this.comments);
            }
        }
        object = new ArrayList<ActionControl>();
        if (this.showOwner) {
            ((ArrayList)object).add(this.ownerCtl);
        } else {
            this.ownerCtl = new TextBoxActionControl(OWNER, SchedulerArb.getString("FILE_WATCHER_OWNER_LABEL"), this.owner);
        }
        ((ArrayList)object).add(this.file_watcher_nameCtl);
        ((ArrayList)object).add(this.enabledCtl);
        ((ArrayList)object).add(this.commentsCtl);
        ((ArrayList)object).add(this.destinationCtl);
        ((ArrayList)object).add(this.directory_pathCtl);
        ((ArrayList)object).add(this.file_nameCtl);
        ((ArrayList)object).add(this.credential_nameCtl);
        ((ArrayList)object).add(this.min_file_sizeCtl);
        ((ArrayList)object).add(this.optional_steady_state_durationCtl);
        return object;
    }

    protected String getScript(ActionDialog.Values values) {
        Operation operation = this.getOperation();
        String string = this.getDBObject().getDBVersion();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        String string2 = FileWatcherCreateAction.checkNull(new IdentifierImpl(this.ownerCtl.getValue().get()).getId(true));
        String string3 = values.get(FILE_WATCHER_NAME);
        if (string3 != null) {
            string3 = ObjectNameValidator.validateName(string3);
            string3 = string3.trim();
            IdentifierImpl identifierImpl = new IdentifierImpl(string3);
            string3 = identifierImpl.getId(true);
        }
        boolean bl = new Boolean(values.get(ENABLED));
        String string4 = FileWatcherCreateAction.checkNull(values.get(DESTINATION));
        String string5 = FileWatcherCreateAction.checkNull(values.get(DIRECTORY_PATH));
        String string6 = FileWatcherCreateAction.checkNull(values.get(FILE_NAME));
        String string7 = FileWatcherCreateAction.checkNull(values.get(CREDENTIAL_NAME));
        String string8 = values.get("min_file_size/Bytes");
        Long l = new Long(string8);
        String string9 = FileWatcherCreateAction.checkNull(values.get(STEADY_STATE_DURATION));
        String string10 = FileWatcherCreateAction.checkNull(values.get(COMMENTS));
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put(OWNER, string2);
        treeMap.put(FILE_WATCHER_NAME, string3);
        treeMap.put(ENABLED, bl);
        treeMap.put(DESTINATION, string4);
        treeMap.put(DIRECTORY_PATH, string5);
        treeMap.put(FILE_NAME, string6);
        treeMap.put(CREDENTIAL_NAME, string7);
        treeMap.put(MIN_FILE_SIZE, l);
        treeMap.put(STEADY_STATE_DURATION, string9);
        treeMap.put(COMMENTS, string10);
        TreeMap<String, Boolean> treeMap2 = new TreeMap<String, Boolean>();
        treeMap2.put(ENABLED, FileWatcherCreateAction.equals(bl, this.enabled) == false);
        treeMap2.put(DESTINATION, FileWatcherCreateAction.equals(string4, this.destination) == false);
        treeMap2.put(DIRECTORY_PATH, FileWatcherCreateAction.equals(string5, this.directory_path) == false);
        treeMap2.put(FILE_NAME, FileWatcherCreateAction.equals(string6, this.file_name) == false);
        treeMap2.put(CREDENTIAL_NAME, FileWatcherCreateAction.equals(string7, this.credential_name) == false);
        treeMap2.put(MIN_FILE_SIZE, FileWatcherCreateAction.equals(l, this.min_file_size) == false);
        String string11 = null;
        if (this.steady_state_duration != null) {
            string11 = this.steady_state_duration.toString();
        }
        treeMap2.put(STEADY_STATE_DURATION, FileWatcherCreateAction.equals(string9, string11) == false);
        treeMap2.put(COMMENTS, FileWatcherCreateAction.equals(string10, this.comments) == false);
        TreeMap<String, Object> treeMap3 = new TreeMap<String, Object>();
        treeMap3.put("model", treeMap);
        treeMap3.put("changes", treeMap2);
        String string12 = null;
        switch (operation) {
            case UPDATE: {
                string12 = dBMSSchedulerCodeGenerator.generate(string, "FILE_WATCHER_UPDATE", treeMap3);
                break;
            }
            case CREATE_LIKE: {
                string12 = dBMSSchedulerCodeGenerator.generate(string, "FILE_WATCHER_CREATE_LIKE", treeMap3);
                break;
            }
            case CREATE_NEW: {
                string12 = dBMSSchedulerCodeGenerator.generate(string, "FILE_WATCHER_CREATE", treeMap3);
            }
        }
        return string12;
    }

    private String stripQuotes(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1).trim();
        }
        return string;
    }

    private static Boolean equals(Object object, Object object2) {
        if (object == null && object2 == null) {
            return Boolean.TRUE;
        }
        if (object == null || object2 == null) {
            return Boolean.FALSE;
        }
        return object.equals(object2);
    }

    private static String checkNull(String string) {
        String string2 = string;
        if (string != null && (string.trim().length() == 0 || string.trim().equalsIgnoreCase("null") || string.trim().equalsIgnoreCase("\"null\""))) {
            string2 = null;
        }
        return string2;
    }

    public boolean isEnabled(Context context) {
        Version version = new Version("11");
        return DBUtil.checkVersion((Connection)this.getDBObject().getConnection(), null, (Version)version) && super.isEnabled(context);
    }

    protected void initializeValues(JEWTDialog jEWTDialog) {
        int n = jEWTDialog.getButtonMask();
        jEWTDialog.setButtonMask(n |= 4);
        HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), "f1_newFileWatcherDialog_html");
    }

    private class ListFileWatchersTask
    extends DatabaseQueryTask<List<String>> {
        public ListFileWatchersTask() {
            super("ListFileWatchersTask", IRaptorTaskRunMode.NO_GUI, false, false);
        }

        public String getConnectionName() {
            return FileWatcherCreateAction.this.getDBObject().getConnectionName();
        }

        public String getQuery() {
            DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
            String string = dBMSSchedulerCodeGenerator.generate(FileWatcherCreateAction.this.getDBObject().getDBVersion(), "FILE_WATCHER_LIST", null);
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<String> doWork() throws TaskException {
            Vector<String> vector = new Vector<String>();
            Connection connection = FileWatcherCreateAction.this.getDBObject().getConnection();
            DBUtil.getConnectionResolver().lock(connection);
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                ResultSet resultSet = dBUtil.executeOracleQuery(this.getQuery(), null);
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString("OWNER") + "." + resultSet.getString("FILE_WATCHER_NAME");
                        vector.add(string);
                    }
                }
                catch (Exception exception) {
                    throw new TaskException((Throwable)exception);
                }
                finally {
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
            }
            finally {
                DBUtil.getConnectionResolver().unlock(connection);
            }
            return vector;
        }
    }

    private static enum Operation {
        CREATE_NEW,
        CREATE_LIKE,
        UPDATE;

    }
}

