/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval.model;

import java.lang.reflect.Array;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.AbstractClauseModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ClauseElement;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ClauseType;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModelEvent;

public class UnaryClauseModel<E>
extends AbstractClauseModel<E> {
    protected E value;
    protected final E defaultValue;

    public UnaryClauseModel(Class<E> clazz, ClauseType clauseType, RepeatIntervalModel repeatIntervalModel) {
        this(clazz, clauseType, repeatIntervalModel, null);
    }

    public UnaryClauseModel(Class<E> clazz, ClauseType clauseType, RepeatIntervalModel repeatIntervalModel, E e) {
        super(clazz, clauseType, repeatIntervalModel);
        this.defaultValue = e;
        this.value = e;
    }

    @Override
    public E[] getAll() {
        Object[] objectArray = (Object[])Array.newInstance(this.clazz, 1);
        objectArray[0] = this.value;
        return objectArray;
    }

    @Override
    public void clear() {
        if (!UnaryClauseModel.areEqual(this.value, this.defaultValue)) {
            E e = this.value;
            this.value = this.defaultValue;
            this.fireRepeatIntervalModelEvent(new RepeatIntervalModelEvent(this, RepeatIntervalModelEvent.EventType.CLEAR, e, this.value));
        }
    }

    @Override
    public boolean isClear() {
        return this.contains(this.defaultValue);
    }

    @Override
    public void fireRefresh() {
        this.fireRepeatIntervalModelEvent(new RepeatIntervalModelEvent(this, RepeatIntervalModelEvent.EventType.REFRESH, this.value, this.value));
    }

    public E get() {
        return this.value;
    }

    public boolean set(E e) {
        if (!UnaryClauseModel.areEqual(this.value, e)) {
            E e2 = this.value;
            this.value = e;
            this.fireRepeatIntervalModelEvent(new RepeatIntervalModelEvent(this, RepeatIntervalModelEvent.EventType.UPDATE, e2, this.value));
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(E e) {
        return UnaryClauseModel.areEqual(this.value, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuilder buildClause(StringBuilder stringBuilder, String string) {
        int n;
        int n2 = n = stringBuilder.length();
        try {
            if (string != null && string.length() > 0) {
                stringBuilder.append(string);
                n2 = stringBuilder.length();
            }
            if (this.value instanceof ClauseElement) {
                ((ClauseElement)this.value).buildClause(stringBuilder);
            } else if (this.value != null) {
                stringBuilder.append(this.value);
            }
        }
        finally {
            if (n2 == stringBuilder.length() && n < n2) {
                stringBuilder.delete(n, n2);
            }
        }
        return stringBuilder;
    }

    @Override
    public int size() {
        return 1;
    }
}

