/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval.model;

import java.text.DecimalFormat;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ClauseElement;

public class Time
implements Comparable<Time>,
ClauseElement {
    protected final Integer second;
    protected final Integer minute;
    protected final Integer hour;

    private static boolean areEqual(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.equals(object2);
    }

    public Time(Integer n, Integer n2) {
        this(n, n2, null);
    }

    public Time(Integer n, Integer n2, Integer n3) {
        this.second = n;
        this.minute = n2;
        this.hour = n3;
    }

    public Time(Time time, ComponentType componentType) {
        this.second = componentType == ComponentType.SECOND ? time.second : null;
        this.minute = componentType == ComponentType.MINUTE ? time.minute : null;
        this.hour = componentType == ComponentType.HOUR ? time.hour : null;
    }

    @Override
    public int compareTo(Time time) {
        int n = 0;
        if (this != time) {
            if (this.hour != time.hour) {
                if (this.hour == null && time.hour != null) {
                    return -1;
                }
                if (this.hour != null && time.hour == null) {
                    return 1;
                }
                n = this.hour.compareTo(time.hour);
            }
            if (n == 0 && this.minute != time.minute) {
                n = this.minute == null && time.minute != null ? -1 : (this.minute != null && time.minute == null ? 1 : this.minute.compareTo(time.minute));
            }
            if (n == 0 && this.second != time.second) {
                n = this.second == null && time.second != null ? -1 : (this.second != null && time.second == null ? 1 : this.second.compareTo(time.second));
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        Time time = (Time)object;
        return Time.areEqual(this.hour, time.hour) && Time.areEqual(this.minute, time.minute) && Time.areEqual(this.second, time.second);
    }

    public int hashCode() {
        int n = 7;
        n = n * 31 + (this.hour == null ? 0 : this.hour.hashCode());
        n = n * 31 + (this.minute == null ? 0 : this.minute.hashCode());
        n = n * 31 + (this.second == null ? 0 : this.second.hashCode());
        return n;
    }

    public Integer getSecond() {
        return this.second;
    }

    public Integer getMinute() {
        return this.minute;
    }

    public Integer getHour() {
        return this.hour;
    }

    public Integer getComponent(ComponentType componentType) {
        switch (componentType) {
            case HOUR: {
                return this.getHour();
            }
            case MINUTE: {
                return this.getMinute();
            }
            case SECOND: {
                return this.getSecond();
            }
        }
        return null;
    }

    @Override
    public StringBuilder buildClause(StringBuilder stringBuilder) {
        DecimalFormat decimalFormat = new DecimalFormat("00");
        if (this.minute != null && this.second != null) {
            if (this.hour != null) {
                stringBuilder.append(decimalFormat.format(this.hour));
            }
            stringBuilder.append(decimalFormat.format(this.minute));
            stringBuilder.append(decimalFormat.format(this.second));
        }
        return stringBuilder;
    }

    public boolean isValid(boolean bl, boolean bl2) {
        boolean bl3 = this.hour == null && (!bl || bl2) || this.hour != null && bl && this.hour >= 0 && this.hour <= 23;
        boolean bl4 = this.minute == null && bl2 || this.minute != null && this.minute >= 0 && this.minute <= 59;
        boolean bl5 = this.second == null && bl2 || this.second != null && this.second >= 0 && this.second <= 59;
        return (this.hour != null || this.minute != null || this.second != null) && bl3 && bl4 && bl5;
    }

    public boolean isValid(boolean bl) {
        return this.isValid(bl, false);
    }

    public boolean isValid() {
        return this.isValid(true);
    }

    public static enum ComponentType {
        HOUR,
        MINUTE,
        SECOND;

    }
}

