/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval.model;

import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ClauseElement;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.DateModifier;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.DurationAnchor;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.DurationUnit;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.DurationValue;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ModifierType;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.SpanAnchor;

public class SpanModifier
extends DateModifier
implements Comparable<SpanModifier>,
ClauseElement {
    protected final SpanAnchor anchor;
    protected final DurationValue value;

    private static boolean areEqual(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.equals(object2);
    }

    public SpanModifier(SpanAnchor spanAnchor, DurationValue durationValue) {
        this.anchor = spanAnchor;
        this.value = durationValue;
    }

    public SpanModifier(SpanAnchor spanAnchor, DurationUnit durationUnit, Integer n) {
        this.anchor = spanAnchor;
        this.value = new DurationValue(durationUnit, n);
    }

    @Override
    public ModifierType getModifierType() {
        return ModifierType.SPAN;
    }

    public SpanAnchor getSpanAnchor() {
        return this.anchor;
    }

    @Override
    public DurationAnchor getDurationAnchor() {
        return this.getSpanAnchor();
    }

    public DurationValue getDurationValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        SpanModifier spanModifier = (SpanModifier)object;
        return SpanModifier.areEqual(this.anchor, spanModifier.anchor) && SpanModifier.areEqual(this.value, spanModifier.value);
    }

    @Override
    public int compareTo(SpanModifier spanModifier) {
        int n = 0;
        if (this != spanModifier) {
            if (this.anchor != spanModifier.anchor) {
                n = this.anchor == null && spanModifier.anchor != null ? -1 : (this.anchor != null && spanModifier.anchor == null ? 1 : this.anchor.compareTo(spanModifier.anchor));
            }
            if (n == 0 && this.value != spanModifier.value) {
                n = this.value == null && spanModifier.value != null ? -1 : (this.value != null && spanModifier.value == null ? 1 : this.value.compareTo(spanModifier.value));
            }
        }
        return n;
    }

    public int hashCode() {
        int n = 7;
        n = n * 31 + (this.anchor == null ? 0 : this.anchor.hashCode());
        n = n * 31 + (this.value == null ? 0 : this.value.hashCode());
        return n;
    }

    @Override
    public StringBuilder buildClause(StringBuilder stringBuilder) {
        if (this.anchor != null && this.value != null) {
            this.anchor.buildClause(stringBuilder);
            stringBuilder.append(this.getModifierType());
            stringBuilder.append(":");
            this.value.buildClause(stringBuilder);
        }
        return stringBuilder;
    }
}

