/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common;

import java.awt.Color;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;

public class LiveValidationController {
    private ColourPropertyListener colourPropertyListener = new ColourPropertyListener();
    private JComponent m_comp;
    private Color m_compBackgroundColour;
    private Popup m_pup;
    private int m_xOffset = 10;
    private int m_yOffset = 2;

    public LiveValidationController(JComponent jComponent) {
        this.m_comp = jComponent;
        this.m_comp.addPropertyChangeListener(this.colourPropertyListener);
        this.m_compBackgroundColour = jComponent.getBackground();
    }

    public void setXOffset(int n) {
        this.m_xOffset = n;
    }

    public void setyOffset(int n) {
        this.m_yOffset = n;
    }

    public void hidePopup() {
        this.m_comp.removePropertyChangeListener(this.colourPropertyListener);
        this.m_comp.setBackground(this.m_compBackgroundColour);
        this.m_comp.addPropertyChangeListener(this.colourPropertyListener);
        this.m_comp.getAccessibleContext().setAccessibleDescription(null);
        if (this.m_pup != null) {
            this.m_pup.hide();
            this.m_pup = null;
        }
    }

    public void showError(String string) {
        if (string != null && string.length() > 0) {
            Color color = new Color(255, 175, 175);
            this.m_comp.removePropertyChangeListener(this.colourPropertyListener);
            this.m_comp.setBackground(color);
            this.m_comp.addPropertyChangeListener(this.colourPropertyListener);
            try {
                JToolTip jToolTip = new JToolTip();
                jToolTip.setComponent(this.m_comp);
                jToolTip.setTipText(string);
                jToolTip.setVisible(true);
                jToolTip.setBackground(color);
                jToolTip.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
                Point point = this.m_comp.getLocationOnScreen();
                int n = (int)(point.getX() + this.m_comp.getBounds().getWidth()) + this.m_xOffset;
                int n2 = (int)point.getY() + this.m_yOffset;
                if (this.m_pup != null) {
                    this.m_pup.hide();
                }
                this.m_pup = PopupFactory.getSharedInstance().getPopup(this.m_comp, jToolTip, n, n2);
                this.m_comp.getAccessibleContext().setAccessibleDescription(string);
                this.m_pup.show();
            }
            catch (Exception exception) {}
        } else {
            this.hidePopup();
        }
    }

    private class ColourPropertyListener
    implements PropertyChangeListener {
        private ColourPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("background")) {
                LiveValidationController.this.m_compBackgroundColour = (Color)propertyChangeEvent.getNewValue();
            }
        }
    }
}

