/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.editors.graphical.xmlmodel;

import java.sql.Connection;
import java.util.Map;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineAction;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineModel;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineType;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;
import oracle.ide.Ide;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

public class XMLGraphEngineSqlAction
implements GraphEngineAction {
    private GraphEngineType owner;
    private boolean item;
    private boolean reload;
    private boolean delete;
    private boolean allowedWhenReadOnly = false;
    private String actionIDName;
    private String controllerClassName;
    private String id;
    protected String helpId = null;
    protected String confirmMsg = null;
    private String title;
    private String icon;
    private String sql;
    private String templateName;
    private StringTemplate template = null;

    public XMLGraphEngineSqlAction(GraphEngineType graphEngineType) {
        this.owner = graphEngineType;
    }

    @Override
    public GraphEngineModel getModel() {
        return this.owner.getDefinitions().getModel();
    }

    public void setId(String string) {
        this.id = string;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setSql(String string) {
        this.sql = string;
    }

    public String getSql() {
        return this.sql;
    }

    public void setTemplateName(String string) {
        this.templateName = string;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setItem(boolean bl) {
        this.item = bl;
    }

    @Override
    public boolean isItem() {
        return this.item;
    }

    public void setReload(boolean bl) {
        this.reload = bl;
    }

    @Override
    public boolean isReload() {
        return this.reload;
    }

    public void setDelete(boolean bl) {
        this.delete = bl;
    }

    @Override
    public boolean isDelete() {
        return this.delete;
    }

    public void setIcon(String string) {
        this.icon = string;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    public void setActionIDName(String string) {
        this.actionIDName = string;
    }

    public String getActionIDName() {
        return this.actionIDName;
    }

    @Override
    public int getActionID() {
        return Ide.findOrCreateCmdID((String)this.getActionIDName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String execute(Map<String, Object> map) {
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator;
        String string = null;
        String string2 = null;
        GraphEngineModel graphEngineModel = this.owner.getDefinitions().getModel();
        String string3 = graphEngineModel.getConnectionVersionString();
        Connection connection = graphEngineModel.getConnection();
        String string4 = graphEngineModel.getConnectionName();
        if (this.template == null) {
            if (this.getSql() != null) {
                if (this.template == null) {
                    this.template = new StringTemplate(this.getSql(), AngleBracketTemplateLexer.class);
                }
            } else if (this.getTemplateName() != null) {
                dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
                this.template = dBMSSchedulerCodeGenerator.getTemplate(string3, this.getTemplateName());
            }
        }
        if (this.template != null) {
            this.template.reset();
            this.template.setAttributes(map);
            string = this.template.toString();
            if (string3 != null && string3.startsWith("10")) {
                string = string.replaceAll("\r\n", "\n");
            }
        }
        if (string != null) {
            dBMSSchedulerCodeGenerator = DBUtil.getInstance((String)string4);
            if (Connections.getInstance().lock(connection)) {
                try {
                    dBMSSchedulerCodeGenerator.setRaiseError(true);
                    dBMSSchedulerCodeGenerator.execute(string);
                }
                catch (Throwable throwable) {
                    string2 = throwable.getLocalizedMessage();
                }
                finally {
                    Connections.getInstance().unlock(connection);
                }
            }
        }
        return string2;
    }

    public void setControllerClassName(String string) {
        this.controllerClassName = string;
    }

    @Override
    public String getControllerClassName() {
        return this.controllerClassName;
    }

    public void setHelpId(String string) {
        this.helpId = string;
    }

    @Override
    public String getHelpId() {
        return this.helpId;
    }

    public void setConfirmMsg(String string) {
        this.confirmMsg = string;
    }

    @Override
    public String getConfirmMsg() {
        return this.confirmMsg;
    }

    public void setAllowedWhenReadOnly(boolean bl) {
        this.allowedWhenReadOnly = bl;
    }

    @Override
    public boolean isAllowedWhenReadOnly() {
        return this.allowedWhenReadOnly;
    }
}

