/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.editors.graphical.xmlmodel;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineEdge;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineNode;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineNodeType;
import oracle.dbtools.scheduler.editors.graphical.xmlmodel.XMLGraphEngineObject;

public class XMLGraphEngineNode
extends XMLGraphEngineObject
implements GraphEngineNode {
    protected Map<String, GraphEngineNode> childNodes = new HashMap<String, GraphEngineNode>();
    private GraphEngineNodeType nodeType;
    private String connectionSchema;
    private String owner;
    private String name;

    public XMLGraphEngineNode(GraphEngineNode graphEngineNode) {
        super(graphEngineNode);
    }

    @Override
    public Collection<GraphEngineNode> getChildNodes() {
        return Collections.unmodifiableCollection(this.childNodes.values());
    }

    @Override
    public GraphEngineNode getChildNode(String string) {
        return this.getChildNode(string, false);
    }

    @Override
    public GraphEngineNode getChildNode(String string, boolean bl) {
        GraphEngineNode graphEngineNode;
        block1: {
            GraphEngineNode graphEngineNode2;
            graphEngineNode = this.childNodes.get(string);
            if (graphEngineNode != null || !bl) break block1;
            Iterator<GraphEngineNode> iterator = this.childNodes.values().iterator();
            while (iterator.hasNext() && (graphEngineNode = (graphEngineNode2 = iterator.next()).getChildNode(string)) == null) {
            }
        }
        return graphEngineNode;
    }

    @Override
    public boolean add(GraphEngineNode graphEngineNode) {
        boolean bl = false;
        if (!this.childNodes.containsKey(graphEngineNode.getId())) {
            Map<String, GraphEngineNode> map = Collections.unmodifiableMap(this.childNodes);
            this.childNodes.put(graphEngineNode.getId(), graphEngineNode);
            this.propertyChangeSupport.firePropertyChange("nodeAdded", map, graphEngineNode);
            bl = true;
        }
        return bl;
    }

    @Override
    public void remove(GraphEngineNode graphEngineNode) {
        if (this.childNodes.containsKey(graphEngineNode.getId())) {
            Map<String, GraphEngineNode> map = Collections.unmodifiableMap(this.childNodes);
            this.childNodes.remove(graphEngineNode.getId());
            this.propertyChangeSupport.firePropertyChange("nodeRemoved", map, graphEngineNode);
        }
    }

    @Override
    public boolean add(GraphEngineEdge graphEngineEdge) {
        return this.getGraph().add(graphEngineEdge);
    }

    @Override
    public void remove(GraphEngineEdge graphEngineEdge) {
        this.getGraph().remove(graphEngineEdge);
    }

    public void setNodeType(GraphEngineNodeType graphEngineNodeType) {
        GraphEngineNodeType graphEngineNodeType2 = this.nodeType;
        this.nodeType = graphEngineNodeType;
        this.propertyChangeSupport.firePropertyChange("nodeType", graphEngineNodeType2, graphEngineNodeType);
    }

    @Override
    public GraphEngineNodeType getType() {
        return this.nodeType;
    }

    @Override
    public String getConnectionSchema() {
        return this.connectionSchema;
    }

    public void setConnectionSchema(String string) {
        String string2 = this.connectionSchema;
        this.connectionSchema = string;
        this.propertyChangeSupport.firePropertyChange("connectionSchema", string2, string);
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String string) {
        String string2 = this.owner;
        this.owner = string;
        this.propertyChangeSupport.firePropertyChange("owner", string2, string);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        String string2 = this.name;
        this.name = string;
        this.propertyChangeSupport.firePropertyChange("name", string2, string);
    }

    @Override
    protected String createId() {
        return this.getLabel();
    }

    public String toString() {
        return "XMLGraphEngineNode(" + this.getName() + ")";
    }
}

