/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.editors.graphical.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineGraph;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineNode;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineObject;
import oracle.ide.model.Element;
import oracle.ide.model.Node;

public class GraphEngineReferenceModel {
    private Map<Object, GraphEngineObject> jGraphXToLocalMap = new HashMap<Object, GraphEngineObject>();
    private Map<GraphEngineObject, Object> localToJGraphXMap = new HashMap<GraphEngineObject, Object>();
    private Map<Element, List<GraphEngineObject>> elementToLocalMap = new HashMap<Element, List<GraphEngineObject>>();
    private Map<GraphEngineObject, Integer> localReferenceCount = new HashMap<GraphEngineObject, Integer>();
    private Object rootCell;
    private GraphEngineGraph rootGraph;
    private Element editorElement = null;

    public List<GraphEngineObject> add(Element element, List<GraphEngineObject> list) {
        List<GraphEngineObject> list2 = null;
        if (element != null && list != null) {
            list2 = this.remove(element);
            this.elementToLocalMap.put(element, list);
            for (GraphEngineObject graphEngineObject : list) {
                Integer n = this.localReferenceCount.get(graphEngineObject);
                if (n == null) {
                    this.localReferenceCount.put(graphEngineObject, 1);
                } else {
                    this.localReferenceCount.put(graphEngineObject, n + 1);
                }
                list2.remove(graphEngineObject);
            }
        }
        return list2;
    }

    public List<GraphEngineObject> remove(Element element) {
        List<GraphEngineObject> list;
        Vector<GraphEngineObject> vector = new Vector<GraphEngineObject>();
        if (element != null && (list = this.elementToLocalMap.remove(element)) != null) {
            for (GraphEngineObject graphEngineObject : list) {
                Integer n = this.localReferenceCount.get(graphEngineObject);
                if (n == null) continue;
                if (n == 1) {
                    this.localReferenceCount.remove(graphEngineObject);
                    vector.add(graphEngineObject);
                    continue;
                }
                this.localReferenceCount.put(graphEngineObject, n - 1);
            }
        }
        return vector;
    }

    public int getElementCount() {
        return this.elementToLocalMap.keySet().size();
    }

    public List<GraphEngineObject> getReferencedLocals(Element element) {
        return this.elementToLocalMap.get(element);
    }

    public int getLocalReferenceCount(GraphEngineObject graphEngineObject) {
        Integer n = null;
        if (graphEngineObject != null) {
            n = this.localReferenceCount.get(graphEngineObject);
        }
        if (n == null) {
            return 0;
        }
        return n;
    }

    public void printElementToLocalMap() {
        System.out.println("ElementToLocalMap has " + this.elementToLocalMap.size() + " entries");
        int n = 0;
        for (Element object : this.elementToLocalMap.keySet()) {
            List<GraphEngineObject> list = this.elementToLocalMap.get(object);
            System.out.println(n++ + "\t" + object.getShortLabel() + "(" + object.getClass().getSimpleName() + ") - " + list.size() + " entries");
            int n2 = 0;
            for (GraphEngineObject graphEngineObject : list) {
                Element element = graphEngineObject.getElement();
                System.out.println("\t" + n2++ + "\t " + (graphEngineObject instanceof GraphEngineNode ? "Node " : "Edge ") + graphEngineObject.getId() + "(" + (element == null ? "null" : element.getClass().getSimpleName() + "-" + (element instanceof Node ? ((Node)element).getURL().toExternalForm() : element.getLongLabel())) + ", " + this.getLocalReferenceCount(graphEngineObject) + ")");
            }
        }
        int n3 = 0;
        System.out.println("\tAssociations " + this.localToJGraphXMap.size() + " entries");
        try {
            for (GraphEngineObject graphEngineObject : this.localToJGraphXMap.keySet()) {
                try {
                    System.out.println("\t" + n3++ + "\t " + (graphEngineObject instanceof GraphEngineNode ? (graphEngineObject instanceof GraphEngineGraph ? "Graph " : "Node ") : "Edge ") + graphEngineObject.getId() + "(" + this.getLocalReferenceCount(graphEngineObject) + ")");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void clear() {
        this.jGraphXToLocalMap.clear();
        this.localToJGraphXMap.clear();
        this.elementToLocalMap.clear();
        this.localReferenceCount.clear();
        this.associate(this.rootCell, this.rootGraph);
    }

    public void associate(Object object, GraphEngineObject graphEngineObject) {
        if (object == null || graphEngineObject == null) {
            return;
        }
        this.jGraphXToLocalMap.put(object, graphEngineObject);
        this.localToJGraphXMap.put(graphEngineObject, object);
        if (graphEngineObject instanceof GraphEngineGraph && object != null) {
            this.rootCell = object;
            this.rootGraph = (GraphEngineGraph)graphEngineObject;
        }
    }

    public GraphEngineObject getJGraphXToLocalMap(Object object) {
        return this.jGraphXToLocalMap.get(object);
    }

    public Object getLocalToJGraphXMap(GraphEngineObject graphEngineObject) {
        return this.localToJGraphXMap.get(graphEngineObject);
    }

    public void removeAssociation(Object object) {
        if (object != null) {
            this.removeAssociation(object, this.jGraphXToLocalMap.get(object));
        }
    }

    public void removeAssociation(GraphEngineObject graphEngineObject) {
        if (graphEngineObject != null) {
            this.removeAssociation(this.localToJGraphXMap.get(graphEngineObject), graphEngineObject);
        }
    }

    public void removeAssociation(Object object, GraphEngineObject graphEngineObject) {
        if (graphEngineObject != null) {
            this.localToJGraphXMap.remove(graphEngineObject);
        }
        if (object != null) {
            this.jGraphXToLocalMap.remove(object);
        }
    }

    public Set<GraphEngineObject> getLocals() {
        return this.localToJGraphXMap.keySet();
    }

    public Element getEditorElement() {
        return this.editorElement;
    }

    public void setEditorElement(Element element) {
        this.editorElement = element;
    }

    public List<Element> getElements() {
        return new Vector<Element>(this.elementToLocalMap.keySet());
    }
}

