/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.editors.chain;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.controls.IActionUpdater;
import oracle.dbtools.raptor.controls.grid.EditableResultSetTable;
import oracle.dbtools.raptor.controls.grid.RaptorEditableGridTaskWrapper;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.ide.Context;
import oracle.ide.IdeMainWindow;
import oracle.ide.controls.Toolbar;

public class ChainEditorDialog
extends JEWTDialog {
    private JSplitPane splitPane;
    private EditableResultSetTable stepTable;
    private JScrollPane stepTableScroll;
    private EditableResultSetTable ruleTable;
    private JScrollPane ruleTableScroll;
    private String STEP_QUERY = "select \"STEP_NAME\", \"PROGRAM_NAME\", \"EVENT_SCHEDULE_NAME\", \"STEP_TYPE\", \"OWNER\", \"CHAIN_NAME\",  \"PROGRAM_OWNER\", \"SKIP\", \"PAUSE\" ,\"RESTART_ON_FAILURE\" from \"SYS\".\"ALL_SCHEDULER_CHAIN_STEPS\" where \"CHAIN_NAME\" = ";
    private String RULE_QUERY = "select OWNER,CHAIN_NAME,RULE_OWNER,RULE_NAME,CONDITION,ACTION,COMMENTS  from sys.all_scheduler_chain_rules where CHAIN_NAME = ";
    private DBObject dbObj;

    public ChainEditorDialog(IdeMainWindow ideMainWindow, Context context) {
        super((Frame)ideMainWindow, "Edit Chain");
        this.dbObj = ((ViewerNode)context.getNode()).getDBObject();
        String string = ((ViewerNode)context.getNode()).getDBObject().getConnectionName();
        this.stepTable = new EditableResultSetTable(new IActionUpdater(){

            public void updateActions() {
                ChainEditorDialog.this.stepTable.getController().getCommitAction().setEnabled(ChainEditorDialog.this.stepTable.isChanged());
                ChainEditorDialog.this.stepTable.getController().getRollbackAction().setEnabled(ChainEditorDialog.this.stepTable.isChanged());
            }
        });
        this.stepTable.setInsertAllowed(true);
        this.stepTable.setDeleteAllowed(true);
        this.stepTable.setEditable(true);
        this.stepTable.setRefreshAllowed(true);
        this.stepTable.getController().addToolBarActions(new Toolbar());
        this.stepTable.setQuery(string, this.createSqlForStep(), null, null);
        try {
            this.stepTable.open(new RaptorEditableGridTaskWrapper("Chain Step Table", IRaptorTaskRunMode.IDE_STATUSBAR, false, null, null, null, null));
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        this.stepTableScroll = new JScrollPane((Component)this.stepTable);
        this.ruleTable = new EditableResultSetTable(new IActionUpdater(){

            public void updateActions() {
                ChainEditorDialog.this.ruleTable.getController().getCommitAction().setEnabled(ChainEditorDialog.this.ruleTable.isChanged());
                ChainEditorDialog.this.ruleTable.getController().getRollbackAction().setEnabled(ChainEditorDialog.this.ruleTable.isChanged());
            }
        });
        this.ruleTable.setInsertAllowed(true);
        this.ruleTable.setDeleteAllowed(true);
        this.ruleTable.setEditable(true);
        this.ruleTable.setRefreshAllowed(true);
        this.ruleTable.getController().addToolBarActions(new Toolbar());
        this.ruleTable.setQuery(string, this.createSqlForRule(), null, null);
        try {
            this.ruleTable.open(new RaptorEditableGridTaskWrapper("Chain Step Table", IRaptorTaskRunMode.IDE_STATUSBAR, false, null, null, null, null));
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        this.ruleTableScroll = new JScrollPane((Component)this.ruleTable);
        this.splitPane = new JSplitPane(0, this.stepTableScroll, this.ruleTableScroll);
        this.splitPane.setDividerLocation(320);
        this.setContent(this.splitPane);
        URL uRL = ChainEditorDialog.class.getResource(SchedulerArb.getString("PROGRAMUPDATEDIALOG_PRODUCT_ICON"));
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(uRL));
        this.setButtonMask(7);
        this.setPreferredSize(800, 640);
    }

    private String createSqlForRule() {
        return this.RULE_QUERY + "'" + this.dbObj.getObjectName().toUpperCase() + "'";
    }

    private String createSqlForStep() {
        return this.STEP_QUERY + "'" + this.dbObj.getObjectName().toUpperCase() + "'";
    }
}

