/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.dialogs.newjob;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import oracle.dbtools.raptor.datatypes.objects.OraINTERVALDS;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialogTab;
import oracle.dbtools.raptor.ui.controls.ButtonActionControl;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.IntervalActionControl;
import oracle.dbtools.raptor.ui.controls.ListActionControl;
import oracle.dbtools.raptor.ui.controls.OptionalActionControl;
import oracle.dbtools.raptor.ui.controls.SideBySideActionControl;
import oracle.dbtools.raptor.ui.controls.SpinnerActionControl;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.dialogs.newjob.NewJobModel;

public class NewJobCreateActionDialogTab_AdvancedProperties
extends ActionDialogTab {
    private NewJobModel model;
    private ActionControl autoDropCtl = null;
    private ActionControl restartableCtl = null;
    private ActionControl stopOnWindowCloseCtl = null;
    private ActionControl followDefaultTimeZoneCtl = null;
    private ActionControl parallelInstancesCtl = null;
    private ActionControl jobStyleCtl = null;
    private ActionControl jobPriorityCtl = null;
    private ActionControl jobWeightCtl = null;
    private ActionControl loggingLevelCtl = null;
    private ActionControl maxFailuresCtl = null;
    private ActionControl maxRunsCtl = null;
    private ActionControl storeOutputCtl = null;
    private ActionControl instanceIdCtl = null;
    private ListActionControl raiseEventsCtl = null;
    private ActionControl maxRunDurationIntervalActionCtl = null;
    private ActionControl scheduleLimitActionCtl = null;
    private ActionControl resetToDefaultsCtl = null;
    private ActionControl optionalMaxFailuresCtl = null;
    private ActionControl optionalInstanceIdCtl = null;
    private OptionalActionControl optionalMaxRunsCtl = null;
    private OptionalActionControl optionalMaxRunDurationCtl = null;
    private OptionalActionControl optionalScheduleLimitCtl = null;
    private String autoDropValue = "FALSE";
    private String restartableValue = "FALSE";
    private String stopOnWindowCloseValue = "FALSE";
    private String followDefaultTimeZoneValue = "FALSE";
    private String parallelInstancesValue = "FALSE";
    private String jobStyleValue = "REGULAR";
    private String jobWeightValue = "1";
    private String jobPriorityValue = "3";
    private String instanceIdValue = null;
    private String maxRunsValue = null;
    private String storeOutputValue = "TRUE";
    private OraINTERVALDS maxRunDurationValue = null;
    private OraINTERVALDS scheduleLimitValue = null;
    private String maxFailuresValue = null;
    private String[] raiseEventValue = new String[0];
    private String loggingLevelValue = "DBMS_SCHEDULER.LOGGING_OFF";

    public NewJobCreateActionDialogTab_AdvancedProperties(String string, String string2, NewJobModel newJobModel) {
        super(string, string2);
        this.model = newJobModel;
        if (this.model != null && newJobModel.getOperation() != NewJobModel.Operation.CREATE_NEW) {
            this.autoDropValue = (String)newJobModel.getPreviousJobData("oldAutoDrop");
            this.restartableValue = (String)newJobModel.getPreviousJobData("oldRestartable");
            this.stopOnWindowCloseValue = (String)newJobModel.getPreviousJobData("oldStopOnWindowClose");
            this.followDefaultTimeZoneValue = (String)newJobModel.getPreviousJobData("oldFollowDefaultTimeZone");
            this.parallelInstancesValue = (String)newJobModel.getPreviousJobData("oldParallelInstances");
            this.jobStyleValue = (String)newJobModel.getPreviousJobData("oldJobStyle");
            this.jobWeightValue = (String)newJobModel.getPreviousJobData("oldJobWeight");
            this.jobPriorityValue = (String)newJobModel.getPreviousJobData("oldJobPriority");
            this.instanceIdValue = (String)newJobModel.getPreviousJobData("oldInstanceId");
            this.storeOutputValue = (String)newJobModel.getPreviousJobData("oldStoreOutput");
            this.maxRunsValue = (String)newJobModel.getPreviousJobData("oldMaxRuns");
            this.maxFailuresValue = (String)newJobModel.getPreviousJobData("oldMaxFailures");
            this.maxRunDurationValue = (OraINTERVALDS)newJobModel.getPreviousJobData("oldMaxRunDuration");
            this.scheduleLimitValue = (OraINTERVALDS)newJobModel.getPreviousJobData("oldScheduleLimit");
            this.raiseEventValue = newJobModel.getRaisedEventsPreviousJobDataEnums();
            this.loggingLevelValue = newJobModel.getLoggingLevelPreviousJobData();
        }
    }

    public List<ActionControl> createControls(Connection connection) {
        this.autoDropCtl = new ComboBoxActionControl("AUTO_DROP", SchedulerArb.getString("JOB_CREATE_PROPERTIES_AUTODROP_LABEL"), new String[]{"TRUE", "FALSE"}, this.autoDropValue);
        this.restartableCtl = new ComboBoxActionControl("RESTARTABLE", SchedulerArb.getString("JOB_CREATE_PROPERTIES_RESTARTABLE_LABEL"), new String[]{"TRUE", "FALSE"}, this.restartableValue);
        this.stopOnWindowCloseCtl = new ComboBoxActionControl("STOP_ON_WINDOW_CLOSE", SchedulerArb.getString("JOB_CREATE_PROPERTIES_STOP_ON_WINDOW_CLOSE_LABEL"), new String[]{"TRUE", "FALSE"}, this.stopOnWindowCloseValue);
        if (this.model.FeatureMin111()) {
            this.followDefaultTimeZoneCtl = new ComboBoxActionControl("FOLLOW_DEFAULT_TIME_ZONE", SchedulerArb.getString("JOB_CREATE_PROPERTIES_FOLLOW_DEFAULT_TIME_ZONE_LABEL"), new String[]{"TRUE", "FALSE"}, this.followDefaultTimeZoneValue);
            this.parallelInstancesCtl = new ComboBoxActionControl("PARALLEL_INSTANCES", SchedulerArb.getString("JOB_CREATE_PROPERTIES_PARALLEL_INSTANCES_LABEL"), new String[]{"TRUE", "FALSE"}, this.parallelInstancesValue);
        }
        this.jobStyleCtl = this.model.FeatureMin111() ? new ComboBoxActionControl("JOB_STYLE", SchedulerArb.getString("JOB_CREATE_PROPERTIES_JOB_STYLE_LABEL"), new String[]{"REGULAR", "LIGHTWEIGHT"}, this.jobStyleValue) : new ComboBoxActionControl("JOB_STYLE", SchedulerArb.getString("JOB_CREATE_PROPERTIES_JOB_STYLE_LABEL"), new String[]{"REGULAR"}, this.jobStyleValue);
        this.jobPriorityCtl = new ComboBoxActionControl("JOB_PRIORITY", SchedulerArb.getString("JOB_CREATE_PROPERTIES_JOB_PRIORITY_LABEL"), new String[]{"1", "2", "3", "4", "5"}, this.jobPriorityValue);
        if (!this.model.FeatureMin112()) {
            this.jobWeightCtl = new SpinnerActionControl("JOB_WEIGHT", SchedulerArb.getString("JOB_CREATE_PROPERTIES_JOB_WEIGHT_LABEL"), Integer.valueOf(new Integer(this.jobWeightValue)), Integer.valueOf(1), Integer.valueOf(100), Integer.valueOf(1));
        }
        this.loggingLevelCtl = this.model.FeatureMin111() ? new ComboBoxActionControl("LOGGING_LEVEL", SchedulerArb.getString("JOB_CREATE_PROPERTIES_LOGGING_LEVEL_LABEL"), NewJobModel.LOGGING_LEVEL_LIST, this.loggingLevelValue) : new ComboBoxActionControl("LOGGING_LEVEL", SchedulerArb.getString("JOB_CREATE_PROPERTIES_LOGGING_LEVEL_LABEL"), NewJobModel.LOGGING_LEVEL_LIST_MIN, this.loggingLevelValue);
        if (this.model.FeatureMin121()) {
            this.storeOutputCtl = new ComboBoxActionControl("STORE_OUTPUT", SchedulerArb.getString("JOB_CREATE_PROPERTIES_STORE_OUTPUT_LABEL"), new String[]{"TRUE", "FALSE"}, this.storeOutputValue);
        }
        if (this.maxRunsValue == null) {
            this.maxRunsCtl = new SpinnerActionControl("MAX_RUNS", SchedulerArb.getString("JOB_CREATE_PROPERTIES_MAX_RUNS_LABEL"), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(100000), Integer.valueOf(1));
            this.optionalMaxRunsCtl = new OptionalActionControl(false, this.maxRunsCtl);
        } else {
            this.maxRunsCtl = new SpinnerActionControl("MAX_RUNS", SchedulerArb.getString("JOB_CREATE_PROPERTIES_MAX_RUNS_LABEL"), Integer.valueOf(this.maxRunsValue == null ? 0 : Integer.parseInt(this.maxRunsValue)), Integer.valueOf(1), Integer.valueOf(100000), Integer.valueOf(1));
            this.optionalMaxRunsCtl = new OptionalActionControl(true, this.maxRunsCtl);
        }
        if (this.maxFailuresValue == null) {
            this.maxFailuresCtl = new SpinnerActionControl("MAX_FAILURES", SchedulerArb.getString("JOB_CREATE_PROPERTIES_MAX_FAILURES_LABEL"), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(100000), Integer.valueOf(1));
            this.optionalMaxFailuresCtl = new OptionalActionControl(false, this.maxFailuresCtl);
        } else {
            this.maxFailuresCtl = new SpinnerActionControl("MAX_FAILURES", SchedulerArb.getString("JOB_CREATE_PROPERTIES_MAX_FAILURES_LABEL"), Integer.valueOf(this.maxFailuresValue == null ? 0 : Integer.parseInt(this.maxFailuresValue)), Integer.valueOf(1), Integer.valueOf(100000), Integer.valueOf(1));
            this.optionalMaxFailuresCtl = new OptionalActionControl(true, this.maxFailuresCtl);
        }
        if (this.model.FeatureMin111()) {
            if (this.instanceIdValue == null) {
                this.instanceIdCtl = new SpinnerActionControl("INSTANCE_ID", SchedulerArb.getString("JOB_CREATE_PROPERTIES_INSTANCE_ID_LABEL"), Integer.valueOf(1), Integer.valueOf(1), null, Integer.valueOf(1));
                this.optionalInstanceIdCtl = new OptionalActionControl(false, this.instanceIdCtl);
            } else {
                this.instanceIdCtl = new SpinnerActionControl("INSTANCE_ID", SchedulerArb.getString("JOB_CREATE_PROPERTIES_INSTANCE_ID_LABEL"), Integer.valueOf(new Integer(this.instanceIdValue)), Integer.valueOf(1), null, Integer.valueOf(1));
                this.optionalInstanceIdCtl = new OptionalActionControl(true, this.instanceIdCtl);
            }
        }
        if (this.model.FeatureMin102()) {
            this.raiseEventsCtl = new ListActionControl("RAISE_EVENTS", SchedulerArb.getString("JOB_CREATE_PROPERTIES_RAISE_EVENTS_LABEL"), NewJobModel.JOBRAISEEVENT_LIST, this.raiseEventValue);
        }
        this.maxRunDurationIntervalActionCtl = new IntervalActionControl("MAX_RUN_DURATION", SchedulerArb.getString("JOB_CREATE_PROPERTIES_MAX_RUN_DURATION_LABEL"), this.maxRunDurationValue, true, false);
        this.optionalMaxRunDurationCtl = this.maxRunDurationValue != null ? new OptionalActionControl(true, this.maxRunDurationIntervalActionCtl) : new OptionalActionControl(false, this.maxRunDurationIntervalActionCtl);
        this.scheduleLimitActionCtl = new IntervalActionControl("SCHEDULE_LIMIT", SchedulerArb.getString("JOB_CREATE_PROPERTIES_SCHEDULE_LIMIT_LABEL"), this.scheduleLimitValue, true, false);
        this.optionalScheduleLimitCtl = this.scheduleLimitValue != null ? new OptionalActionControl(true, this.scheduleLimitActionCtl) : new OptionalActionControl(false, this.scheduleLimitActionCtl);
        this.resetToDefaultsCtl = new ButtonActionControl("RESET_TO_DEFAULTS", null, SchedulerArb.getString("JOB_CREATE_PROPERTIES_RESET_TO_DEFAULTS_LABEL"));
        ((JButton)this.resetToDefaultsCtl.getUI()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewJobCreateActionDialogTab_AdvancedProperties.this.resetToDefaults();
            }
        });
        SideBySideActionControl sideBySideActionControl = new SideBySideActionControl(null, null, this.resetToDefaultsCtl, null, 2);
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add(this.autoDropCtl);
        arrayList.add(this.restartableCtl);
        arrayList.add(this.stopOnWindowCloseCtl);
        if (this.model.FeatureMin111()) {
            arrayList.add(this.followDefaultTimeZoneCtl);
            arrayList.add(this.parallelInstancesCtl);
        }
        arrayList.add(this.jobStyleCtl);
        arrayList.add(this.jobPriorityCtl);
        if (!this.model.FeatureMin112()) {
            arrayList.add(this.jobWeightCtl);
        }
        arrayList.add(this.loggingLevelCtl);
        arrayList.add((ActionControl)this.optionalMaxRunsCtl);
        arrayList.add(this.optionalMaxFailuresCtl);
        if (this.model.FeatureMin111()) {
            arrayList.add(this.optionalInstanceIdCtl);
        }
        if (this.model.FeatureMin102()) {
            arrayList.add((ActionControl)this.raiseEventsCtl);
        }
        arrayList.add((ActionControl)this.optionalMaxRunDurationCtl);
        arrayList.add((ActionControl)this.optionalScheduleLimitCtl);
        if (this.model.FeatureMin121()) {
            arrayList.add(this.storeOutputCtl);
        }
        arrayList.add((ActionControl)sideBySideActionControl);
        return arrayList;
    }

    private void resetToDefaults() {
        ((ComboBoxActionControl)this.autoDropCtl).set("FALSE");
        ((ComboBoxActionControl)this.restartableCtl).set("FALSE");
        ((ComboBoxActionControl)this.stopOnWindowCloseCtl).set("FALSE");
        ((ComboBoxActionControl)this.jobStyleCtl).set("REGULAR");
        ((ComboBoxActionControl)this.jobPriorityCtl).set("3");
        if (!this.model.FeatureMin112()) {
            ((SpinnerActionControl)this.jobWeightCtl).set(Integer.valueOf(1));
        }
        ((ComboBoxActionControl)this.loggingLevelCtl).set(NewJobModel.LOGGING_LEVEL_LIST[0]);
        this.optionalMaxRunsCtl.set(false);
        ((OptionalActionControl)this.optionalMaxFailuresCtl).set(false);
        this.optionalScheduleLimitCtl.set(false);
        this.optionalMaxRunDurationCtl.set(false);
        if (this.model.FeatureMin111()) {
            this.raiseEventsCtl.reset(new String[0]);
        }
        if (this.model.FeatureMin102()) {
            ((OptionalActionControl)this.optionalInstanceIdCtl).set(false);
            ((ComboBoxActionControl)this.followDefaultTimeZoneCtl).set("FALSE");
            ((ComboBoxActionControl)this.parallelInstancesCtl).set("FALSE");
        }
        if (this.model.FeatureMin121()) {
            ((ComboBoxActionControl)this.storeOutputCtl).set("TRUE");
        }
    }

    public void initialize(Connection connection) {
        super.initialize(connection);
    }
}

