/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.controls.celleditor.drilllinks.DrillLinkRegistry;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.raptor.report.addin.ReportAddin;
import oracle.dbtools.raptor.utils.FileUtils;
import oracle.dbtools.scheduler.dbobjects.SCHChain;
import oracle.dbtools.scheduler.dbobjects.SCHChainBuilder;
import oracle.dbtools.scheduler.dbobjects.SCHChainLister;
import oracle.dbtools.scheduler.dbobjects.SCHChainValidator;
import oracle.dbtools.scheduler.dbobjects.SCHCredential;
import oracle.dbtools.scheduler.dbobjects.SCHCredentialBuilder;
import oracle.dbtools.scheduler.dbobjects.SCHCredentialLister;
import oracle.dbtools.scheduler.dbobjects.SCHCredentialValidator;
import oracle.dbtools.scheduler.dbobjects.SCHDBDestGroup;
import oracle.dbtools.scheduler.dbobjects.SCHDBDestGroupBuilder;
import oracle.dbtools.scheduler.dbobjects.SCHDBDestGroupLister;
import oracle.dbtools.scheduler.dbobjects.SCHDBDestGroupValidator;
import oracle.dbtools.scheduler.dbobjects.SCHDBDestination;
import oracle.dbtools.scheduler.dbobjects.SCHDBDestinationBuilder;
import oracle.dbtools.scheduler.dbobjects.SCHDBDestinationLister;
import oracle.dbtools.scheduler.dbobjects.SCHDBDestinationValidator;
import oracle.dbtools.scheduler.dbobjects.SCHDDLGenerator;
import oracle.dbtools.scheduler.dbobjects.SCHExDestGroup;
import oracle.dbtools.scheduler.dbobjects.SCHExDestGroupBuilder;
import oracle.dbtools.scheduler.dbobjects.SCHExDestGroupLister;
import oracle.dbtools.scheduler.dbobjects.SCHExDestGroupValidator;
import oracle.dbtools.scheduler.dbobjects.SCHExDestination;
import oracle.dbtools.scheduler.dbobjects.SCHExDestinationBuilder;
import oracle.dbtools.scheduler.dbobjects.SCHExDestinationLister;
import oracle.dbtools.scheduler.dbobjects.SCHExDestinationValidator;
import oracle.dbtools.scheduler.dbobjects.SCHFileWatcher;
import oracle.dbtools.scheduler.dbobjects.SCHFileWatcherBuilder;
import oracle.dbtools.scheduler.dbobjects.SCHFileWatcherLister;
import oracle.dbtools.scheduler.dbobjects.SCHFileWatcherValidator;
import oracle.dbtools.scheduler.dbobjects.SCHJobClass;
import oracle.dbtools.scheduler.dbobjects.SCHJobClassBuilder;
import oracle.dbtools.scheduler.dbobjects.SCHJobClassLister;
import oracle.dbtools.scheduler.dbobjects.SCHJobClassValidator;
import oracle.dbtools.scheduler.dbobjects.SCHNewJob;
import oracle.dbtools.scheduler.dbobjects.SCHNewJobBuilder;
import oracle.dbtools.scheduler.dbobjects.SCHNewJobLister;
import oracle.dbtools.scheduler.dbobjects.SCHNewJobValidator;
import oracle.dbtools.scheduler.dbobjects.SCHProgram;
import oracle.dbtools.scheduler.dbobjects.SCHProgramBuilder;
import oracle.dbtools.scheduler.dbobjects.SCHProgramLister;
import oracle.dbtools.scheduler.dbobjects.SCHProgramValidator;
import oracle.dbtools.scheduler.dbobjects.SCHSchedule;
import oracle.dbtools.scheduler.dbobjects.SCHScheduleBuilder;
import oracle.dbtools.scheduler.dbobjects.SCHScheduleLister;
import oracle.dbtools.scheduler.dbobjects.SCHScheduleValidator;
import oracle.dbtools.scheduler.dbobjects.SCHWindow;
import oracle.dbtools.scheduler.dbobjects.SCHWindowBuilder;
import oracle.dbtools.scheduler.dbobjects.SCHWindowGroup;
import oracle.dbtools.scheduler.dbobjects.SCHWindowGroupBuilder;
import oracle.dbtools.scheduler.dbobjects.SCHWindowGroupLister;
import oracle.dbtools.scheduler.dbobjects.SCHWindowGroupValidator;
import oracle.dbtools.scheduler.dbobjects.SCHWindowLister;
import oracle.dbtools.scheduler.dbobjects.SCHWindowValidator;
import oracle.dbtools.scheduler.editors.chain.ChainEditorAddin;
import oracle.dbtools.scheduler.editors.graphical.GraphicalEditorAddin;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineModel;
import oracle.dbtools.scheduler.editors.graphical.xmlmodel.GraphEngineXML;
import oracle.dbtools.scheduler.editors.graphical.xmlmodel.XMLGraphEngineModel;
import oracle.dbtools.scheduler.oviewer.SchedulerDBANavDrillLink;
import oracle.dbtools.scheduler.oviewer.SchedulerDrillLink;
import oracle.dbtools.scheduler.reportactions.SchedulerReportAction;
import oracle.ide.Addin;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.javatools.db.extension.DBObjectRegistry;
import oracle.javatools.db.extension.DatabaseMatcher;
import org.w3c.dom.Document;

public class SchedulerAddin
implements Addin {
    private static Map<String, Document> editors = new HashMap<String, Document>();
    private static boolean editorsRegistered = false;
    private static GraphEngineXML geXMLProcessor = new GraphEngineXML();

    public void initialize() {
        SchedulerAddin.registerDBObjects();
        this.initialiseEditors();
        this.initialiseReports();
    }

    private void initialiseReports() {
        ReportAddin.registerReportPackage((String)"oracle/dbtools/scheduler/reports", (ClassLoader)SchedulerAddin.class.getClassLoader());
        ResultSetTable.addGridContextMenu((GridContextMenuItem)SchedulerReportAction.getInstance());
    }

    private void initialiseEditors() {
        try {
            EditorManager editorManager = EditorManager.getEditorManager();
            editorManager.registerDynamic((EditorAddin)new GraphicalEditorAddin());
            editorManager.registerDynamic((EditorAddin)new ChainEditorAddin());
            DrillLinkRegistry.getInstance().registerDrillLink(SchedulerDBANavDrillLink.class);
            DrillLinkRegistry.getInstance().registerDrillLink(SchedulerDrillLink.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void registerGraphEditors() {
        if (!editorsRegistered) {
            editorsRegistered = true;
            try {
                URLFileSystemHelper uRLFileSystemHelper = URLFileSystem.findHelper((String)"ide.scheduler");
                if (uRLFileSystemHelper == null) {
                    uRLFileSystemHelper = URLFileSystem.findHelper((String)"ide.text");
                }
                URLFileSystem.registerHelper((String)"ide.scheduler", (URLFileSystemHelper)uRLFileSystemHelper);
                String string = "oracle.dbtools.scheduler.editors.graphical.xml";
                List list = FileUtils.getFilesInPackage((String)string, (ClassLoader)SchedulerAddin.class.getClassLoader(), (String)".xml");
                for (URL uRL : list) {
                    try {
                        String string2 = geXMLProcessor.getModelName(uRL);
                        editors.put(string2, geXMLProcessor.getDocument());
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static GraphEngineModel getGraphEngineModel(String string) {
        GraphEngineModel graphEngineModel;
        Document document = editors.get(string);
        try {
            graphEngineModel = geXMLProcessor.processDocument(document);
        }
        catch (Exception exception) {
            graphEngineModel = new XMLGraphEngineModel();
        }
        return graphEngineModel;
    }

    public static void registerDBObjects() {
        DatabaseMatcher databaseMatcher = new DatabaseMatcher("Oracle Database", 100, DatabaseMatcher.Comparison.MINIMUM);
        DBObjectRegistry.getInstance().registerClass(SCHChain.TYPE, SCHChain.class);
        DBObjectRegistry.getInstance().registerObject(SCHChain.TYPE, databaseMatcher, SCHChainValidator.class, SCHChainBuilder.class, SCHChainLister.class, SCHDDLGenerator.class);
        DBObjectRegistry.getInstance().registerClass(SCHCredential.TYPE, SCHCredential.class);
        DBObjectRegistry.getInstance().registerObject(SCHCredential.TYPE, databaseMatcher, SCHCredentialValidator.class, SCHCredentialBuilder.class, SCHCredentialLister.class, SCHDDLGenerator.class);
        DBObjectRegistry.getInstance().registerClass(SCHDBDestGroup.TYPE, SCHDBDestGroup.class);
        DBObjectRegistry.getInstance().registerObject(SCHDBDestGroup.TYPE, databaseMatcher, SCHDBDestGroupValidator.class, SCHDBDestGroupBuilder.class, SCHDBDestGroupLister.class, SCHDDLGenerator.class);
        DBObjectRegistry.getInstance().registerClass(SCHDBDestination.TYPE, SCHDBDestination.class);
        DBObjectRegistry.getInstance().registerObject(SCHDBDestination.TYPE, databaseMatcher, SCHDBDestinationValidator.class, SCHDBDestinationBuilder.class, SCHDBDestinationLister.class, SCHDDLGenerator.class);
        DBObjectRegistry.getInstance().registerClass(SCHExDestGroup.TYPE, SCHExDestGroup.class);
        DBObjectRegistry.getInstance().registerObject(SCHExDestGroup.TYPE, databaseMatcher, SCHExDestGroupValidator.class, SCHExDestGroupBuilder.class, SCHExDestGroupLister.class, SCHDDLGenerator.class);
        DBObjectRegistry.getInstance().registerClass(SCHExDestination.TYPE, SCHExDestination.class);
        DBObjectRegistry.getInstance().registerObject(SCHExDestination.TYPE, databaseMatcher, SCHExDestinationValidator.class, SCHExDestinationBuilder.class, SCHExDestinationLister.class, SCHDDLGenerator.class);
        DBObjectRegistry.getInstance().registerClass(SCHFileWatcher.TYPE, SCHFileWatcher.class);
        DBObjectRegistry.getInstance().registerObject(SCHFileWatcher.TYPE, databaseMatcher, SCHFileWatcherValidator.class, SCHFileWatcherBuilder.class, SCHFileWatcherLister.class, SCHDDLGenerator.class);
        DBObjectRegistry.getInstance().registerClass(SCHJobClass.TYPE, SCHJobClass.class);
        DBObjectRegistry.getInstance().registerObject(SCHJobClass.TYPE, databaseMatcher, SCHJobClassValidator.class, SCHJobClassBuilder.class, SCHJobClassLister.class, SCHDDLGenerator.class);
        DBObjectRegistry.getInstance().registerClass(SCHNewJob.TYPE, SCHNewJob.class);
        DBObjectRegistry.getInstance().registerObject(SCHNewJob.TYPE, databaseMatcher, SCHNewJobValidator.class, SCHNewJobBuilder.class, SCHNewJobLister.class, SCHDDLGenerator.class);
        DBObjectRegistry.getInstance().registerClass(SCHProgram.TYPE, SCHProgram.class);
        DBObjectRegistry.getInstance().registerObject(SCHProgram.TYPE, databaseMatcher, SCHProgramValidator.class, SCHProgramBuilder.class, SCHProgramLister.class, SCHDDLGenerator.class);
        DBObjectRegistry.getInstance().registerClass(SCHSchedule.TYPE, SCHSchedule.class);
        DBObjectRegistry.getInstance().registerObject(SCHSchedule.TYPE, databaseMatcher, SCHScheduleValidator.class, SCHScheduleBuilder.class, SCHScheduleLister.class, SCHDDLGenerator.class);
        DBObjectRegistry.getInstance().registerClass(SCHWindow.TYPE, SCHWindow.class);
        DBObjectRegistry.getInstance().registerObject(SCHWindow.TYPE, databaseMatcher, SCHWindowValidator.class, SCHWindowBuilder.class, SCHWindowLister.class, SCHDDLGenerator.class);
        DBObjectRegistry.getInstance().registerClass(SCHWindowGroup.TYPE, SCHWindowGroup.class);
        DBObjectRegistry.getInstance().registerObject(SCHWindowGroup.TYPE, databaseMatcher, SCHWindowGroupValidator.class, SCHWindowGroupBuilder.class, SCHWindowGroupLister.class, SCHDDLGenerator.class);
    }

    static {
        SchedulerAddin.registerGraphEditors();
    }
}

