/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.translation.api.components;

import antlr.collections.AST;
import java.util.Hashtable;
import oracle.dbtools.migration.translation.api.components.Block;
import oracle.dbtools.migration.translation.api.components.SQLStatement;

public class Trigger {
    public static final String TRIGGER_EVENT_DELETE = "DELETE";
    public static final String TRIGGER_EVENT_INSERT = "INSERT";
    public static final String TRIGGER_EVENT_UPDATE = "UPDATE";
    private Hashtable<String, SQLStatement> m_dmlMap;
    private AST m_tree;
    private String m_targetObjectName;
    private String m_triggerEvents;
    private Block m_objectBlock;

    public Trigger(AST aST, Block block) {
        this.m_tree = aST;
        this.m_dmlMap = new Hashtable();
        this.m_triggerEvents = "";
        this.m_objectBlock = block;
    }

    public AST getASTTree() {
        return this.m_tree;
    }

    public Block getObjectBlock() {
        return this.m_objectBlock;
    }

    public void addDMLStatement(AST aST) {
        String string = this.getKey(aST);
        if (!this.m_dmlMap.contains(string)) {
            this.m_dmlMap.put(string, new SQLStatement(aST));
        }
    }

    public SQLStatement getDMLStatement(AST aST) {
        return this.m_dmlMap.get(this.getKey(aST));
    }

    public void setTargetObjectName(String string) {
        this.m_targetObjectName = string;
    }

    public String getTargetObjectName() {
        return this.m_targetObjectName == null ? "" : this.m_targetObjectName;
    }

    public void addTriggerEvent(String string) {
        this.m_triggerEvents = this.m_triggerEvents + (this.m_triggerEvents.length() > 0 ? "," : "") + string;
    }

    public boolean hasDeleteTriggerEvent() {
        return this.m_triggerEvents.indexOf(TRIGGER_EVENT_DELETE) != -1;
    }

    public boolean hasInsertTriggerEvent() {
        return this.m_triggerEvents.indexOf(TRIGGER_EVENT_INSERT) != -1;
    }

    public boolean hasUpdateTriggerEvent() {
        return this.m_triggerEvents.indexOf(TRIGGER_EVENT_UPDATE) != -1;
    }

    private String getKey(AST aST) {
        return aST.getSourceStartLine() + ":" + aST.getSourceStartCol();
    }
}

