/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.filter.comments;

public class Comment {
    public static final String SLCSTART = "<SLC>";
    public static final String SLCEND = "</SLC>";
    private Type m_type;
    private int m_line;
    private int m_column;
    private int m_index;
    private String m_text;
    private boolean m_shouldTag = true;

    public Comment(Type type, int n, int n2, int n3, String string) {
        this.m_type = type;
        this.m_line = n;
        this.m_column = n2;
        this.m_index = n3;
        this.m_text = string;
    }

    public Type getType() {
        return this.m_type;
    }

    public int getLine() {
        return this.m_line;
    }

    public void setLine(int n) {
        this.m_line = n;
    }

    public int getColumn() {
        return this.m_column;
    }

    public int getIndex() {
        return this.m_index;
    }

    public String getText() {
        if (this.isSingleLineComment() && this.m_shouldTag) {
            return SLCSTART + this.m_text + SLCEND;
        }
        return this.m_text;
    }

    public void shouldTag(boolean bl) {
        this.m_shouldTag = bl;
    }

    public void setText(String string) {
        this.m_text = string;
    }

    public void appendTextWithNewline(String string, boolean bl) {
        this.m_text = this.m_text + (bl ? "\n" : "") + string;
    }

    public boolean isNested() {
        return this.getType().equals((Object)Type.MULTI_LINE_NESTED) || this.getType().equals((Object)Type.SINGLE_LINE_NESTED);
    }

    public boolean isSingleLineComment() {
        return this.getType() == Type.SINGLE_LINE_NESTED || this.getType() == Type.SINGLE_LINE_SEPARATE_LINE;
    }

    public static enum Type {
        SINGLE_LINE_SEPARATE_LINE,
        SINGLE_LINE_NESTED,
        MULTI_LINE_SEPARATE_LINE,
        MULTI_LINE_NESTED;

    }
}

