/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.analysis;

import antlr.collections.AST;
import java.util.ArrayList;
import oracle.dbtools.migration.translation.api.components.Block;

public class CrossTableQuery {
    private AST m_nonPivotColumn;
    private String m_nonPivotColumnOutput;
    private ArrayList<AST> m_pivotColumns = new ArrayList();
    private ArrayList<String> m_pivotColumnsOutput = new ArrayList();
    private AST m_aggregateFunc;
    private AST m_sourceTable;
    private AST m_queryTree;
    private Block m_queryBlock;
    private boolean m_isLiteralNonPivotColumn;
    private boolean m_isComplexPivotColumn;

    public CrossTableQuery(AST aST, Block block) {
        this.m_queryTree = aST;
        this.m_queryBlock = block;
        this.m_isLiteralNonPivotColumn = true;
        this.m_isComplexPivotColumn = false;
    }

    public AST getQueryTree() {
        return this.m_queryTree;
    }

    public boolean isAggregateFunction(AST aST) {
        return this.m_aggregateFunc.equals(aST);
    }

    public AST getAggregateFunction() {
        return this.m_aggregateFunc;
    }

    public void setAggregateFunction(AST aST) {
        this.m_aggregateFunc = aST;
    }

    public boolean isNonPivotColumn(AST aST) {
        return this.m_nonPivotColumn.equals(aST);
    }

    public AST getNonPivotColumn() {
        return this.m_nonPivotColumn;
    }

    public void setNonPivotColumn(AST aST) {
        this.m_nonPivotColumn = aST;
    }

    public void setNonPivotColumnOutput(String string) {
        this.m_nonPivotColumnOutput = string;
    }

    public String getNonPivotColumnOutput() {
        return this.m_nonPivotColumnOutput;
    }

    public boolean isPivotColumn(AST aST) {
        for (AST aST2 : this.m_pivotColumns) {
            if (!aST2.equals(aST)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<AST> getPivotColumns() {
        return this.m_pivotColumns;
    }

    public void addPivotColumn(AST aST) {
        this.m_pivotColumns.add(aST);
    }

    public void addPivotColumnOutput(String string) {
        this.m_pivotColumnsOutput.add(string);
    }

    public boolean isPivotColumnOutput(String string) {
        return this.m_pivotColumnsOutput.contains(string);
    }

    public boolean isSourceTable(AST aST) {
        return this.m_sourceTable.equals(aST);
    }

    public AST getSourceTable() {
        return this.m_sourceTable;
    }

    public void setSourceTable(AST aST) {
        this.m_sourceTable = aST;
    }

    public void setLiteralNonPivotColumn(boolean bl) {
        this.m_isLiteralNonPivotColumn = bl;
    }

    public boolean isLilteralNonPivotColumn() {
        return this.m_isLiteralNonPivotColumn;
    }

    public void setComplexPivotColumn(boolean bl) {
        this.m_isComplexPivotColumn = bl;
    }

    public boolean isComplexPivotColumn() {
        return this.m_isComplexPivotColumn;
    }
}

