/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging;

import com.oracle.jrockit.jfr.FlightRecorder;
import com.oracle.jrockit.jfr.InstantEvent;
import com.oracle.jrockit.jfr.InvalidEventDefinitionException;
import com.oracle.jrockit.jfr.NoSuchEventException;
import com.oracle.jrockit.jfr.management.NoSuchRecordingException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Filter;
import java.util.logging.LogRecord;
import javax.management.InstanceNotFoundException;
import oracle.core.ojdl.LogFormatter;
import oracle.core.ojdl.LogMessage;
import oracle.core.ojdl.MessageType;
import oracle.core.ojdl.logging.ODLHandler;
import oracle.core.ojdl.logging.QuickTraceHandler;
import oracle.core.ojdl.logging.QuickTraceHandlerFactory;
import oracle.core.ojdl.logging.QuickTraceRecording;
import oracle.dms.instrument.Noun;

class QuickTraceJFRHandler
extends QuickTraceHandler {
    private boolean inclStacktrace_ = false;
    private boolean inclThreadInfo_ = false;
    private String[] suppAttrs_;
    private QuickTraceRecording defRecording_;
    private Hashtable<String, QuickTraceRecording> userRecordings_;

    QuickTraceJFRHandler(LogFormatter formatter, long bufferSize, int fieldLength, String path, boolean useLoggingContext, QuickTraceHandler.Mode mode, boolean enableDMSMetrics, Noun nounRoot, boolean bufferPerUser, boolean flushOnDump) {
        super(formatter, bufferSize, fieldLength, path, useLoggingContext, mode, enableDMSMetrics, nounRoot, bufferPerUser, flushOnDump);
        try {
            Class.forName("com.oracle.jrockit.jfr.FlightRecorder");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Can not locate the required JFR classes.");
        }
        if (!FlightRecorder.isActive()) {
            throw new RuntimeException("Can not use the FlightRecorder; it is not active.");
        }
        this.userRecordings_ = new Hashtable();
    }

    private void initJFR() throws InstanceNotFoundException, IOException, NoSuchRecordingException {
        this.createDefaulfRecording();
    }

    private QuickTraceRecording createDefaulfRecording() throws NoSuchRecordingException, InstanceNotFoundException, IOException {
        this.defRecording_ = new QuickTraceRecording(this.enableUserBuffer_ ? "COMMON" : null, Integer.toString(this.id_), 0L, 0L, this.bufferSize_, this.suppAttrs_);
        return this.defRecording_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QuickTraceRecording createUserRecording(String name) throws NoSuchRecordingException, NoSuchEventException, InvalidEventDefinitionException, InstanceNotFoundException, IOException {
        Hashtable<String, QuickTraceRecording> hashtable;
        QuickTraceRecording recording = new QuickTraceRecording(name, Integer.toString(this.id_), 0L, 0L, this.bufferSize_, this.suppAttrs_);
        try {
            recording.initProducer();
            recording.initStandardFields();
        }
        catch (Exception ex) {
            return null;
        }
        recording.createDynamicEventTokens(this.inclThreadInfo_, this.inclStacktrace_);
        if (this.enableUserBuffer_) {
            this.defRecording_.disableOtherEvents();
            hashtable = this.userRecordings_;
            synchronized (hashtable) {
                for (QuickTraceRecording r : this.userRecordings_.values()) {
                    r.disableOtherEvents();
                }
            }
        }
        recording.start();
        hashtable = this.userRecordings_;
        synchronized (hashtable) {
            this.userRecordings_.put(name, recording);
            super.createDMSSensors(name);
        }
        return recording;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initHandler() {
        super.initHandler();
        LinkedList<String> suppAttrList = new LinkedList<String>();
        if (super.getSupplementalAttributes() != null) {
            for (String attr : super.getSupplementalAttributes()) {
                suppAttrList.add(attr);
            }
        }
        this.suppAttrs_ = suppAttrList.toArray(new String[suppAttrList.size()]);
        Class<QuickTraceJFRHandler> clazz = QuickTraceJFRHandler.class;
        synchronized (QuickTraceJFRHandler.class) {
            try {
                final QuickTraceJFRHandler jfrd = this;
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        jfrd.initJFR();
                        QuickTraceJFRHandler.this.defRecording_.initProducer();
                        QuickTraceJFRHandler.this.defRecording_.disableOtherEvents();
                        jfrd.initStandardFields();
                        return null;
                    }
                });
            }
            catch (Exception e) {
                this.closed_ = true;
                Throwable t = e;
                if (e instanceof PrivilegedActionException) {
                    t = ((PrivilegedActionException)e).getCause();
                }
                throw new RuntimeException(t);
            }
            return;
        }
    }

    private void initStandardFields() throws Exception {
        this.defRecording_.initStandardFields();
        this.defRecording_.createDynamicEventTokens(this.inclThreadInfo_, this.inclStacktrace_);
        this.defRecording_.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopRecording() {
        this.defRecording_.stop();
        if (this.userRecordings_ != null) {
            Hashtable<String, QuickTraceRecording> hashtable = this.userRecordings_;
            synchronized (hashtable) {
                for (QuickTraceRecording recording : this.userRecordings_.values()) {
                    if (recording == null) continue;
                    recording.stop();
                }
            }
        }
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.m_rwLock.writeLock().lock();
        try {
            Class<QuickTraceJFRHandler> clazz = QuickTraceJFRHandler.class;
            synchronized (QuickTraceJFRHandler.class) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        QuickTraceJFRHandler.this.stopRecording();
                        return null;
                    }
                });
                // ** MonitorExit[var1_1] (shouldn't be in output)
                this.closed_ = true;
            }
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
        {
            QuickTraceHandlerFactory.removeHandler(this);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void publish(LogRecord rec, ODLHandler.RecursionCounter recursionCounter) {
        int recLevelValue = rec.getLevel().intValue();
        QuickTraceRecording recording = null;
        try {
            if (this.levelValue_ == OFF || recLevelValue < this.levelValue_ || this.closed_) {
                return;
            }
            Filter filter = this.getFilter();
            if (filter != null && !filter.isLoggable(rec)) {
                return;
            }
            String str = null;
            LogMessage msg = null;
            try {
                msg = super.toLogMessage(rec, recursionCounter);
            }
            catch (Exception e) {
                this.reportError("", e, 5);
                return;
            }
            String userid = null;
            if (this.enableUserBuffer_) {
                Map supplAttrs = msg.getSupplAttrs();
                if (supplAttrs != null && supplAttrs.containsKey("APPS_USER_NAME") && (userid = (String)supplAttrs.get("APPS_USER_NAME")) != null) {
                    recording = this.getUserRecording(userid, true);
                }
                if (recording == null && (userid = msg.getUserId()) != null) {
                    recording = this.getUserRecording(userid, true);
                }
            }
            if (recording == null) {
                recording = this.defRecording_;
            }
            InstantEvent event = null;
            try {
                byte[] byArray = recording.lock_;
                synchronized (recording.lock_) {
                    event = recording.createInstantEvent();
                    // ** MonitorExit[var10_13] (shouldn't be in output)
                }
            }
            catch (Exception ex) {
                return;
            }
            {
                Map suppAttr;
                MessageType msgtype = msg.getMessageType();
                StringBuffer buf = new StringBuffer();
                if (msgtype != null) {
                    buf.append(msgtype.toString());
                    if (msg.getMessageLevel() > 1 && msgtype != MessageType.UNKNOWN) {
                        buf.append(":");
                        buf.append(msg.getMessageLevel());
                    }
                } else {
                    buf.append(MessageType.UNKNOWN.toString());
                }
                event.setValue(0, (Object)buf.toString());
                str = rec.getLoggerName();
                if (str != null) {
                    event.setValue(1, (Object)(this.fieldLen_ >= 0 && str.length() > this.fieldLen_ ? str.substring(0, this.fieldLen_) : str));
                }
                if ((str = this.useThreadName_ ? Thread.currentThread().getName() : (this.useRealThreadId_ ? Long.toString(Thread.currentThread().getId()) : msg.getThreadId())) != null) {
                    event.setValue(2, (Object)(this.fieldLen_ >= 0 && str.length() > this.fieldLen_ ? str.substring(0, this.fieldLen_) : str));
                }
                if ((str = msg.getMessageText()) != null) {
                    event.setValue(3, (Object)(this.fieldLen_ >= 0 && str.length() > this.fieldLen_ ? str.substring(0, this.fieldLen_) : str));
                }
                if (this.useLoggingContext_) {
                    str = msg.getComponentId();
                    if (str != null) {
                        event.setValue(4, (Object)(this.fieldLen_ >= 0 && str.length() > this.fieldLen_ ? str.substring(0, this.fieldLen_) : str));
                    }
                    if (msg.getExecContextId() != null) {
                        str = msg.getExecContextId().getUniqueId() + ":" + msg.getExecContextId().getRID();
                        event.setValue(5, (Object)(this.fieldLen_ >= 0 && str.length() > this.fieldLen_ ? str.substring(0, this.fieldLen_) : str));
                    }
                    if ((str = msg.getUserId()) != null) {
                        event.setValue(6, (Object)(this.fieldLen_ >= 0 && str.length() > this.fieldLen_ ? str.substring(0, this.fieldLen_) : str));
                    }
                    if ((str = msg.getDownstreamCompId()) != null) {
                        event.setValue(7, (Object)(this.fieldLen_ >= 0 && str.length() > this.fieldLen_ ? str.substring(0, this.fieldLen_) : str));
                    }
                }
                if ((suppAttr = msg.getSupplAttrs()) != null) {
                    Object obj;
                    for (String attr : this.suppAttrs_) {
                        Object value = suppAttr.get(attr);
                        if (value == null) continue;
                        str = value.toString();
                        event.setValue(attr, (Object)(this.fieldLen_ >= 0 && str.length() > this.fieldLen_ ? str.substring(0, this.fieldLen_) : str));
                    }
                    if (recLevelValue <= this.sourceClassAndMethodLevelValue_) {
                        str = rec.getSourceClassName();
                        if (str != null) {
                            event.setValue(8, (Object)(this.fieldLen_ >= 0 && str.length() > this.fieldLen_ ? str.substring(0, this.fieldLen_) : str));
                        }
                        if ((str = rec.getSourceMethodName()) != null) {
                            event.setValue(9, (Object)(this.fieldLen_ >= 0 && str.length() > this.fieldLen_ ? str.substring(0, this.fieldLen_) : str));
                        }
                    }
                    if ((obj = msg.getSupplAttrs().get("APP")) != null) {
                        event.setValue(10, obj);
                    }
                }
                event.commit();
            }
        }
        catch (Exception nsuex2) {
            Object nsuex2 = null;
        }
    }

    @Override
    public void dump(FileOutputStream fos) {
        super.internalDump(null, fos, this.flushOnDump_);
    }

    @Override
    public void dump(String name, FileOutputStream fos) {
        super.internalDump(name, fos, this.flushOnDump_);
    }

    @Override
    public void dump(File destination) {
        this.dump(null, destination, this.flushOnDump_);
    }

    @Override
    public void dump(FileOutputStream fos, boolean flushBuffer) {
        super.internalDump(null, fos, flushBuffer);
    }

    @Override
    public void dump(String name, FileOutputStream fos, boolean flushBuffer) {
        super.internalDump(name, fos, flushBuffer);
    }

    @Override
    public void dump(File destination, boolean flushBuffer) {
        this.dump(null, destination, flushBuffer);
    }

    @Override
    public void dump(String name, File destination) {
        this.dump(name, destination, this.flushOnDump_);
    }

    @Override
    public void dump(String name, File destination, boolean flushBuffer) {
        QuickTraceRecording recording = null;
        recording = name == null ? this.defRecording_ : this.getUserRecording(name, false);
        if (recording != null) {
            recording.dump(destination, flushBuffer);
        }
    }

    @Override
    long getOldestRecordTime() {
        return this.getOldestRecordTime(this.defRecording_);
    }

    @Override
    long getOldestRecordTime(String bufferName) {
        QuickTraceRecording recording = this.getUserRecording(bufferName, false);
        if (recording != null) {
            return this.getOldestRecordTime(recording);
        }
        return 0L;
    }

    private long getOldestRecordTime(QuickTraceRecording recording) {
        Date d;
        long time = 0L;
        if (recording.recording_ != null && (d = recording.recording_.getDataStartTime()) != null) {
            time = d.getTime();
        }
        return time;
    }

    @Override
    int getNumberOfRecords() {
        return 0;
    }

    @Override
    int getNumberOfRecords(String bufferName) {
        return 0;
    }

    @Override
    int getBufferUsedPercentage() {
        return this.getBufferUsedPercentage(this.defRecording_);
    }

    @Override
    int getBufferUsedPercentage(String bufferName) {
        QuickTraceRecording recording = this.getUserRecording(bufferName, false);
        if (recording != null) {
            return this.getBufferUsedPercentage(recording);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getBufferUsedPercentage(QuickTraceRecording recording) {
        int percentage = 0;
        if (recording.recording_ == null) return percentage;
        byte[] byArray = recording.lock_;
        synchronized (recording.lock_) {
            percentage = (int)Math.round(100.0 * (double)recording.recording_.getDataSize() / (double)recording.recording_.getMaxSize());
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (percentage <= 100) return percentage;
            return 100;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getBufferNames() {
        String[] names = null;
        Hashtable<String, QuickTraceRecording> hashtable = this.userRecordings_;
        synchronized (hashtable) {
            if (this.userRecordings_.size() > 0) {
                names = this.userRecordings_.keySet().toArray(new String[0]);
            }
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QuickTraceRecording getUserRecording(String name, boolean createAsNeed) {
        QuickTraceRecording recording = null;
        if (name == null || name.length() == 0) {
            return null;
        }
        Hashtable<String, QuickTraceRecording> hashtable = this.userRecordings_;
        synchronized (hashtable) {
            recording = this.userRecordings_.get(name);
            if (recording == null && createAsNeed) {
                try {
                    recording = this.createUserRecording(name);
                    this.userRecordings_.put(name, recording);
                }
                catch (Exception ex) {
                    recording = null;
                }
            }
        }
        return recording;
    }
}

