/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.core.ojdl.logging.JpsUserContextImpl;
import oracle.core.ojdl.logging.MT_UserContext;
import oracle.core.ojdl.logging.context.UserContext;
import oracle.dms.context.ExecutionContext;
import oracle.security.idm.IdentityStore;
import oracle.security.idm.Property;
import oracle.security.idm.SearchFilter;
import oracle.security.idm.SearchParameters;
import oracle.security.idm.SearchResponse;
import oracle.security.idm.SimpleSearchFilter;
import oracle.security.idm.User;
import oracle.security.idm.UserProfile;
import oracle.security.jps.JpsContext;
import oracle.security.jps.JpsContextFactory;
import oracle.security.jps.service.idstore.IdentityStoreService;

class MT_UserContextImpl
implements UserContext,
MT_UserContext {
    private UserContext m_targetProvider;
    private Logger m_logger = Logger.getLogger("oracle.odl.mt_usercontextprovider");

    protected MT_UserContextImpl(UserContext targetProvider) {
        this.m_targetProvider = targetProvider;
    }

    MT_UserContextImpl() {
        this(new JpsUserContextImpl());
    }

    @Override
    public String getUserName() {
        try {
            String userName = this.m_targetProvider.getUserName();
            ExecutionContext ctx = ExecutionContext.get();
            String enterpriseIdSet = ctx.getValue("ENTERPRISE_ID_SET");
            if (enterpriseIdSet == null) {
                ctx.setValue("ENTERPRISE_ID_SET", "true");
                this.setEnterpriseID(userName, ctx);
            }
            return userName;
        }
        catch (Throwable t) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEnterpriseID(String userName, ExecutionContext ctx) {
        block13: {
            if ("anonymous".equals(userName)) {
                return;
            }
            try {
                JpsContext jpsCtx = JpsContextFactory.getContextFactory().getContext();
                IdentityStoreService idSvc = (IdentityStoreService)jpsCtx.getServiceInstance(IdentityStoreService.class);
                IdentityStore idStore = idSvc.getIdmStore();
                String attr = (String)idStore.getStoreConfiguration().getProperty("USER_LOGIN_ATTR");
                SimpleSearchFilter filter = idStore.getSimpleSearchFilter(attr, 1, (Object)userName);
                SearchParameters userSearch = new SearchParameters((SearchFilter)filter, 2);
                SearchResponse response = idStore.searchUsers(userSearch);
                try {
                    User user = null;
                    if (response.hasNext()) {
                        user = (User)response.next();
                        UserProfile prof = user.getUserProfile();
                        Property prop = prof.getProperty("TENANT_GUID");
                        if (prop == null) {
                            return;
                        }
                        List values = prop.getValues();
                        if (values.size() > 0) {
                            ctx.setValue("ENTERPRISE_ID", values.get(0).toString());
                        }
                        if ((prop = prof.getProperty("TENANT_NAME")) == null) {
                            return;
                        }
                        values = prop.getValues();
                        if (values.size() > 0) {
                            ctx.setValue("ENTERPRISE_NAME", values.get(0).toString());
                        }
                    }
                }
                finally {
                    response.close();
                }
            }
            catch (Throwable t) {
                if (!this.m_logger.isLoggable(Level.FINE)) break block13;
                this.m_logger.log(Level.FINE, "Unable to get EnterpriseID: " + t, t);
            }
        }
    }
}

