/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl;

import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import oracle.core.ojdl.LogFormatter;
import oracle.core.ojdl.LogMessage;
import oracle.core.ojdl.MessageType;

public class TextFormatter
implements LogFormatter {
    public static final int SHORT = 1;
    public static final int FULL = 2;
    private static final String LSEP = System.getProperty("line.separator");
    private int m_style;
    private Date m_date = new Date(0L);
    private Calendar m_calendar = new GregorianCalendar();
    private String[] m_shortMonths = new DateFormatSymbols().getShortMonths();

    public TextFormatter() {
        this(1);
    }

    public TextFormatter(int style) {
        this.m_style = style;
    }

    @Override
    public String format(LogMessage msg) {
        if (this.m_style == 1) {
            return this.format_short(msg);
        }
        return this.format_full(msg);
    }

    private String format_short(LogMessage msg) {
        String msgtext;
        StringBuffer buf = new StringBuffer(100);
        buf.append("[");
        this.writeTimestamp(msg.getTimestamp(), buf);
        buf.append("] [");
        buf.append(msg.getComponentId());
        buf.append("] [");
        MessageType msgtype = msg.getMessageType();
        if (msgtype != null) {
            buf.append(msgtype.toString());
            if (msg.getMessageLevel() > 1 && msgtype != MessageType.UNKNOWN) {
                buf.append(":");
                buf.append(msg.getMessageLevel());
            }
        } else {
            buf.append(MessageType.UNKNOWN.toString());
        }
        buf.append("] ");
        if (msg.getModuleId() != null) {
            buf.append("[");
            buf.append(msg.getModuleId());
            buf.append("] ");
        }
        if (msg.getExecContextId() != null) {
            buf.append("[ecid: ");
            buf.append(msg.getExecContextId().getUniqueId());
            buf.append(",");
            buf.append(msg.getExecContextId().getRID());
            buf.append("] ");
        }
        if ((msgtext = msg.getMessageText()) != null) {
            buf.append(msg.getMessageText());
        }
        if (msg.getSupplDetail() != null) {
            buf.append(" ");
            buf.append(msg.getSupplDetail());
        }
        buf.append(LSEP);
        return buf.toString();
    }

    private String format_full(LogMessage msg) {
        String msgtext;
        Map map;
        StringBuffer buf = new StringBuffer(200);
        buf.append("[");
        this.writeTimestamp(msg.getTimestamp(), buf);
        buf.append("] ");
        buf.append("[");
        buf.append(msg.getComponentId());
        buf.append("] [");
        MessageType msgtype = msg.getMessageType();
        if (msgtype != null) {
            buf.append(msgtype.toString());
            if (msg.getMessageLevel() > 1 && msgtype != MessageType.UNKNOWN) {
                buf.append(":");
                buf.append(msg.getMessageLevel());
            }
        } else {
            buf.append(MessageType.UNKNOWN.toString());
        }
        if (msg.getMessageId() != null) {
            buf.append(" ");
            buf.append(msg.getMessageId());
        }
        buf.append("] ");
        if (msg.getModuleId() != null) {
            buf.append("[");
            buf.append(msg.getModuleId());
            buf.append("] ");
        }
        if (msg.getOrganizationId() != null) {
            buf.append("[org: ");
            buf.append(msg.getOrganizationId());
            buf.append("] ");
        }
        if (msg.getInstanceId() != null) {
            buf.append("[instanceId: ");
            buf.append(msg.getInstanceId());
            buf.append("] ");
        }
        if (msg.getHostingClientId() != null) {
            buf.append("[hostingClientId: ");
            buf.append(msg.getHostingClientId());
            buf.append("] ");
        }
        if (msg.getMessageGroup() != null) {
            buf.append("[group: ");
            buf.append(msg.getMessageGroup());
            buf.append("] ");
        }
        if (msg.getHostId() != null) {
            buf.append("[host: ");
            buf.append(msg.getHostId());
            buf.append("] ");
        }
        if (msg.getHostNwAddr() != null) {
            buf.append("[nwaddr: ");
            buf.append(msg.getHostNwAddr());
            buf.append("] ");
        }
        if (msg.getProcessId() != null) {
            buf.append("[pid: ");
            buf.append(msg.getProcessId());
            buf.append("] ");
        }
        if (msg.getThreadId() != null) {
            buf.append("[tid: ");
            buf.append(msg.getThreadId());
            buf.append("] ");
        }
        if (msg.getUserId() != null) {
            buf.append("[userId: ");
            buf.append(msg.getUserId());
            buf.append("] ");
        }
        if (msg.getSupplAttrs() != null && (map = msg.getSupplAttrs()) != null && !map.isEmpty()) {
            for (String name : map.keySet()) {
                buf.append("[");
                buf.append(name);
                buf.append(": ");
                Object v = map.get(name);
                if (v != null) {
                    buf.append(v.toString());
                }
                buf.append("] ");
            }
        }
        if (msg.getUpstreamCompId() != null) {
            buf.append("[upstreamComp: ");
            buf.append(msg.getUpstreamCompId());
            buf.append("] ");
        }
        if (msg.getDownstreamCompId() != null) {
            buf.append("[downstreamComp: ");
            buf.append(msg.getDownstreamCompId());
            buf.append("] ");
        }
        if (msg.getExecContextId() != null) {
            buf.append("[ecid: ");
            buf.append(msg.getExecContextId().getUniqueId());
            buf.append(",");
            buf.append(msg.getExecContextId().getRID());
            buf.append("] ");
        }
        if (msg.getErrorInstanceId() != null) {
            buf.append("[errid: ");
            buf.append(msg.getErrorInstanceId().getUniqueId());
            buf.append(",");
            buf.append(msg.getErrorInstanceId().getRID());
            buf.append("] ");
        }
        if (msg.getDetailLocation() != null) {
            buf.append("[detailLoc: ");
            buf.append(msg.getDetailLocation());
            buf.append("] ");
        }
        if (msg.getMessageArgs() != null) {
            LogMessage.MessageArgument[] args = msg.getMessageArgs();
            for (int i = 0; i < args.length; ++i) {
                if (args[i].getName() != null) {
                    buf.append(args[i].getName());
                    buf.append("=");
                }
                buf.append(args[i].getValue());
                buf.append(" ");
            }
        }
        if ((msgtext = msg.getMessageText()) != null) {
            buf.append(msg.getMessageText());
        }
        if (msg.getSupplDetail() != null) {
            buf.append(" ");
            buf.append(msg.getSupplDetail());
        }
        buf.append(LSEP);
        return buf.toString();
    }

    @Override
    public String header() {
        return null;
    }

    @Override
    public String tail() {
        return null;
    }

    private void writeTimestamp(long time, StringBuffer buf) {
        this.m_date.setTime(time);
        this.m_calendar.setTime(this.m_date);
        int val = this.m_calendar.get(5);
        if (val < 10) {
            buf.append("0");
        }
        buf.append(val);
        buf.append("/");
        buf.append(this.m_shortMonths[this.m_calendar.get(2)]);
        buf.append("/");
        buf.append(this.m_calendar.get(1));
        val = this.m_calendar.get(11);
        buf.append(val < 10 ? ":0" : ":");
        buf.append(val);
        val = this.m_calendar.get(12);
        buf.append(val < 10 ? ":0" : ":");
        buf.append(val);
        val = this.m_calendar.get(13);
        buf.append(val < 10 ? ":0" : ":");
        buf.append(val);
        val = this.m_calendar.get(14);
        buf.append(val < 10 ? ".00" : (val < 100 ? ".0" : "."));
        buf.append(val);
        int offset = (this.m_calendar.get(15) + this.m_calendar.get(16)) / 1000;
        if (offset < 0) {
            buf.append(" -");
            offset = -offset;
        } else {
            buf.append(" +");
        }
        val = offset / 3600;
        if (val < 10) {
            buf.append("0");
        }
        buf.append(val);
        val = (offset - val * 3600) / 60;
        buf.append(val < 10 ? "0" : "");
        buf.append(val);
    }
}

