/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.management.tracing.impl;

import commonj.work.Work;
import commonj.work.WorkItem;
import commonj.work.WorkManager;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.as.management.tracing.impl.LoggerFactory;
import oracle.as.management.tracing.impl.MBeanInvoker;

class WM_MBeanInvoker
extends MBeanInvoker {
    private WorkManager m_workManager;
    private Logger m_logger = LoggerFactory.getLogger();

    WM_MBeanInvoker(Object wm) {
        this.m_workManager = (WorkManager)wm;
    }

    @Override
    protected List<MBeanInvoker.Result> invokeAll(List<MBeanInvoker.Worker> workers) throws Exception {
        if (this.m_logger.isLoggable(Level.FINE)) {
            this.m_logger.logp(Level.FINE, this.getClass().getName(), "invokeAll", "Invoking MBean operation on " + workers.size() + " targets");
        }
        ArrayList<WorkItem> workItems = new ArrayList<WorkItem>(workers.size());
        for (MBeanInvoker.Worker worker : workers) {
            workItems.add(this.m_workManager.schedule((Work)new WorkImpl(worker)));
        }
        this.m_workManager.waitForAll(workItems, Long.MAX_VALUE);
        ArrayList<MBeanInvoker.Result> results = new ArrayList<MBeanInvoker.Result>(workers.size());
        for (WorkItem wi : workItems) {
            results.add(((WorkImpl)wi.getResult()).getResult());
        }
        return results;
    }

    private static class WorkImpl
    implements Work {
        private final MBeanInvoker.Worker m_worker;

        WorkImpl(MBeanInvoker.Worker worker) {
            this.m_worker = worker;
        }

        public boolean isDaemon() {
            return false;
        }

        public void release() {
        }

        public void run() {
            this.m_worker.run();
        }

        public MBeanInvoker.Result getResult() {
            return this.m_worker.getResult();
        }
    }
}

