/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.management.tracing.impl;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import oracle.as.jmx.framework.annotations.Inject;
import oracle.as.jmx.framework.services.JMXSupport;
import oracle.as.management.logging.impl.Msgs;
import oracle.as.management.logging.messages.Messages;
import oracle.as.management.tracing.TraceInfo;
import oracle.as.management.tracing.TraceProviderInfo;
import oracle.as.management.tracing.TracingControllerMXBean;
import oracle.as.management.tracing.TracingManagerMXBean;
import oracle.as.management.tracing.impl.LoggerFactory;
import oracle.as.management.tracing.impl.MBeanInvoker;

public class TracingManagerMXBeanImpl
implements TracingManagerMXBean {
    private Logger m_logger = LoggerFactory.getLogger();
    private JMXSupport m_jmxSupport;

    @Inject
    public void setJMXSupport(JMXSupport jmxSupport) throws Exception {
        this.m_jmxSupport = jmxSupport;
    }

    @Override
    public String startTracing(ObjectName[] targets, String traceId, String attrName, String attrValue, String level, long duration, String desc) throws Exception {
        return this.startTracing(targets, traceId, attrName, attrValue, level, duration, desc, null);
    }

    @Override
    public String startTracing(ObjectName[] targets, String traceId, String attrName, String attrValue, String level, long duration, String desc, Map<String, Map<String, String>> params) throws Exception {
        String METHOD_NAME = "startTracing";
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.entering(this.getClass().getName(), "startTracing", new Object[]{this.asList(targets), traceId, attrName, attrValue, level, duration, desc});
        }
        ArrayList<TracingControllerMXBean> started = new ArrayList<TracingControllerMXBean>();
        Exception exn = null;
        ObjectName failedTarget = null;
        if (traceId == null || traceId.length() == 0) {
            traceId = UUID.randomUUID().toString();
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "startTracing", "created a new traceID: " + traceId);
            }
        }
        List<TracingControllerMXBean> controllerList = this.getControllers(targets);
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "startTracing", "target controllers: " + controllerList);
        }
        for (TracingControllerMXBean tcmb : controllerList) {
            try {
                tcmb.startTracing(traceId, attrName, attrValue, level, duration, desc, params);
                started.add(tcmb);
            }
            catch (Exception e) {
                exn = e;
                failedTarget = this.getObjectName(tcmb);
                if (!this.m_logger.isLoggable(Level.FINE)) break;
                this.m_logger.logp(Level.FINE, this.getClass().getName(), "startTracing", "Invoking operation startTracing failed for target " + failedTarget + " with exception: " + e, e);
                break;
            }
        }
        if (exn != null) {
            boolean rolledBack = true;
            for (TracingControllerMXBean tcmb : started) {
                try {
                    tcmb.stopTracing(traceId);
                }
                catch (Exception e1) {
                    rolledBack = false;
                    if (!this.m_logger.isLoggable(Level.FINE)) continue;
                    this.m_logger.logp(Level.FINE, this.getClass().getName(), "startTracing", "startTracing rollback failed for target: " + this.getObjectName(tcmb) + " with exception: " + e1, e1);
                }
            }
            if (rolledBack) {
                throw new Exception(Msgs.get((String)"ODL-52803", (Object[])new Object[]{failedTarget, exn.toString()}), exn);
            }
            this.m_logger.logrb(Level.SEVERE, this.getClass().getName(), "startTracing", Messages.class.getName(), "ODL-52805");
            throw new Exception(Msgs.get((String)"ODL-52805", (Object[])new Object[0]));
        }
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.exiting(this.getClass().getName(), "startTracing", traceId);
        }
        return traceId;
    }

    @Override
    public void stopTracing(ObjectName[] targets, String traceId) throws Exception {
        this.stopTracing(targets, traceId, false);
    }

    @Override
    public void stopTracing(ObjectName[] targets, String traceId, boolean createIncident) throws Exception {
        String METHOD_NAME = "stopTracing";
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.entering(this.getClass().getName(), "stopTracing", new Object[]{targets == null ? null : Arrays.asList(targets), traceId});
        }
        MBeanServer mbs = this.getMBeanServer();
        MBeanInvoker mbi = MBeanInvoker.newInstance();
        List<ObjectName> controllerNames = this.getControllerNames(targets);
        List<MBeanInvoker.Result> results = mbi.invoke(mbs, controllerNames, "stopTracing", new Object[]{traceId, createIncident}, new String[]{"java.lang.String", "boolean"});
        for (MBeanInvoker.Result result : results) {
            if (result.isSuccessful()) continue;
            Exception e = result.getException();
            this.m_logger.log(Level.SEVERE, "Failed to invoke operation 'stopTracing' on target '" + result.getTarget() + "'; caught exception: " + e, e);
        }
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.exiting(this.getClass().getName(), "stopTracing");
        }
    }

    @Override
    public void stopTracing(ObjectName[] targets) throws Exception {
        String METHOD_NAME = "stopTracing";
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.entering(this.getClass().getName(), "stopTracing");
        }
        for (TracingControllerMXBean tcmb : this.getControllers(targets)) {
            try {
                tcmb.stopTracing();
            }
            catch (Exception e) {
                if (this.m_logger.isLoggable(Level.FINE)) {
                    this.m_logger.logp(Level.FINE, this.getClass().getName(), "stopTracing", "Failed to invoke stopTracing operation on target " + this.getObjectName(tcmb) + ". Exception: " + e, e);
                }
                throw e;
            }
        }
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.exiting(this.getClass().getName(), "stopTracing");
        }
    }

    @Override
    public Set<String> getAvailableProviders(ObjectName[] targets) throws Exception {
        String METHOD_NAME = "getAvailableProviders";
        TreeSet<String> providers = new TreeSet<String>();
        for (TracingControllerMXBean tcmb : this.getControllers(targets)) {
            try {
                providers.addAll(tcmb.getAvailableProviders());
            }
            catch (Exception e) {
                if (this.m_logger.isLoggable(Level.FINE)) {
                    this.m_logger.logp(Level.FINE, this.getClass().getName(), "getAvailableProviders", "Failed to invoke getAvailableProviders operation on target " + this.getObjectName(tcmb) + ". Exception: " + e, e);
                }
                throw e;
            }
        }
        return providers;
    }

    @Override
    public Set<String> getEnabledProviders(ObjectName[] targets) throws Exception {
        String METHOD_NAME = "getEnabledProviders";
        TreeSet<String> providers = new TreeSet<String>();
        for (TracingControllerMXBean tcmb : this.getControllers(targets)) {
            try {
                providers.addAll(tcmb.getEnabledProviders());
            }
            catch (Exception e) {
                if (this.m_logger.isLoggable(Level.FINE)) {
                    this.m_logger.logp(Level.FINE, this.getClass().getName(), "getEnabledProviders", "Failed to invoke getEnabledProviders operation on target " + this.getObjectName(tcmb) + ". Exception: " + e, e);
                }
                throw e;
            }
        }
        return providers;
    }

    @Override
    public void setEnabledProviders(ObjectName[] targets, Set<String> enabledProviders) throws Exception {
        String METHOD_NAME = "setEnabledProviders";
        for (TracingControllerMXBean tcmb : this.getControllers(targets)) {
            try {
                tcmb.setEnabledProviders(enabledProviders);
            }
            catch (Exception e) {
                if (this.m_logger.isLoggable(Level.FINE)) {
                    this.m_logger.logp(Level.FINE, this.getClass().getName(), "setEnabledProviders", "Failed to invoke setEnabledProviders operation on target " + this.getObjectName(tcmb) + ". Exception: " + e, e);
                }
                throw e;
            }
        }
    }

    @Override
    public List<TraceProviderInfo> getTraceProviderInfo(ObjectName[] targets) throws Exception {
        String METHOD_NAME = "getTraceProviderInfo";
        ArrayList<TraceProviderInfo> list = new ArrayList<TraceProviderInfo>();
        HashSet<String> providers = new HashSet<String>();
        for (TracingControllerMXBean tcmb : this.getControllers(targets)) {
            try {
                for (TraceProviderInfo info : tcmb.getLocalizedTraceProviderInfo(this.getClientLocale())) {
                    if (providers.contains(info.getName())) continue;
                    providers.add(info.getName());
                    list.add(info);
                }
            }
            catch (Exception e) {
                if (this.m_logger.isLoggable(Level.FINE)) {
                    this.m_logger.logp(Level.FINE, this.getClass().getName(), "getTraceProviderInfo", "Failed to invoke getTraceProviderInfo operation on target " + this.getObjectName(tcmb) + ". Exception: " + e, e);
                }
                throw e;
            }
        }
        return list;
    }

    @Override
    public TraceProviderInfo getTraceProviderInfo(ObjectName[] targets, String providerName) throws Exception {
        String METHOD_NAME = "getTraceProviderInfo";
        for (TracingControllerMXBean tcmb : this.getControllers(targets)) {
            try {
                TraceProviderInfo info = tcmb.getTraceProviderInfo(providerName, this.getClientLocale());
                if (info == null) continue;
                return info;
            }
            catch (Exception e) {
                if (this.m_logger.isLoggable(Level.FINE)) {
                    this.m_logger.logp(Level.FINE, this.getClass().getName(), "getTraceProviderInfo", "Failed to invoke getTraceProviderInfo operation on target " + this.getObjectName(tcmb) + ". Exception: " + e, e);
                }
                throw e;
            }
        }
        return null;
    }

    @Override
    public List<TraceInfo> getActiveTraces(ObjectName[] targets) throws Exception {
        String METHOD_NAME = "getActiveTraces";
        LinkedHashMap<String, TraceInfo> map = new LinkedHashMap<String, TraceInfo>();
        List<TracingControllerMXBean> controllers = this.getControllers(targets);
        for (TracingControllerMXBean controller : controllers) {
            for (TraceInfo ti : controller.getActiveTraces()) {
                TraceInfo dti = (TraceInfo)map.get(ti.getTraceId());
                if (dti == null) {
                    map.put(ti.getTraceId(), ti);
                    continue;
                }
                if (!this.isInSync(ti, dti)) {
                    if (this.m_logger.isLoggable(Level.FINE)) {
                        this.m_logger.logp(Level.FINE, this.getClass().getName(), "getActiveTraces", "Tracing configuration not in sync, traceId=" + ti.getTraceId() + ", server=" + this.getObjectName(controller));
                    }
                    throw new Exception("The configuration for individual servers is not synchronized so a single aggregate view cannot be provided for the group of servers. Disable all tracing to reset the tracing configuration.");
                }
                if (ti.getStartTime() < dti.getStartTime()) {
                    dti.setStartTime(ti.getStartTime());
                }
                if (ti.getExpirationTime() >= dti.getExpirationTime()) continue;
                dti.setExpirationTime(ti.getExpirationTime());
            }
        }
        return new ArrayList<TraceInfo>(map.values());
    }

    @Override
    public List<TraceInfo> getHistory(ObjectName[] targets) throws Exception {
        String METHOD_NAME = "getHistory";
        LinkedHashMap<String, TraceInfo> map = new LinkedHashMap<String, TraceInfo>();
        List<TracingControllerMXBean> controllers = this.getControllers(targets);
        for (TracingControllerMXBean controller : controllers) {
            for (TraceInfo ti : controller.getHistory()) {
                TraceInfo dti = (TraceInfo)map.get(ti.getTraceId());
                if (dti == null) {
                    map.put(ti.getTraceId(), ti);
                    continue;
                }
                if (!this.isInSync(ti, dti) && this.m_logger.isLoggable(Level.FINE)) {
                    this.m_logger.logp(Level.FINE, this.getClass().getName(), "getHistory", "Trace history received from server " + this.getObjectName(controller) + " is out of sync. Discarding");
                }
                if (ti.getStartTime() < dti.getStartTime()) {
                    dti.setStartTime(ti.getStartTime());
                }
                if (ti.getStopTime() <= dti.getStopTime()) continue;
                dti.setStopTime(ti.getStopTime());
            }
        }
        return new ArrayList<TraceInfo>(map.values());
    }

    @Override
    public void clearHistory(ObjectName[] targets) throws Exception {
        List<TracingControllerMXBean> controllers = this.getControllers(targets);
        for (TracingControllerMXBean controller : controllers) {
            controller.clearHistory();
        }
    }

    @Override
    public Map<String, String> getTracingLoggers(ObjectName[] targets) throws Exception {
        TreeMap<String, String> map = new TreeMap<String, String>();
        List<TracingControllerMXBean> controllers = this.getControllers(targets);
        for (TracingControllerMXBean controller : controllers) {
            Map<String, Boolean> targetLoggers = controller.getODLLoggers();
            for (Map.Entry<String, Boolean> entry : targetLoggers.entrySet()) {
                String logger = entry.getKey();
                Boolean b = entry.getValue();
                if (map.containsKey(logger)) {
                    String v = (String)map.get(logger);
                    if (b.booleanValue()) {
                        if ("enabled".equals(v)) continue;
                        map.put(logger, "mixed");
                        continue;
                    }
                    if ("disabled".equals(v)) continue;
                    map.put(logger, "mixed");
                    continue;
                }
                map.put(logger, b != false ? "enabled" : "disabled");
            }
        }
        return map;
    }

    @Override
    public void configureTracingLoggers(ObjectName[] targets, Map<String, Boolean> loggers) throws Exception {
        List<TracingControllerMXBean> controllers = this.getControllers(targets);
        for (TracingControllerMXBean controller : controllers) {
            Map<String, Boolean> targetLoggers = controller.getODLLoggers();
            controller.configureODLLoggers(loggers);
        }
    }

    private boolean isInSync(TraceInfo ti1, TraceInfo ti2) {
        return ti1.getTraceId().equals(ti2.getTraceId()) && ti1.getAttrName().equals(ti2.getAttrName()) && ti1.getAttrValue().equals(ti2.getAttrValue()) && ti1.getLevel().equals(ti2.getLevel()) && (ti1.getDesc() == null && ti2.getDesc() == null || ti1.getDesc() != null && ti2.getDesc().equals(ti2.getDesc()));
    }

    private List<TracingControllerMXBean> getControllers(ObjectName[] targets) throws Exception {
        ArrayList<TracingControllerMXBean> list = new ArrayList<TracingControllerMXBean>();
        MBeanServer mbs = this.getMBeanServer();
        Set<ObjectName> mbeans = mbs.queryNames(new ObjectName("oracle.tracing:type=TracingControllerMXBean,*"), null);
        if (targets != null && targets.length > 0) {
            for (ObjectName target : targets) {
                String serverName = this.getServerName(target);
                ObjectName name = new ObjectName("oracle.tracing:type=TracingControllerMXBean,Location=" + serverName);
                if (!mbeans.contains(name)) {
                    throw new Exception(Msgs.get((String)"ODL-52502", (Object[])new Object[]{serverName}));
                }
                list.add(JMX.newMXBeanProxy(mbs, name, TracingControllerMXBean.class));
            }
        } else {
            Set<ObjectName> names = mbs.queryNames(new ObjectName("oracle.tracing:type=TracingControllerMXBean,*"), null);
            for (ObjectName name : names) {
                list.add(JMX.newMXBeanProxy(mbs, name, TracingControllerMXBean.class));
            }
        }
        return list;
    }

    private List<ObjectName> getControllerNames(ObjectName[] targets) throws Exception {
        ArrayList<ObjectName> list = new ArrayList<ObjectName>();
        MBeanServer mbs = this.getMBeanServer();
        Set<ObjectName> mbeans = mbs.queryNames(new ObjectName("oracle.tracing:type=TracingControllerMXBean,*"), null);
        if (targets != null && targets.length > 0) {
            for (ObjectName target : targets) {
                String serverName = this.getServerName(target);
                ObjectName name = new ObjectName("oracle.tracing:type=TracingControllerMXBean,Location=" + serverName);
                if (!mbeans.contains(name)) {
                    throw new Exception(Msgs.get((String)"ODL-52502", (Object[])new Object[]{serverName}));
                }
                list.add(name);
            }
        } else {
            Set<ObjectName> names = mbs.queryNames(new ObjectName("oracle.tracing:type=TracingControllerMXBean,*"), null);
            list.addAll(names);
        }
        return list;
    }

    private MBeanServer getMBeanServer() throws Exception {
        return this.m_jmxSupport.getMBeanServer();
    }

    private String getServerName(ObjectName target) throws Exception {
        if (target != null && "com.bea".equals(target.getDomain()) && "Server".equals(target.getKeyProperty("Type")) && target.getKeyProperty("Name") != null) {
            return target.getKeyProperty("Name");
        }
        throw new Exception("Invalid target: " + target + ". This is not a valid target name.");
    }

    private final <T> List<T> asList(T array) {
        return array == null ? null : Arrays.asList(array);
    }

    private final ObjectName getObjectName(TracingControllerMXBean proxy) {
        return ((MBeanServerInvocationHandler)Proxy.getInvocationHandler(proxy)).getObjectName();
    }

    private final String getClientLocale() {
        Locale loc = this.m_jmxSupport.getLocale();
        return loc != null ? loc.toString() : null;
    }
}

