/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.library.helpset;

import java.net.MalformedURLException;
import java.net.URL;
import oracle.help.common.IndirectTarget;
import oracle.help.common.Target;
import oracle.help.common.util.Canonicalizer;
import oracle.help.library.helpset.HelpSet;
import oracle.help.library.helpset.HelpSetParseException;

public class HelpSetSection {
    private HelpSet _helpSet;
    private String _helpSetDir;
    private String _identifier;
    private String _descriptiveTypeName;
    private String _typeClass;
    private String _descriptiveEngineName;
    private String _engineClass;
    private String _engineParams;
    private String _dataLocationString;
    private String _classAttribute;
    private String _viewBasePath;
    private String _viewTitle;
    private String _viewLabel;
    private String _viewName;
    private String _titleImageString;
    private String _labelImageString;
    private boolean _completed = false;

    public HelpSetSection(HelpSet helpSet, String helpSetDir) {
        this._helpSet = helpSet;
        this._helpSetDir = helpSetDir;
        this._identifier = null;
        this._viewTitle = null;
        this._viewLabel = null;
        this._viewName = null;
        this._descriptiveTypeName = null;
        this._typeClass = null;
        this._descriptiveEngineName = null;
        this._engineClass = null;
        this._dataLocationString = null;
        this._classAttribute = null;
        this._titleImageString = null;
        this._labelImageString = null;
        this._completed = false;
    }

    public HelpSet getHelpSet() {
        return this._helpSet;
    }

    public String getHelpSetDir() {
        return this._helpSetDir;
    }

    public String getHelpSetEncoding() {
        return this._helpSet.getHelpSetEncoding();
    }

    public void setIdentifier(String identifier) {
        this._identifier = identifier;
    }

    public String getIdentifier() {
        return this._identifier;
    }

    public void setDescriptiveTypeName(String typeName) {
        this._descriptiveTypeName = typeName;
    }

    public String getDescriptiveTypeName() {
        return this._descriptiveTypeName;
    }

    public void setTypeClass(String typeClass) {
        this._typeClass = typeClass;
    }

    public String getTypeClass() {
        return this._typeClass;
    }

    public void setDescriptiveEngineName(String engineName) {
        this._descriptiveEngineName = engineName;
    }

    public String getDescriptiveEngineName() {
        return this._descriptiveEngineName;
    }

    public void setEngineClass(String engineClass) {
        this._engineClass = engineClass;
    }

    public void setEngineParams(String engineParams) {
        this._engineParams = engineParams;
    }

    public String getEngineParams() {
        return this._engineParams;
    }

    public String getEngineClass() {
        return this._engineClass;
    }

    public void setDataLocationString(String dataLocation) {
        this._dataLocationString = dataLocation;
    }

    public String getDataLocationString() {
        return this._dataLocationString;
    }

    public URL getDataLocationURL() throws HelpSetParseException {
        URL dataURL = null;
        try {
            if (this._dataLocationString != null) {
                dataURL = this._classAttribute != null && !this._classAttribute.equals("") ? Class.forName(this._classAttribute).getResource(this._dataLocationString) : Canonicalizer.getAbsoluteURL(this._helpSetDir, this._dataLocationString);
            }
        }
        catch (MalformedURLException e) {
            throw new HelpSetParseException("Bad URL: " + e.getMessage());
        }
        catch (ClassNotFoundException cnfE) {
            throw new HelpSetParseException("Class not found: " + this._classAttribute);
        }
        if (dataURL != null) {
            this._viewBasePath = dataURL.toString();
            Canonicalizer.fixSeparators(this._viewBasePath);
            this._viewBasePath = this._viewBasePath.substring(0, this._viewBasePath.lastIndexOf(47) + 1);
        }
        return dataURL;
    }

    public void setClassAttribute(String classAttribute) {
        this._classAttribute = classAttribute;
    }

    public String getClassAttribute() {
        return this._classAttribute;
    }

    public void setViewBasePath(String basePath) {
        this._viewBasePath = basePath;
    }

    public String getViewBasePath() {
        return this._viewBasePath;
    }

    public void setViewTitle(String viewTitle) {
        this._viewTitle = viewTitle;
    }

    public String getViewTitle() {
        return this._viewTitle;
    }

    public void setViewLabel(String viewLabel) {
        this._viewLabel = viewLabel;
    }

    public String getViewLabel() {
        return this._viewLabel;
    }

    public void setViewName(String viewName) {
        this._viewName = viewName;
    }

    public String getViewName() {
        return this._viewName;
    }

    public void setTitleImageString(String titleImage) {
        this._titleImageString = titleImage;
    }

    public String getTitleImageString() {
        return this._titleImageString;
    }

    public Target getTitleImageTarget() {
        IndirectTarget imageTarget = null;
        if (this._titleImageString != null) {
            imageTarget = new IndirectTarget(this._helpSet, this._titleImageString);
        }
        return imageTarget;
    }

    public void setLabelImageString(String labelImage) {
        this._labelImageString = labelImage;
    }

    public String getLabelImageString() {
        return this._labelImageString;
    }

    public Target getLabelImageTarget() {
        IndirectTarget imageTarget = null;
        if (this._labelImageString != null) {
            imageTarget = new IndirectTarget(this._helpSet, this._labelImageString);
        }
        return imageTarget;
    }

    public boolean isCompleted() {
        return this._completed;
    }

    public void setCompleted(boolean completed) {
        this._completed = completed;
    }
}

