/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.externaltools;

import java.net.URL;
import javax.ide.util.MetaClass;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.ide.Context;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.externaltools.ExternalTool;
import oracle.ide.externaltools.ExternalToolBaseProperties;
import oracle.ide.externaltools.ExternalToolManager;
import oracle.ide.externaltools.ToolRunException;
import oracle.javatools.data.HashStructure;
import oracle.javatools.icons.OracleIcons;

public class LazyExternalTool
extends ExternalTool {
    private HashStructure _baseHash;
    private ExternalTool _realTool;
    private static final String EXTERNAL_TOOL_CLASS = "externalToolClass";

    public LazyExternalTool(HashStructure hash) {
        this._baseHash = hash;
    }

    @Override
    public void run(ExternalToolManager manager, Context context) throws ToolRunException {
        ExternalTool realTool = this.getInstance();
        realTool.run(manager, context);
    }

    public String getClassName() {
        return this.getMetaClass().getClassName();
    }

    private MetaClass getMetaClass() {
        return LazyClassAdapter.getInstance((HashStructure)this._baseHash).getMetaClass(EXTERNAL_TOOL_CLASS);
    }

    @Override
    public Icon getIconWhenRequired() {
        ExternalToolBaseProperties externalProps;
        URL iconURL;
        if (this._baseHash != null && (iconURL = (externalProps = ExternalToolBaseProperties.getInstance(this._baseHash)).getIconURL()) != null) {
            return new ImageIcon(iconURL);
        }
        return OracleIcons.getIcon((String)"file.png");
    }

    public ExternalTool getInstance() {
        if (this._realTool == null) {
            this._realTool = (ExternalTool)LazyClassAdapter.getInstance((HashStructure)this._baseHash).createInstance(ExternalTool.class, EXTERNAL_TOOL_CLASS);
            this._realTool.initializeExternalTool();
            this._realTool.setData(this.getData());
        }
        return this._realTool;
    }
}

