/*
 * Decompiled with CFR 0.152.
 */
package oracle.mof.xmi;

import java.net.URL;
import oracle.mof.xmi.ResourcesSingleton;

public class XMIErrorMessage
implements Comparable<XMIErrorMessage> {
    private URL m_location;
    private boolean m_error;
    private int m_lineNumber;
    private int m_columnNumber;
    private String m_message;

    public XMIErrorMessage(URL location, boolean error, int lineNumber, int columnNumber, String message) {
        this.m_location = location;
        this.m_error = error;
        this.m_lineNumber = lineNumber;
        this.m_columnNumber = columnNumber;
        this.m_message = lineNumber != -1 ? ResourcesSingleton.getPicker().getString(error ? "ErrorMessage.text" : "WarningMessage.text", new Object[]{Integer.toString(lineNumber), Integer.toString(columnNumber), message}) : ResourcesSingleton.getPicker().getString(error ? "NoLocationErrorMessage.text" : "NoLocationWarningMessage.text", (Object)message);
    }

    public URL getLocation() {
        return this.m_location;
    }

    public boolean isError() {
        return this.m_error;
    }

    public int getLineNumber() {
        return this.m_lineNumber;
    }

    public int getColumnNumber() {
        return this.m_columnNumber;
    }

    public String getMessage() {
        return this.m_message;
    }

    public String toString() {
        return this.m_message;
    }

    @Override
    public int compareTo(XMIErrorMessage m) {
        if (this.m_error ^ m.m_error) {
            return this.m_error ? -1 : 1;
        }
        int ln = this.m_lineNumber - m.m_lineNumber;
        if (ln != 0) {
            return ln;
        }
        return this.m_columnNumber - m.m_columnNumber;
    }
}

