/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.util.Collection;
import java.util.HashSet;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.ParserUtils;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.SchemaObjectValidator;
import oracle.javatools.db.validators.ValidationContext;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;

public class IndexValidator
extends SchemaObjectValidator<Index> {
    public IndexValidator(DBObjectProvider prov) {
        super(prov);
    }

    @DBObjectValidator.PropertyValidator(value={"table"})
    public void validateTable(Index original, Index updated) throws ValidationException {
        if (updated.getTable() == null) {
            throw new ValidationException((DBObject)updated, APIBundle.get((String)"INDEX_ERROR_ORPHANED_INDEX"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"columnExpressions"})
    public void validateExpressions(ValidationContext<Index> context) throws ValidationException {
        Index index = (Index)context.getUpdatedObject();
        IndexObject[] ios = index.getColumnExpressions();
        if (ios.length <= 0) {
            throw new ValidationException((DBObject)index, APIBundle.get((String)"INDEX_ERROR_NO_COLUMN_EXPR"));
        }
        ValidationException ve = null;
        for (IndexObject io : ios) {
            String exp = io.getExpressionSource();
            if (ModelUtil.hasLength((String)exp)) continue;
            ve = (ValidationException)((Object)ValidationException.append(ve, (DBException)((Object)new ValidationException((DBObject)index, APIBundle.format((String)"INDEX_ERROR_INVALID_COLUMN_EXPRESSION", (Object[])new Object[]{index.getName(), ""})))));
        }
        if (ve != null) {
            throw ve;
        }
        if (context.getLevel() == ValidationLevel.FULL) {
            this.checkColumnExpressions(index);
            this.checkDefinitionIsUnique(index);
        }
    }

    protected void validateColumnType(Index index, Column col) throws ValidationException {
    }

    protected void checkColumnExpressions(Index index) throws ValidationException {
        IndexObject[] ios = index.getColumnExpressions();
        Table t = index.getTable();
        HashSet<String> columnNames = new HashSet<String>();
        for (int i = 0; i < ios.length; ++i) {
            String expression = ios[i].getExpressionSource();
            if (!ModelUtil.hasLength((String)expression)) continue;
            this.validateIndexExpression(index, ios[i], expression);
            if (!this.columnMustBeUnique(t, index, ios[i])) continue;
            String columnName = this.getProvider().getInternalName(expression);
            if (columnNames.contains(columnName)) {
                throw new ValidationException((DBObject)index, APIBundle.format((String)"INDEX_ERROR_DUPLICATE_COLUMN", (Object[])new Object[]{columnName, index.getName()}));
            }
            columnNames.add(columnName);
        }
    }

    protected void validateIndexExpression(Index index, IndexObject io, String columnExpression) throws ValidationException {
        boolean noColumns;
        Table t = index.getTable();
        SQLFragment expressionFragment = null;
        try {
            this.getProvider().getObjectFactory().ensureDerivedPropertyBuilder((DBObject)io);
            DBUtil.ensureObjectBuilt((DBObject)io, (String[])new String[]{"expression"});
            expressionFragment = io.getExpression();
        }
        catch (DBException e) {
            throw new ValidationException((DBObject)index, APIBundle.format((String)"INDEX_ERROR_INVALID_COLUMN_EXPRESSION_PARSER_ERROR", (Object[])new Object[]{columnExpression, e.getMessage()}));
        }
        boolean bl = noColumns = t instanceof MaterializedView && t.getColumns().length == 0;
        if (!noColumns && expressionFragment != null) {
            for (String[] nameComponents : ParserUtils.getColumnNames((SQLFragment)expressionFragment)) {
                String columnName = this.getProvider().getInternalName(nameComponents[0]);
                Column col = t.getColumn(columnName);
                if (col == null) {
                    throw new ValidationException((DBObject)index, APIBundle.format((String)"INDEX_ERROR_COLUMN_NOT_IN_TABLE", (Object[])new Object[]{columnName, t.getName()}));
                }
                this.validateColumnType(index, col);
            }
        }
    }

    protected boolean columnMustBeUnique(Table table, Index index, IndexObject indexObject) {
        return true;
    }

    protected void checkDefinitionIsUnique(Index index) throws ValidationException {
        if (index.getIndexType() != Index.IndexType.DOMAIN) {
            Table indexTable = index.getTable();
            IndexObject[] indexColExprs = index.getColumnExpressions();
            Index origIndex = (Index)TemporaryObjectID.findOriginalObject((DBObject)index);
            if (origIndex == null) {
                origIndex = index;
            }
            for (Index otherIndex : indexTable.getIndexes()) {
                IndexObject[] cffColExprs;
                Index origOtherIndex = (Index)TemporaryObjectID.findOriginalObject((DBObject)otherIndex);
                if (origOtherIndex == null) {
                    origOtherIndex = otherIndex;
                }
                if (otherIndex == index || origOtherIndex == origIndex || otherIndex.getIndexType() == Index.IndexType.DOMAIN || indexColExprs.length != (cffColExprs = otherIndex.getColumnExpressions()).length) continue;
                boolean iosAreDifferent = false;
                for (int i = 0; i < indexColExprs.length; ++i) {
                    if (this.areEqual(indexColExprs[i], cffColExprs[i])) continue;
                    iosAreDifferent = true;
                    break;
                }
                if (iosAreDifferent) continue;
                throw new ValidationException((DBObject)index, APIBundle.format((String)"INDEX_ERROR_DUPLICATE_INDEX_DEFINITION", (Object[])new Object[]{index.getName(), otherIndex.getName()}));
            }
        }
    }

    private boolean areEqual(IndexObject io1, IndexObject io2) {
        String io2Expression;
        String io1Expression;
        boolean io2IsAscending;
        boolean io1IsAscending = !IndexObject.OrderType.DESC.equals((Object)io1.getOrderType());
        boolean bl = io2IsAscending = !IndexObject.OrderType.DESC.equals((Object)io2.getOrderType());
        boolean retval = io1IsAscending != io2IsAscending ? false : ((io1Expression = io1.getExpressionSource()) == (io2Expression = io2.getExpressionSource()) ? true : (io1Expression == null || io2Expression == null ? false : io1Expression.replaceAll("\\s", "").toUpperCase().equals(io2Expression.replaceAll("\\s", "").toUpperCase())));
        return retval;
    }

    public DBObjectValidator.NamespaceType getNamespaceType() {
        return DBObjectValidator.NamespaceType.TYPE;
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection retval = super.listAlwaysValidProperties();
        retval.add("keyCompression");
        retval.add("parallelDegree");
        retval.add("reverse");
        retval.add("domainIndextype");
        retval.add("domainIndextypeOpStatus");
        retval.add("domainIndextypeParameters");
        return retval;
    }
}

