/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.math.BigInteger;
import java.util.Collection;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.FileSpecification;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;

public class FileSpecificationValidator
extends AbstractChildDBObjectValidator<FileSpecification> {
    private static Integer n1 = new Integer(1);

    public FileSpecificationValidator(DBObjectProvider prov) {
        super(prov);
    }

    @DBObjectValidator.PropertyValidator(value={"fileSize"}, level=ValidationLevel.FULL)
    public void validateFileSize(FileSpecification original, FileSpecification updated) throws ValidationException {
        Tablespace tbsp;
        Tablespace.TablespaceType tbspType;
        BigInteger fileSize = updated.getFileSize();
        if (fileSize != null && fileSize.compareTo(BigInteger.ONE) < 0) {
            throw new ValidationException((DBObject)updated, APIBundle.format((String)"STORAGE_PROPERTY_ERROR_TOO_SMALL", (Object[])new Object[]{"File Size", n1}));
        }
        if (updated.getParent() instanceof Tablespace && fileSize == null && (tbspType = (Tablespace.TablespaceType)(tbsp = (Tablespace)updated.getParent()).getProperty("TablespaceType")).equals((Object)Tablespace.TablespaceType.UNDO)) {
            throw new ValidationException((DBObject)updated, APIBundle.get((String)"TABLESPACE_SIZE_ERROR"));
        }
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection retval = super.listAlwaysValidProperties();
        retval.add("reuse");
        retval.add("directory");
        retval.add("autoExtendProperties");
        retval.add(Property.createPath((String[])new String[]{"autoExtendProperties", "autoExtendOn"}));
        retval.add(Property.createPath((String[])new String[]{"autoExtendProperties", "nextSize"}));
        retval.add(Property.createPath((String[])new String[]{"autoExtendProperties", "maxSize"}));
        return retval;
    }
}

