/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.Collection;
import oracle.javatools.db.AbstractIncrementer;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;

class AbstractIncrementerValidator<T extends AbstractIncrementer>
extends DBObjectValidator<T> {
    private static final int OK = 1;
    private static final int ERROR_ZERO_INCREMENT = -2;
    private static final int ERROR_INCREMENT_TOO_MANY_DIGITS = -3;
    private static final int ERROR_INCREMENT_TOO_BIG = -4;
    private static final int ERROR_START_TOO_MANY_DIGITS = -5;
    private static final int ERROR_START_LESS_THAN_MIN = -6;
    private static final int ERROR_START_GREATER_THAN_MAX = -7;
    private static final int ERROR_MIN_TOO_MANY_DIGITS = -8;
    private static final int ERROR_MIN_GREATER_THAN_START = -9;
    private static final int ERROR_MIN_GREATER_THAN_MAX = -10;
    private static final int ERROR_MAX_TOO_MANY_DIGITS = -11;
    private static final int ERROR_MAX_LESS_THAN_START = -12;
    private static final int ERROR_MAX_LESS_THAN_MIN = -13;
    private static final int ERROR_CACHE_TOO_MANY_DIGITS = -14;
    private static final int ERROR_CACHE_TOO_SMALL = -15;
    private static final int ERROR_CACHE_TOO_BIG = -16;
    private static final int ERROR_MAX_REQD_FOR_ASCENDING_CYCLE = -17;
    private static final BigInteger MAX27 = BigInteger.valueOf(10L).pow(27);
    private static final BigInteger MIN26 = BigInteger.valueOf(10L).pow(26).negate();
    private static final BigInteger DIGITS28 = BigInteger.valueOf(10L).pow(28).subtract(BigInteger.ONE);

    public AbstractIncrementerValidator(DBObjectProvider prov) {
        super(prov);
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection retval = super.listAlwaysValidProperties();
        retval.add("orderFlag");
        retval.add("cycleFlag");
        return retval;
    }

    private String formatBigInteger(BigInteger value, BigInteger defaultedValue) {
        String result = defaultedValue.toString();
        if (null == value) {
            result = MessageFormat.format(APIBundle.get((String)"SEQUENCE_DEFAULT"), result);
        }
        return result;
    }

    private boolean tooBig(BigInteger val) {
        return val.abs().compareTo(DIGITS28) > 0;
    }

    private BigInteger getIncrement(BigInteger increment) {
        BigInteger retval = BigInteger.ONE;
        if (increment != null && !increment.equals(BigInteger.ZERO)) {
            retval = increment;
        }
        return retval;
    }

    private BigInteger getMaxValue(BigInteger incr, BigInteger maxValue) {
        BigInteger max = MAX27;
        if (null != maxValue) {
            max = maxValue;
        } else if (incr.signum() < 0) {
            max = BigInteger.ONE.negate();
        }
        return max;
    }

    private BigInteger getMinValue(BigInteger incr, BigInteger minValue) {
        BigInteger min = BigInteger.ONE;
        if (null != minValue) {
            min = minValue;
        } else if (incr.signum() < 0) {
            min = MIN26;
        }
        return min;
    }

    protected void validateIncrement(T original, T seq) throws ValidationException {
        BigInteger seqIncr = seq.getIncrementBy();
        BigInteger seqMin = seq.getMinValue();
        BigInteger seqMax = seq.getMaxValue();
        int v = this.validateIncrement(seqIncr, seqMin, seqMax);
        switch (v) {
            case -3: {
                throw new ValidationException(seq, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_INCREMENT_TOO_MANY_DIGITS"), seq.getName()));
            }
            case -2: {
                throw new ValidationException(seq, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_ZERO_INCREMENT"), seq.getName()));
            }
            case -4: {
                BigInteger incr = this.getIncrement(seqIncr);
                BigInteger min = this.getMinValue(incr, seqMin);
                BigInteger max = this.getMaxValue(incr, seqMax);
                throw new ValidationException(seq, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_INCREMENT_TOO_BIG"), this.formatBigInteger(seqIncr, incr), this.formatBigInteger(seqMin, min), this.formatBigInteger(seqMax, max)));
            }
        }
        if (1 != v) {
            // empty if block
        }
    }

    private int validateIncrement(BigInteger increment, BigInteger minValue, BigInteger maxValue) {
        int result = 1;
        if (null != increment) {
            if (increment.equals(BigInteger.ZERO)) {
                result = -2;
            } else if (this.tooBig(increment)) {
                result = -3;
            } else {
                BigInteger incr = increment;
                BigInteger max = this.getMaxValue(incr, maxValue);
                BigInteger min = this.getMinValue(incr, minValue);
                if (incr.abs().compareTo(max.subtract(min).abs()) >= 0) {
                    result = -4;
                }
            }
        }
        return result;
    }

    protected void validateStartWith(T original, T seq) throws ValidationException {
        BigInteger seqIncr = seq.getIncrementBy();
        BigInteger incr = this.getIncrement(seqIncr);
        BigInteger seqStart = seq.getStartWith();
        BigInteger seqMin = seq.getMinValue();
        BigInteger seqMax = seq.getMaxValue();
        int v = this.validateStartWith(seqStart, seqIncr, seqMin, seqMax);
        switch (v) {
            case -5: {
                throw new ValidationException(seq, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_START_TOO_MANY_DIGITS"), seq.getName()));
            }
            case -6: {
                throw new ValidationException(seq, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_START_LESS_THAN_MIN"), seqStart, this.formatBigInteger(seqMin, this.getMinValue(incr, seqMin))));
            }
            case -7: {
                String start = seqStart.toString();
                throw new ValidationException(seq, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_START_GREATER_THAN_MAX"), start, this.formatBigInteger(seqMax, this.getMaxValue(incr, seqMax))));
            }
        }
        if (1 != v) {
            // empty if block
        }
    }

    private int validateStartWith(BigInteger startWith, BigInteger increment, BigInteger minValue, BigInteger maxValue) throws ValidationException {
        int result = 1;
        if (null != startWith) {
            if (this.tooBig(startWith)) {
                result = -5;
            } else {
                BigInteger incr = this.getIncrement(increment);
                BigInteger start = startWith;
                if (incr.signum() > 0) {
                    BigInteger min = this.getMinValue(incr, minValue);
                    if (start.compareTo(min) < 0) {
                        result = -6;
                    }
                } else {
                    BigInteger max = this.getMaxValue(incr, maxValue);
                    if (start.compareTo(max) > 0) {
                        result = -7;
                    }
                }
            }
        }
        return result;
    }

    protected void validateMinValue(T original, T seq) throws ValidationException {
        BigInteger seqStart = seq.getStartWith();
        BigInteger seqMin = seq.getMinValue();
        BigInteger seqMax = seq.getMaxValue();
        int v = this.validateMinValue(seqMin, seqStart, seqMax);
        switch (v) {
            case -8: {
                throw new ValidationException(seq, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_MIN_TOO_MANY_DIGITS"), seq.getName()));
            }
            case -9: {
                throw new ValidationException(seq, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_MIN_GREATER_THAN_START"), seq.getMinValue(), seq.getStartWith()));
            }
            case -10: {
                throw new ValidationException(seq, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_MIN_GREATER_THAN_MAX"), seq.getMinValue(), seq.getMaxValue()));
            }
        }
        if (1 != v) {
            // empty if block
        }
    }

    private int validateMinValue(BigInteger minValue, BigInteger startWith, BigInteger maxValue) throws ValidationException {
        int result = 1;
        if (null != minValue) {
            if (this.tooBig(minValue)) {
                result = -8;
            } else {
                if (null != startWith && minValue.compareTo(startWith) > 0) {
                    result = -9;
                }
                if (null != maxValue && minValue.compareTo(maxValue) > 0) {
                    result = -10;
                }
            }
        }
        return result;
    }

    protected void validateMaxValue(T original, T seq) throws ValidationException {
        BigInteger seqStart = seq.getStartWith();
        BigInteger seqMin = seq.getMinValue();
        BigInteger seqMax = seq.getMaxValue();
        BigInteger seqIncr = seq.getIncrementBy();
        Boolean seqCycle = seq.getCycleFlag();
        int v = this.validateMaxValue(seqMax, seqStart, seqMin, seqIncr, seqCycle);
        switch (v) {
            case -11: {
                throw new ValidationException(seq, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_MAX_TOO_MANY_DIGITS"), seq.getName()));
            }
            case -12: {
                throw new ValidationException(seq, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_MAX_LESS_THAN_START"), seq.getMaxValue(), seq.getStartWith()));
            }
            case -13: {
                throw new ValidationException(seq, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_MAX_LESS_THAN_MIN"), seq.getMaxValue(), seq.getMinValue()));
            }
            case -17: {
                throw new ValidationException(seq, APIBundle.get((String)"SEQUENCE_ERROR_ASC_CYCLIC_NO_MAXVALUE"));
            }
        }
        if (1 != v) {
            // empty if block
        }
    }

    private int validateMaxValue(BigInteger maxValue, BigInteger startWith, BigInteger minValue, BigInteger increment, Boolean cycle) throws ValidationException {
        int result = 1;
        BigInteger incr = this.getIncrement(increment);
        if (null != cycle && cycle.equals(Boolean.TRUE) && incr.signum() > 0 && maxValue == null) {
            result = -17;
        } else if (null != maxValue) {
            if (this.tooBig(maxValue)) {
                result = -11;
            } else {
                if (null != startWith && maxValue.compareTo(startWith) < 0) {
                    result = -12;
                }
                if (null != minValue && maxValue.compareTo(minValue) <= 0) {
                    result = -13;
                }
            }
        }
        return result;
    }

    protected void validateCache(T original, T seq) throws ValidationException {
        BigInteger seqIncr = seq.getIncrementBy();
        BigInteger seqCache = seq.getCacheSize();
        BigInteger seqMin = seq.getMinValue();
        BigInteger seqMax = seq.getMaxValue();
        Boolean seqCycle = seq.getCycleFlag();
        Boolean seqCacheFlag = seq.getCacheFlag();
        boolean usedDefaultCacheSize = false;
        if (seqCacheFlag == null || !seqCacheFlag.equals(Boolean.FALSE)) {
            if (seqCacheFlag == null && seqCache == null) {
                seqCache = BigInteger.valueOf(20L);
                usedDefaultCacheSize = true;
            }
            if (seqCache == null) {
                throw new ValidationException(seq, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_CACHE_TOO_SMALL"), "", seq.getName()));
            }
            int v = this.validateCache(seqCache, seqIncr, seqMin, seqMax, seqCycle);
            switch (v) {
                case -14: {
                    throw new ValidationException(seq, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_CACHE_TOO_MANY_DIGITS"), seq.getName()));
                }
                case -15: {
                    throw new ValidationException(seq, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_CACHE_TOO_SMALL"), seqCache.toString()));
                }
                case -16: {
                    BigInteger maxCache = this.maxCacheSize(seqIncr, seqMin, seqMax);
                    if (usedDefaultCacheSize) {
                        throw new ValidationException(seq, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_DFLT_CACHE_TOO_BIG"), maxCache.toString()));
                    }
                    throw new ValidationException(seq, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_CACHE_TOO_BIG"), seqCache.toString(), maxCache.toString()));
                }
            }
            if (1 != v) {
                // empty if block
            }
        }
    }

    private int validateCache(BigInteger cache, BigInteger increment, BigInteger minValue, BigInteger maxValue, Boolean cycle) throws ValidationException {
        int result = 1;
        if (null != cache) {
            BigInteger maxCache;
            if (this.tooBig(cache)) {
                result = -14;
            } else if (cache.compareTo(BigInteger.valueOf(2L)) < 0) {
                result = -15;
            } else if (null != cycle && cycle.equals(Boolean.TRUE) && cache.compareTo(maxCache = this.maxCacheSize(increment, minValue, maxValue)) > 0) {
                result = -16;
            }
        }
        return result;
    }

    private BigInteger maxCacheSize(BigInteger increment, BigInteger minValue, BigInteger maxValue) {
        BigInteger incr = this.getIncrement(increment);
        BigInteger max = this.getMaxValue(incr, maxValue);
        BigInteger min = this.getMinValue(incr, minValue);
        BigInteger[] dr = max.subtract(min).abs().divideAndRemainder(incr.abs());
        BigInteger maxCache = dr[0];
        if (dr[1].signum() > 0) {
            maxCache = maxCache.add(BigInteger.ONE);
        }
        return maxCache;
    }
}

