/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sybase;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.javatools.db.BaseDatabaseCreator;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.jdbc.JdbcDatabaseDescriptor;
import oracle.javatools.db.sybase.AdaptiveServerDatabaseImpl;
import oracle.javatools.db.sybase.AdaptiveServerEnterprise15DatabaseImpl;
import oracle.javatools.db.sybase.AdaptiveServerEnterprise15Descriptor;
import oracle.javatools.db.sybase.AdaptiveServerEnterpriseDatabaseImpl;
import oracle.javatools.db.sybase.AdaptiveServerEnterpriseDescriptor;
import oracle.javatools.db.sybase.anywhere.AdaptiveServerAnywhereDatabase;
import oracle.javatools.db.sybase.anywhere.AdaptiveServerAnywhereDatabaseImpl;
import oracle.javatools.db.sybase.anywhere.AdaptiveServerAnywhereDescriptor;

public class AdaptiveServerDatabaseFactory
extends BaseDatabaseCreator {
    protected Database createDatabaseImpl(String connStore, String connName, Connection conn) {
        AdaptiveServerDatabaseImpl retval = null;
        if (this.isAnywhere(conn)) {
            retval = new AdaptiveServerAnywhereDatabaseImpl(connStore, connName, conn);
        } else {
            int t = this.getEnterpriseVersion(conn);
            switch (t) {
                case 150: {
                    retval = new AdaptiveServerEnterprise15DatabaseImpl(connStore, connName, conn);
                    break;
                }
                case 120: {
                    retval = new AdaptiveServerEnterpriseDatabaseImpl(connStore, connName, conn);
                }
            }
        }
        return retval;
    }

    private boolean isAnywhere(Connection conn) {
        if (conn != null) {
            try {
                DatabaseMetaData dmd = conn.getMetaData();
                String driverName = dmd.getDriverName();
                String dbName = dmd.getDatabaseProductName();
                if (driverName.indexOf("Sybase") > -1 && dbName.indexOf("Anywhere") > -1) {
                    return true;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return false;
    }

    private int getEnterpriseVersion(Connection conn) {
        int retval;
        block7: {
            retval = -1;
            if (conn != null) {
                try {
                    DatabaseMetaData dmd = conn.getMetaData();
                    String driverName = dmd.getDriverName();
                    String dbName = dmd.getDatabaseProductName();
                    if (driverName.indexOf("Sybase") > -1) {
                        int ver = dmd.getDatabaseMajorVersion();
                        retval = ver >= 15 ? 150 : 120;
                        break block7;
                    }
                    if (dbName.indexOf("Adaptive Server Enterprise") <= -1) break block7;
                    retval = 120;
                    try {
                        String verS;
                        int ver;
                        String v = dmd.getDatabaseProductVersion();
                        Pattern pattern = Pattern.compile("Adaptive Server Enterprise/(\\d+).*");
                        Matcher matcher = pattern.matcher(v);
                        if (matcher.matches() && (ver = Integer.parseInt(verS = matcher.group(1))) >= 15) {
                            retval = 150;
                        }
                    }
                    catch (Exception exception) {}
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        return retval;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class providerClass) {
        JdbcDatabaseDescriptor retval = null;
        if (AdaptiveServerAnywhereDatabase.class.isAssignableFrom(providerClass)) {
            retval = new AdaptiveServerAnywhereDescriptor(providerClass);
        } else if (AdaptiveServerEnterprise15DatabaseImpl.class.isAssignableFrom(providerClass)) {
            retval = new AdaptiveServerEnterprise15Descriptor(providerClass);
        } else if (AdaptiveServerEnterpriseDatabaseImpl.class.isAssignableFrom(providerClass)) {
            retval = new AdaptiveServerEnterpriseDescriptor(providerClass);
        }
        return retval;
    }
}

