/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sqlite;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.ddl.TokenContext;
import oracle.javatools.db.ddl.TokenGenerator;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.token.Token;

public class SQLiteDDLSupport {
    private final Map<String, TokenGenerator> m_globals = new TreeMap<String, TokenGenerator>();

    public SQLiteDDLSupport() {
        this.m_globals.put("handleTrgEvents", new TriggerEventsListGenerator());
        this.m_globals.put("getSyntaxFromSource", new SyntaxFromSourceGenerator());
        this.m_globals.put("codeExists", new CodeExistsTokenGenerator());
    }

    public Map<String, TokenGenerator> getGlobalTokenGenerators() {
        return Collections.unmodifiableMap(this.m_globals);
    }

    public static SQLiteDDLSupport getInstance() {
        DBCore core = DBCore.getInstance();
        SQLiteDDLSupport retval = (SQLiteDDLSupport)core.get(SQLiteDDLSupport.class);
        if (retval == null) {
            retval = new SQLiteDDLSupport();
            core.put((Object)retval);
        }
        return retval;
    }

    private static final class CodeExistsTokenGenerator
    extends TokenGenerator {
        public static final String TOKEN = "codeExists";

        private CodeExistsTokenGenerator() {
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            if (context.getObject() instanceof Trigger) {
                Trigger trg = (Trigger)context.getObject();
                String code = trg.getCode();
                return code != null && !code.equals("");
            }
            return false;
        }
    }

    private static final class SyntaxFromSourceGenerator
    extends TokenGenerator {
        public static final String TOKEN = "getSyntaxFromSource";
        public static final String ALTER = "ALTER";

        private SyntaxFromSourceGenerator() {
        }

        public void generateToken(TokenContext context) {
            PlSqlToken tk;
            PlSqlSearch search;
            String source;
            if (context.getObject() instanceof Trigger && (source = this.getSource(context)) != null && !source.equals("") && (search = new PlSqlSearch("[create [or replace]] ? [body] ?. <sourceAfterName {?}...>")).matches(tk = PlSqlTokenizer.tokenize((String)source, (String[])new String[0]))) {
                PlSqlToken startTk = search.getNamedMatchStartToken("sourceAfterName");
                PlSqlToken endTk = search.getNamedMatchEndToken("sourceAfterName");
                String buf = (startTk = (PlSqlToken)((PlSqlToken)startTk.getPrevCodeToken()).getNextToken()).getSource(false, (Token)endTk);
                if (buf.startsWith(" ")) {
                    buf = buf.substring(1);
                }
                context.append((Object)buf);
            }
        }

        public Object evaluateToken(TokenContext context) {
            if (context.getObject() instanceof Trigger) {
                String source = this.getSource(context);
                return source != null && !source.equals("");
            }
            return false;
        }

        private String getSource(TokenContext context) {
            String source = null;
            Trigger pls = (Trigger)context.getObject();
            source = pls.getSource();
            return source;
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Collections.singleton("source");
        }
    }

    private static final class TriggerEventsListGenerator
    extends TokenGenerator {
        public static final String TOKEN = "handleTrgEvents";

        private TriggerEventsListGenerator() {
        }

        public void generateToken(TokenContext context) {
            Trigger trg;
            boolean isFirst = true;
            if (context.getObject() instanceof Trigger && (trg = (Trigger)context.getObject()).getEvents() != null && trg.getEvents().length > 0) {
                for (String event : trg.getEvents()) {
                    if (!isFirst) {
                        context.append((Object)" OR ");
                    }
                    context.append((Object)event);
                    DBObjectID[] colIDs = trg.getColumnIDs();
                    if ("UPDATE".equals(event) && colIDs != null) {
                        for (int i = 0; i < colIDs.length; ++i) {
                            context.append((Object)(i == 0 ? " OF " : ","));
                            context.append((Object)DBUtil.getDBObjectName((DBObjectID)colIDs[i]));
                        }
                    }
                    isFirst = false;
                }
            }
        }

        public Object evaluateToken(TokenContext context) {
            return true;
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Arrays.asList("events".toString());
        }
    }
}

