/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql.parser;

import java.util.Arrays;
import java.util.List;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.property.DerivedPropertyBuilder;

public class PlSqlReferenceBuilder
extends DerivedPropertyBuilder<PlSqlReference> {
    public PlSqlReferenceBuilder(AbstractDBObjectProvider pro) {
        super(pro, "PlSqlReference");
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"references"})
    public void buildReferences(PlSqlReference ref) {
        String[] names = ref.getReferenceNames();
        DBObject context = ref.getParent();
        if (context != null && names != null && names.length > 0) {
            List<DBObjectID> ids = PlSqlUtil.findReferences(Arrays.asList(names), (DBObjectProvider)this.getProvider(), context);
            ref.setReferences(ids.toArray(new DBObjectID[ids.size()]));
        }
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"dataTypeUsage"})
    public void buildTypeUsage(PlSqlReference ref) {
        String dtuString = ref.getDataTypeUsageSource();
        if (dtuString != null) {
            DataType dt;
            DataTypeUsage dtu;
            AbstractDBObjectProvider pro = this.getProvider();
            PlSqlSourceObject so = (PlSqlSourceObject)DBUtil.findParentOfType((DBObject)ref, PlSqlSourceObject.class);
            Schema schema = DBUtil.getSchema((DBObject)so);
            if (schema == null) {
                try {
                    schema = pro.getDefaultSchema();
                }
                catch (DBException e) {
                    schema = null;
                }
            }
            if ((dtu = DataTypeHelper.getDataTypeUsageForString((DBObjectProvider)pro, (Schema)schema, (String)dtuString)) == null && (dt = pro.getDataType(dtuString)) != null) {
                dtu = dt.createDefaultUsage();
            }
            ref.setDataTypeUsage(dtu);
        }
    }
}

