/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.StackParser;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.token.Token;
import oracle.javatools.util.ModelUtil;

class PlSqlParserHelper {
    PlSqlParserHelper() {
    }

    static final List<PlSqlParser.Issue> getIssues(PlSqlSourceObject so, DBObjectProvider pro) throws CancelledException {
        StringBuilder sb = new StringBuilder();
        PlSqlParser parser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)so, (DBObjectProvider)pro);
        if (parser != null && !parser.isWrapped() && ModelUtil.hasLength((String)so.getSource())) {
            PlSqlToken firstTk = parser.getTokenAtOffset(0);
            PlSqlToken lastTk = parser.getTokenAtOffset(parser.getEndOffsetOfObject());
            if (firstTk != null && lastTk != null) {
                sb.append(firstTk.getSource(false, (Token)lastTk));
                if (!firstTk.isCode()) {
                    firstTk = (PlSqlToken)firstTk.getNextCodeToken();
                }
                if (!firstTk.matches("CREATE")) {
                    sb.insert(0, "CREATE\n");
                }
                if (!lastTk.isCode()) {
                    lastTk = (PlSqlToken)lastTk.getPrevCodeToken();
                }
                if (!lastTk.matches(";") && !(so instanceof Type)) {
                    sb.append(";");
                }
            }
        }
        return PlSqlParserHelper.getIssues(sb.toString());
    }

    static final List<PlSqlParser.Issue> getIssues(String text) {
        if (ModelUtil.hasLength((String)text)) {
            List src = LexerToken.parse((String)text);
            LazyNode root = StackParser.getInstance().parse(src);
            return PlSqlParserHelper.getIssues(src, root, text);
        }
        return Collections.emptyList();
    }

    static final List<PlSqlParser.Issue> getIssues(List<LexerToken> src, LazyNode root, String text) {
        ArrayList<PlSqlParser.Issue> ret = new ArrayList<PlSqlParser.Issue>();
        try {
            int pos = LexerToken.scanner2parserOffset(src, (int)text.length());
            if (root != null) {
                for (ParseNode n : root.ancestors(pos)) {
                    if (!(n instanceof LazyNode)) continue;
                    LazyNode node = (LazyNode)n;
                    if (node.to - node.from < 4 || !node.isDDL(null) && !node.isDML(null) && !node.isProcedure() && !node.isStmt(root) && node != root || node == root && node.from + 1000 < node.to || node.from + 2000 < node.to) continue;
                    List fragment = node.getSrcFragment();
                    SqlEarley earley = SqlEarley.getInstance();
                    Matrix matrix = new Matrix((Parser)earley);
                    earley.parse(fragment, matrix);
                    LexerToken startToken = src.get(n.from);
                    SyntaxError err = SyntaxError.checkSyntax((String)text.substring(startToken.begin, src.get((int)(n.to - 1)).end), (String[])new String[]{"sql_statements", "subprg_body"}, (List)fragment, (Earley)earley, (Matrix)matrix);
                    if (err == null) continue;
                    ++err.line;
                    int begin = startToken.begin + err.end;
                    int end = begin + 3;
                    if (text.length() < end) {
                        end = text.length();
                    }
                    ret.add(new IssueImpl(begin, end, PlSqlParser.Severity.ERROR, err.getMessage()));
                }
            }
        }
        catch (Exception e) {
            ret.add(new IssueImpl(0, 1, PlSqlParser.Severity.ERROR, e.getMessage()));
        }
        return ret;
    }

    private static class IssueImpl
    implements PlSqlParser.Issue {
        private final int m_start;
        private final int m_end;
        private final PlSqlParser.Severity m_sev;
        private final String m_mess;

        private IssueImpl(int start, int end, PlSqlParser.Severity sev, String message) {
            this.m_start = start;
            this.m_end = end;
            this.m_sev = sev;
            this.m_mess = message;
        }

        public int getStartOffset() {
            return this.m_start;
        }

        public int getEndOffset() {
            return this.m_end;
        }

        public PlSqlParser.Severity getSeverity() {
            return this.m_sev;
        }

        public String getMessage() {
            return this.m_mess;
        }
    }
}

