/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql.parser;

import java.util.ArrayList;
import java.util.concurrent.Executor;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlCodeFragment;
import oracle.javatools.db.plsql.PlSqlDatatype;
import oracle.javatools.db.plsql.PlSqlParameter;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlStatement;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.PlSqlVariable;
import oracle.javatools.db.plsql.parser.AbstractPlSqlBuilder;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.token.Token;

public class PlSqlFragmentBuilder<T extends PlSqlCodeFragment>
extends AbstractPlSqlBuilder<T> {
    public PlSqlFragmentBuilder(AbstractDBObjectProvider pro, String string) {
        super(pro, string);
    }

    @Override
    public PlSqlParser getParser(T frag) throws CancelledException {
        PlSqlParser ret = null;
        PlSqlSourceObject pso = this.getSourceObject((DBObjectPlSqlFragment)frag);
        if (pso != null) {
            ret = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)pso, (DBObjectProvider)this.getProvider());
        }
        return ret;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"source"}, derived=true)
    public boolean buildChildObjectProperties(T obj) throws DBException {
        PlSqlParser parser = this.getParser(obj);
        if (parser != null && obj.getStartOffset() != null) {
            if (obj instanceof PlSqlSubProgram) {
                this.buildPlSqlSubProgram((PlSqlSubProgram)obj, parser);
            } else if (obj instanceof PlSqlParameter) {
                this.buildPlSqlParameter((PlSqlParameter)obj, parser);
            } else if (obj instanceof PlSqlVariable) {
                this.buildPlSqlVariable((PlSqlVariable)obj, parser);
            } else if (obj instanceof PlSqlDatatype) {
                this.buildPlSqlDatatype((PlSqlDatatype)obj, parser);
            }
            boolean addChildren = false;
            Class<?> objClz = obj.getClass();
            if ("STATEMENT".equals(obj.getType()) && PlSqlStatement.Type.STATEMENT.equals((Object)((PlSqlStatement)obj).getStatementType())) {
                addChildren = false;
            } else {
                for (String prop : this.getBuiltProperties("propertyReferences")) {
                    Class propClz;
                    PropertyInfo info = PropertyHelper.findPropertyInfo(objClz, (String)prop, (DBObjectProvider)null);
                    if (info == null || !info.isDerived() || !(propClz = info.getPropertyClass()).isArray() || !DBObjectPlSqlFragment.class.isAssignableFrom(propClz.getComponentType()) || !DBUtil.needsBuilding(obj, (String)prop)) continue;
                    addChildren = true;
                    break;
                }
            }
            if (addChildren) {
                this.checkInterruptOrCancel((AbstractBuildableObject)obj);
                Object parseNode = parser.getParseNode(obj);
                if (parseNode != null) {
                    this.addChildren(parseNode, obj, parser);
                }
            }
        }
        return true;
    }

    protected Executor getPropertyExecutor(T object) {
        PlSqlSourceObject pso = this.getSourceObject((DBObjectPlSqlFragment)object);
        Executor retval = pso instanceof AbstractBuildableObject ? PlSqlFragmentBuilder.getPropertyExecutorForObject((AbstractBuildableObject)((AbstractBuildableObject)pso)) : super.getPropertyExecutor(object);
        return retval;
    }

    private void buildPlSqlVariable(PlSqlVariable var, PlSqlParser parser) throws CancelledException {
        PlSqlToken endTk;
        PlSqlSearch search = new PlSqlSearch("<var ?> [CONSTANT] <datatype ?%>");
        PlSqlToken startTk = parser.getTokenAtOffset(var.getStartOffset().intValue());
        if (search.matches(startTk, endTk = parser.getTokenAtOffset(var.getEndOffset().intValue()))) {
            startTk = search.getNamedMatchStartToken("datatype");
            endTk = search.getNamedMatchEndToken("datatype");
            PlSqlReference ref = this.findDataTypeReference(startTk, endTk, "1", parser);
            var.setDataTypeReference(ref);
            startTk = (PlSqlToken)endTk.getNextCodeToken();
            if (startTk.getStart() < var.getEndOffset()) {
                endTk = parser.getTokenAtOffset(var.getEndOffset().intValue());
                ArrayList<PlSqlToken> tokens = new ArrayList<PlSqlToken>();
                ArrayList<String> names = new ArrayList<String>();
                this.buildNameAndTokenLists(startTk, endTk, true, tokens, names, parser);
                if (!tokens.isEmpty()) {
                    int end = tokens.size() - 1;
                    this.buildReference(parser, (PlSqlCodeFragment)var, names, ((PlSqlToken)tokens.get(0)).getStart(), ((PlSqlToken)tokens.get(end)).getEnd(), true);
                }
            }
        }
    }

    private void buildPlSqlDatatype(PlSqlDatatype datatype, PlSqlParser parser) throws CancelledException {
        PlSqlSearch search = new PlSqlSearch("<type {TYPE|SUBTYPE}> <name ?> IS <structure ?>");
        PlSqlToken tk = parser.getTokenAtOffset(datatype.getStartOffset().intValue());
        if (search.matches(tk)) {
            PlSqlDatatype.Structure struct;
            datatype.setSubType(search.getNamedMatch("type").equals("SUBTYPE"));
            String name = this.getProvider().getInternalName(search.getNamedMatch("name"));
            try {
                struct = PlSqlDatatype.Structure.valueOf((String)search.getNamedMatch("structure"));
            }
            catch (Exception e) {
                struct = PlSqlDatatype.Structure.SCALAR;
            }
            datatype.setStructure(struct);
            tk = (PlSqlToken)tk.getNextCodeToken();
            if (struct != PlSqlDatatype.Structure.RECORD) {
                PlSqlToken endTk;
                tk = (PlSqlToken)tk.getNextCodeToken();
                if (struct == PlSqlDatatype.Structure.TABLE) {
                    tk = (PlSqlToken)tk.getNextCodeToken(2);
                } else if (struct == PlSqlDatatype.Structure.VARRAY) {
                    tk = (PlSqlToken)tk.getNextCodeToken(3);
                    Integer limit = null;
                    try {
                        limit = Integer.valueOf(tk.getSource());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    datatype.setLimit(limit);
                    tk = (PlSqlToken)tk.getNextCodeToken(2);
                }
                tk = (PlSqlToken)tk.getNextCodeToken();
                for (endTk = parser.getTokenAtOffset(datatype.getEndOffset().intValue()); endTk != tk && endTk.getType() == Token.Type.PUNCTUATION && !endTk.matches(")"); endTk = (PlSqlToken)endTk.getPrevCodeToken()) {
                }
                PlSqlReference ref = this.findDataTypeReference(tk, endTk, "baseTypeOffset", parser);
                datatype.addPropertyReference(ref);
                datatype.setBaseTypeOffset(ref.getStartOffset());
            }
        }
    }

    private PlSqlSourceObject getSourceObject(DBObjectPlSqlFragment frag) {
        PlSqlSourceObject ret = null;
        SchemaObject top = DBUtil.getSchemaObject((DBObject)frag);
        if (top instanceof PlSqlSourceObject) {
            ret = (PlSqlSourceObject)top;
        }
        return ret;
    }
}

