/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.math.BigInteger;
import java.util.Collection;
import oracle.javatools.db.AutoExtendProperties;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.ora.OracleTableProperties;
import oracle.javatools.db.ora.OracleTablespaceProperties;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;

public class OracleTablespacePropertiesValidator
extends AbstractChildDBObjectValidator<OracleTablespaceProperties> {
    private static Integer n1 = new Integer(1);

    public OracleTablespacePropertiesValidator(DBObjectProvider prov) {
        super(prov);
    }

    protected boolean canHaveEmptyName() {
        return true;
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection retval = super.listAlwaysValidProperties();
        retval.add("logging");
        retval.add("onlineStatus");
        return retval;
    }

    @DBObjectValidator.PropertyValidator(value={"minExtent"}, level=ValidationLevel.FULL)
    public void validateMinExtent(OracleTablespaceProperties original, OracleTablespaceProperties updated) throws ValidationException {
        Integer minExtent = updated.getMinExtent();
        if (minExtent != null && minExtent < 1) {
            throw new ValidationException((DBObject)updated, APIBundle.format((String)"STORAGE_PROPERTY_ERROR_TOO_SMALL", (Object[])new Object[]{"MINEXTENT", n1}));
        }
        OracleTablespaceProperties.ExtentManagementType extentMgmnt = updated.getExtentManagementType();
        if (minExtent != null && extentMgmnt != null && extentMgmnt != OracleTablespaceProperties.ExtentManagementType.DICTIONARY) {
            throw new ValidationException((DBObject)updated, APIBundle.get((String)"TABLESPACE_ERROR_MIN_EXTENT_NOT_DICT"));
        }
        this.validateNonNullableProperty((DBObject)original, (DBObject)updated, "minExtent");
    }

    @DBObjectValidator.PropertyValidator(value={"blockSize"}, level=ValidationLevel.FULL)
    public void validateBlockSize(OracleTablespaceProperties original, OracleTablespaceProperties updated) throws ValidationException {
        Integer blockSize = updated.getBlockSize();
        if (blockSize != null && blockSize < 1) {
            throw new ValidationException((DBObject)updated, APIBundle.format((String)"STORAGE_PROPERTY_ERROR_TOO_SMALL", (Object[])new Object[]{"MINEXTENT", n1}));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"forceLogging"}, level=ValidationLevel.FULL)
    public void validateForceLogging(OracleTablespaceProperties original, OracleTablespaceProperties updated) throws ValidationException {
        Tablespace tbsp;
        Tablespace.TablespaceType tbspType;
        boolean forceLogging = updated.isForceLogging();
        if (updated.getParent() instanceof Tablespace && forceLogging && (tbspType = (Tablespace.TablespaceType)(tbsp = (Tablespace)updated.getParent()).getProperty("TablespaceType")) != Tablespace.TablespaceType.PERMANENT) {
            throw new ValidationException((DBObject)updated, APIBundle.get((String)"TABLESPACE_ERROR_FORCE_LOG_NON_PERM"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"defaultTableCompression"}, level=ValidationLevel.FULL)
    public void validateDefaultTableCompression(OracleTablespaceProperties original, OracleTablespaceProperties updated) throws ValidationException {
        Tablespace tbsp;
        Tablespace.TablespaceType tbspType;
        OracleTableProperties.OracleTableCompression tabCompress = updated.getDefaultTableCompression();
        if (updated.getParent() instanceof Tablespace && tabCompress != null && (tbspType = (Tablespace.TablespaceType)(tbsp = (Tablespace)updated.getParent()).getProperty("TablespaceType")) == Tablespace.TablespaceType.TEMPORARY) {
            throw new ValidationException((DBObject)updated, APIBundle.get((String)"TABLESPACE_ERROR_DEF_COMPRESS_FOR_TEMP"));
        }
        OracleTablespaceProperties.ExtentManagementType extentMgmnt = updated.getExtentManagementType();
        if (tabCompress != null && tabCompress != OracleTableProperties.OracleTableCompression.COMPRESS && extentMgmnt == OracleTablespaceProperties.ExtentManagementType.DICTIONARY) {
            throw new ValidationException((DBObject)updated, APIBundle.get((String)"TABLESPACE_ERROR_DEF_COMPRESS_NON_DICT"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"autoAllocate"}, level=ValidationLevel.FULL)
    public void validateAutoAllocate(OracleTablespaceProperties original, OracleTablespaceProperties updated) throws ValidationException {
        Tablespace tbsp;
        Tablespace.TablespaceType tbspType;
        boolean autoAllocate = updated.isAutoAllocate();
        Integer minExtent = updated.getMinExtent();
        if (autoAllocate && minExtent != null) {
            throw new ValidationException((DBObject)updated, APIBundle.get((String)"TABLESPACE_ERROR_MIN_EXTENT_AUTOALLOCATE"));
        }
        if (updated.getParent() instanceof Tablespace && autoAllocate && (tbspType = (Tablespace.TablespaceType)(tbsp = (Tablespace)updated.getParent()).getProperty("TablespaceType")) == Tablespace.TablespaceType.TEMPORARY) {
            throw new ValidationException((DBObject)updated, APIBundle.get((String)"TABLESPACE_ERROR_AUTOALLOCATE_TEMP"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"uniformSize"}, level=ValidationLevel.FULL)
    public void validateUniformSize(OracleTablespaceProperties original, OracleTablespaceProperties updated) throws ValidationException {
        Tablespace tbsp;
        Tablespace.TablespaceType tbspType;
        BigInteger uniformSize = updated.getUniformSize();
        if (uniformSize != null && uniformSize.compareTo(BigInteger.ONE) < 0) {
            throw new ValidationException((DBObject)updated, APIBundle.format((String)"STORAGE_PROPERTY_ERROR_TOO_SMALL", (Object[])new Object[]{"UNIFORM SIZE", n1}));
        }
        if (updated.getParent() instanceof Tablespace && uniformSize != null && (tbspType = (Tablespace.TablespaceType)(tbsp = (Tablespace)updated.getParent()).getProperty("TablespaceType")) == Tablespace.TablespaceType.UNDO) {
            throw new ValidationException((DBObject)updated, APIBundle.get((String)"TABLESPACE_ERROR_UNIFORM_UNDO"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"extentManagementType"}, level=ValidationLevel.FULL)
    public void validateExtentManagement(OracleTablespaceProperties original, OracleTablespaceProperties updated) throws ValidationException {
        OracleTablespaceProperties.ExtentManagementType extentMgmnt = updated.getExtentManagementType();
        if (updated.getParent() instanceof Tablespace && extentMgmnt != null) {
            Tablespace tbsp = (Tablespace)updated.getParent();
            Tablespace.TablespaceType tbspType = (Tablespace.TablespaceType)tbsp.getProperty("TablespaceType");
            if (original != null && extentMgmnt != original.getExtentManagementType()) {
                throw new ValidationException((DBObject)updated, APIBundle.get((String)"TABLESPACE_ERROR_EXT_MGMNT_UPD"));
            }
            if (extentMgmnt == OracleTablespaceProperties.ExtentManagementType.DICTIONARY) {
                if (tbspType == Tablespace.TablespaceType.TEMPORARY) {
                    throw new ValidationException((DBObject)updated, APIBundle.get((String)"TABLESPACE_ERROR_TEMP_DICT"));
                }
                if (tbspType == Tablespace.TablespaceType.UNDO) {
                    throw new ValidationException((DBObject)updated, APIBundle.get((String)"TABLESPACE_ERROR_UNDO_DICT"));
                }
                if (tbsp.getFileType() == Tablespace.FileType.BIGFILE) {
                    throw new ValidationException((DBObject)updated, APIBundle.get((String)"TABLESPACE_ERROR_BIG_FILE_DICT"));
                }
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"segmentManagement"}, level=ValidationLevel.FULL)
    public void validateSegmentManagement(OracleTablespaceProperties original, OracleTablespaceProperties updated) throws ValidationException {
        Tablespace tbsp;
        Tablespace.TablespaceType tbspType;
        OracleTablespaceProperties.SegmentManagement segMgmnt = updated.getSegmentManagement();
        OracleTablespaceProperties.ExtentManagementType extentMgmnt = updated.getExtentManagementType();
        if (updated.getParent() instanceof Tablespace && extentMgmnt != null && segMgmnt == OracleTablespaceProperties.SegmentManagement.MANUAL && ((tbspType = (Tablespace.TablespaceType)(tbsp = (Tablespace)updated.getParent()).getProperty("TablespaceType")) != Tablespace.TablespaceType.PERMANENT && extentMgmnt != OracleTablespaceProperties.ExtentManagementType.LOCAL || tbsp.getFileType() == Tablespace.FileType.BIGFILE)) {
            throw new ValidationException((DBObject)updated, APIBundle.get((String)"TABLESPACE_ERROR_MAN_SEG_MGMNT"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"tablespaceGroup"}, level=ValidationLevel.FULL)
    public void validateTablespaceGroup(OracleTablespaceProperties original, OracleTablespaceProperties updated) throws ValidationException {
        Tablespace tbsp;
        Tablespace.TablespaceType tbspType;
        String tablespaceGroup = updated.getTablespaceGroup();
        if (updated.getParent() instanceof Tablespace && tablespaceGroup != null && (tbspType = (Tablespace.TablespaceType)(tbsp = (Tablespace)updated.getParent()).getProperty("TablespaceType")) != Tablespace.TablespaceType.TEMPORARY) {
            throw new ValidationException((DBObject)updated, APIBundle.get((String)"TABLESPACE_ERROR_TBSP_GRP_NON_TEMP"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"retention"}, level=ValidationLevel.FULL)
    public void validateRetention(OracleTablespaceProperties original, OracleTablespaceProperties updated) throws ValidationException {
        Tablespace tbsp;
        Tablespace.TablespaceType tbspType;
        OracleTablespaceProperties.RetentionType retention = updated.getRetention();
        if (updated.getParent() instanceof Tablespace && retention != null && (tbspType = (Tablespace.TablespaceType)(tbsp = (Tablespace)updated.getParent()).getProperty("TablespaceType")) != Tablespace.TablespaceType.UNDO) {
            throw new ValidationException((DBObject)updated, APIBundle.get((String)"TABLESPACE_ERROR_RETENT_NON_UNDO"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"autoExtendProperties"}, level=ValidationLevel.FULL)
    public void validateAutoExtend(OracleTablespaceProperties original, OracleTablespaceProperties updated) throws ValidationException {
        Tablespace tbsp;
        AutoExtendProperties autoExtendProps = updated.getAutoExtendProperties();
        if (updated.getParent() instanceof Tablespace && autoExtendProps != null && (tbsp = (Tablespace)updated.getParent()).getFileType() != Tablespace.FileType.BIGFILE) {
            throw new ValidationException((DBObject)updated, APIBundle.get((String)"TABLESPACE_ERROR_AUTOEXTEND_SMALLFILE"));
        }
    }
}

