/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Index;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.LocalIndexPartitionHelper;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.ora.OracleIndexOrganizedTableProperties;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.ReferencePartitionHelper;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.refactoring.CascadeAction;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.MissingValidatorException;
import oracle.javatools.db.validators.TableValidator;
import oracle.javatools.db.validators.ValidationContext;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;

public class OracleTableValidator<T extends Table>
extends TableValidator<T> {
    public OracleTableValidator(DBObjectProvider prov) {
        super(prov);
    }

    @Override
    protected boolean isColumnRenameCascadableToVirtualExpression() {
        return !(this.getProvider() instanceof OracleDatabase);
    }

    @DBObjectValidator.PropertyValidator(value={"OracleIndexOrganizedTableProperties"})
    public void validateIOTProperties(T original, T updated) throws ValidationException {
        OracleIndexOrganizedTableProperties properties;
        Table.TableType tableType = (Table.TableType)updated.getProperty("TableType");
        if (tableType == Table.TableType.INDEX_ORGANIZED && (properties = (OracleIndexOrganizedTableProperties)updated.getProperty("OracleIndexOrganizedTableProperties")) != null) {
            try {
                this.getProvider().validateObject((DBObject)properties);
            }
            catch (MissingValidatorException mve) {
                throw new ValidationException(updated, APIBundle.get((String)"IOT_PROPERTY_NOT_SUPPORTED"));
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"OracleExternalTableProperties"})
    public void validateExternalTableProperties(ValidationContext<T> context) throws ValidationException {
        Table updated = (Table)context.getUpdatedObject();
        Table.TableType tableType = (Table.TableType)updated.getProperty("TableType");
        if (tableType == Table.TableType.EXTERNAL) {
            OracleExternalTableProperties properties = (OracleExternalTableProperties)updated.getProperty("OracleExternalTableProperties");
            if (properties == null) {
                ValidationException ve = new ValidationException((DBObject)updated, Property.createPath((String[])new String[]{"OracleExternalTableProperties", "defaultDirectory"}), APIBundle.get((String)"EXTERNAL_TABLE_PROPERTY_MISSING_DEFAULT_DIR"));
                ve.setNextException((DBException)((Object)new ValidationException((DBObject)updated, Property.createPath((String[])new String[]{"OracleExternalTableProperties", "locationSpecifiers"}), APIBundle.get((String)"EXTERNAL_TABLE_PROPERTY_MISSING_LOCATION"))));
                throw ve;
            }
            this.validateOwnedObjects(context.getLevel(), new DBObject[]{properties});
        }
    }

    @DBObjectValidator.PropertyValidator(value={"NESTED TABLE"}, level=ValidationLevel.FULL)
    public void validateNested(T original, T table) throws ValidationException {
        Table.TableType tableType;
        boolean isNested = Boolean.TRUE.equals(table.getProperty("NESTED TABLE"));
        if (isNested && (tableType = (Table.TableType)table.getProperty("TableType")) == Table.TableType.EXTERNAL) {
            throw new ValidationException(table, APIBundle.format((String)"TABLE_PROPERTY_ERROR_INVALID_COMBINATION", (Object[])new Object[]{APIBundle.get((String)"TABLE_TYPE_EXTERNAL"), APIBundle.get((String)"TABLE_PROPERTY_NESTED")}));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"PARTITIONED TABLE"}, level=ValidationLevel.FULL)
    public void validatePartitioned(T original, T updated) throws ValidationException {
        boolean isPartitioned = Boolean.TRUE.equals(updated.getProperty("PARTITIONED TABLE"));
        if (isPartitioned) {
            Table.TableType tableType = (Table.TableType)updated.getProperty("TableType");
            if (tableType == Table.TableType.SESSION_TEMP || tableType == Table.TableType.TRANSACTION_TEMP) {
                throw new ValidationException(updated, APIBundle.format((String)"TABLE_PROPERTY_ERROR_INVALID_PROPERTY", (Object[])new Object[]{APIBundle.get((String)"TABLE_TYPE_TEMPORARY"), APIBundle.get((String)"TABLE_PROPERTY_PARTITIONS")}));
            }
            if (tableType == Table.TableType.EXTERNAL) {
                throw new ValidationException(updated, APIBundle.format((String)"TABLE_PROPERTY_ERROR_INVALID_COMBINATION", (Object[])new Object[]{APIBundle.get((String)"TABLE_TYPE_EXTERNAL"), APIBundle.get((String)"TABLE_PROPERTY_PARTITIONED")}));
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"OracleTablePartitions"})
    public void validatePartitions(ValidationContext<T> context) throws ValidationException {
        OracleTablePartitions partitions;
        Table updated = (Table)context.getUpdatedObject();
        boolean isPartitioned = Boolean.TRUE.equals(updated.getProperty("PARTITIONED TABLE"));
        if (isPartitioned && (partitions = (OracleTablePartitions)updated.getProperty("OracleTablePartitions")) != null) {
            try {
                this.validateOwnedObjects(context.getLevel(), new DBObject[]{partitions});
            }
            catch (MissingValidatorException mve) {
                throw new ValidationException((DBObject)updated, APIBundle.get((String)"TABLE_PARTITION_NOT_SUPPORTED"));
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"Comment"}, level=ValidationLevel.FULL)
    public void validateComment(T original, T updated) throws ValidationException {
        if (updated.getProperty("Comment") != null && updated.getProperty("TableType") == Table.TableType.EXTERNAL) {
            throw new ValidationException(updated, "Comment", APIBundle.format((String)"TABLE_PROPERTY_ERROR_INVALID_PROPERTY", (Object[])new Object[]{APIBundle.get((String)"TABLE_TYPE_EXTERNAL"), APIBundle.get((String)"TABLE_PROPERTY_COMMENTS")}));
        }
        super.validateComment(original, updated);
    }

    @Override
    protected boolean supportsOtherTableTypes() {
        return true;
    }

    @Override
    @DBObjectValidator.PropertyValidator(value={"columns"})
    public void validateColumns(ValidationContext<T> context) throws ValidationException {
        Table updated = (Table)context.getUpdatedObject();
        if (context.getLevel() == ValidationLevel.FULL) {
            Column[] cols = updated.getColumns();
            int realColCount = 0;
            if (cols != null && cols.length > 0) {
                for (Column col : cols) {
                    if (col.getVirtualExpressionSource() != null) continue;
                    ++realColCount;
                    break;
                }
            }
            if (realColCount == 0) {
                throw new ValidationException((DBObject)updated, APIBundle.format((String)"COLUMN_ERROR_NEED_REAL_COLUMN", (Object[])new Object[]{updated.getName()}));
            }
        }
        super.validateColumns(context);
    }

    @Override
    protected boolean enforceOneColumnExists(ValidationContext<T> context) {
        return super.enforceOneColumnExists(context) && (this.getProvider().getDescriptor().getDatabaseVersion() <= 120 || ((Table)context.getUpdatedObject()).getProperty("TableType") != Table.TableType.EXTERNAL);
    }

    @Override
    @DBObjectValidator.PropertyValidator(value={"constraints"})
    public void validateConstraints(ValidationContext<T> context) throws ValidationException {
        super.validateConstraints(context);
        if (context.getLevel() == ValidationLevel.FULL) {
            Table updated = (Table)context.getUpdatedObject();
            Constraint[] cons = updated.getConstraints();
            Table.TableType tableType = (Table.TableType)updated.getProperty("TableType");
            if (tableType == Table.TableType.INDEX_ORGANIZED) {
                PKConstraint pk = PKConstraint.getPrimaryKey((Relation)updated);
                if (pk == null) {
                    throw new ValidationException((DBObject)updated, "constraints", APIBundle.get((String)"IOT_PROPERTY_ERROR_MISSING_PRIMARY_KEY"));
                }
            } else if (tableType == Table.TableType.SESSION_TEMP || tableType == Table.TableType.TRANSACTION_TEMP) {
                for (Constraint constraint : cons) {
                    if (!(constraint instanceof FKConstraint)) continue;
                    throw new ValidationException((DBObject)updated, APIBundle.format((String)"TABLE_PROPERTY_ERROR_INVALID_PROPERTY", (Object[])new Object[]{APIBundle.get((String)"TABLE_TYPE_TEMPORARY"), APIBundle.get((String)"TABLE_PROPERTY_FKS")}));
                }
            } else if (tableType == Table.TableType.EXTERNAL && cons.length != 0) {
                throw new ValidationException((DBObject)updated, "constraints", APIBundle.format((String)"TABLE_PROPERTY_ERROR_INVALID_PROPERTY", (Object[])new Object[]{APIBundle.get((String)"TABLE_TYPE_EXTERNAL"), APIBundle.get((String)"TABLE_PROPERTY_CONSTRAINTS")}));
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"indexes"})
    public void validateIndexes(ValidationContext<T> context) throws ValidationException {
        Table upd = (Table)context.getUpdatedObject();
        Index[] idxs = upd.getIndexes();
        if (context.getLevel() == ValidationLevel.FULL && upd.getProperty("TableType") == Table.TableType.EXTERNAL && idxs.length != 0) {
            throw new ValidationException((DBObject)upd, "indexes", APIBundle.format((String)"TABLE_PROPERTY_ERROR_INVALID_PROPERTY", (Object[])new Object[]{APIBundle.get((String)"TABLE_TYPE_EXTERNAL"), APIBundle.get((String)"TABLE_PROPERTY_INDEXES")}));
        }
        this.validateOwnedObjects(context.getLevel(), (DBObject[])idxs);
    }

    @Override
    protected CascadeAction cascadePropertyChange(Difference objDiff, String propName, Object oldValue, Object newValue, T obj) throws DBException {
        CascadeAction retval = super.cascadePropertyChange(objDiff, propName, oldValue, newValue, obj);
        if ("partitions".equals(propName) || "subpartitionModel".equals(propName) || "hashQuantity".equals(propName) || "partitionType".equals(propName)) {
            boolean isRefPartitionCascade;
            DBObject parent;
            OracleTablePartitions otp = (OracleTablePartitions)obj.getProperty("OracleTablePartitions");
            Collection<OracleIndexPartitions> localOips = LocalIndexPartitionHelper.getLocalIndexPartitionModels(obj);
            DBObject cascaderObject = (DBObject)objDiff.getUpdatedObject();
            boolean selfCascading = false;
            if (cascaderObject == null) {
                cascaderObject = (DBObject)objDiff.getOriginalObject();
            }
            if ((parent = cascaderObject.getParent()) != null) {
                selfCascading = parent.getID().equals(obj.getID(), false);
            }
            boolean bl = isRefPartitionCascade = !(this.getProvider() instanceof Database) && otp != null && otp.getPartitionType() == OracleTablePartitions.PartitionType.REFERENCE && !selfCascading;
            if ("partitions".equals(propName)) {
                if (isRefPartitionCascade) {
                    retval = this.cascadePartitionChangesToReferencePartitions(retval, objDiff, obj);
                }
                retval = this.cascadePartitionChangesToLocalIndexPartitions(retval, objDiff, obj);
            } else if ("subpartitionModel".equals(propName)) {
                if (isRefPartitionCascade) {
                    retval = this.cascadeSubpartitionTemplateChangesToReferencePartitions(retval, objDiff, obj);
                }
                for (OracleIndexPartitions oip : localOips) {
                    retval = this.cascadeSubpartitionTemplateChangesToLocalIndexPartitions(retval, objDiff, oip);
                }
            } else if ("hashQuantity".equals(propName)) {
                Integer origHashQuantity = oldValue == null ? 0 : (Integer)oldValue;
                Integer updHashQuantity = newValue == null ? 0 : (Integer)newValue;
                if (isRefPartitionCascade) {
                    retval = this.cascadeHashQuantityChangesToReferencePartitions(retval, origHashQuantity, updHashQuantity, obj);
                }
                retval = this.cascadeHashQuantityChangesToLocalIndexPartitions(retval, origHashQuantity, updHashQuantity, obj);
            } else if ("partitionType".equals(propName) && isRefPartitionCascade && (newValue == null || oldValue != newValue)) {
                for (TablePartition partition : otp.getPartitions()) {
                    otp.removePartition(partition);
                }
                retval = CascadeAction.UPDATE;
            }
        }
        return retval;
    }

    private void addReferencePartitions(OracleTablePartitions otp, String prefixPartitionName, int startIndex, int numOfParts, int insertIndex) {
        for (int i = startIndex; i < startIndex + numOfParts; ++i) {
            String partitionName = prefixPartitionName + i;
            TablePartition tp = this.createReferencePartition(partitionName);
            otp.addPartition(insertIndex, tp);
            ++insertIndex;
        }
    }

    private TablePartition createReferencePartition(String partitionName) {
        TablePartition tp = new TablePartition(partitionName, OracleTablePartitions.PartitionType.REFERENCE, OracleTablePartitions.ObjectType.PARTITION);
        return tp;
    }

    private IndexPartition createLocalIndexPartition(TablePartition tp, String name) {
        int subsCount;
        IndexPartition ip = new IndexPartition();
        ip.setName(name);
        if (tp != null && (subsCount = ReferencePartitionHelper.getSubPartitionsCount(tp)) > 0) {
            OracleIndexPartitions suboip = new OracleIndexPartitions(OracleIndexPartitions.PartitionType.SUBPARTITION);
            for (int i = 1; i <= subsCount; ++i) {
                suboip.addPartition(LocalIndexPartitionHelper.createLocalIndexPartition(null, name + "_" + "SUBPARTITION" + i));
            }
            ip.setSubpartitions(suboip);
        }
        return ip;
    }

    private void addLocalIndexSubpartitions(OracleIndexPartitions suboip, TablePartition tp, int startIndx, int endIndx) {
        for (int i = startIndx; i <= endIndx; ++i) {
            suboip.addPartition(this.createLocalIndexPartition(null, tp.getName() + "_" + "SUBPARTITION" + i));
        }
    }

    private void addLocalIndexSubpartitions(OracleIndexPartitions suboip, TablePartition tp, int startIndx) {
        int endIndx = ReferencePartitionHelper.getSubPartitionsCount(tp);
        this.addLocalIndexSubpartitions(suboip, tp, startIndx, endIndx);
    }

    private CascadeAction cascadePartitionChangesToReferencePartitions(CascadeAction cascadeAction, Difference objDiff, T obj) {
        OracleTablePartitions parentOrigOtp = (OracleTablePartitions)objDiff.getOriginalObject();
        OracleTablePartitions parentUpdOtp = (OracleTablePartitions)objDiff.getUpdatedObject();
        boolean hasSubParts = parentUpdOtp.getSubpartitionModel() != null;
        Difference partitionDiff = objDiff.getChildDifference("partitions");
        OracleTablePartitions otp = (OracleTablePartitions)obj.getProperty("OracleTablePartitions");
        TablePartition[] partitions = otp.getPartitions();
        TreeSet<Integer> removed = new TreeSet<Integer>();
        TreeMap reordered = new TreeMap(Collections.reverseOrder());
        int numParentParts = ReferencePartitionHelper.getReferencedTablePartitionsCount(parentOrigOtp);
        if (otp.getPartitionType() == OracleTablePartitions.PartitionType.REFERENCE && partitions.length > 0 && (parentOrigOtp == null || numParentParts == partitions.length)) {
            int shiftIndex = 0;
            for (Difference difference : partitionDiff.getChildren()) {
                int origi = difference.getIndexOfOriginalObject();
                int updi = difference.getIndexOfUpdatedObject();
                TablePartition origPart = (TablePartition)(difference.getOriginalObject() == null ? null : difference.getOriginalObject());
                TablePartition updPart = (TablePartition)difference.getUpdatedObject();
                if (!difference.isSame()) {
                    int endIndx;
                    int numOfSubParts;
                    if (updPart == null) {
                        if (hasSubParts) {
                            int startIndx;
                            int numOfSubParts2 = ReferencePartitionHelper.getSubPartitionsCount(origPart);
                            for (int i = startIndx = shiftIndex + numOfSubParts2 - 1; i > startIndx - numOfSubParts2; --i) {
                                otp.removePartition(partitions[i]);
                            }
                        } else {
                            otp.removePartition(partitions[origi]);
                        }
                        removed.add(origi);
                        continue;
                    }
                    if (origPart == null) {
                        if (hasSubParts) {
                            int numOfSubParts3 = ReferencePartitionHelper.getSubPartitionsCount(updPart);
                            for (int i = 1; i <= numOfSubParts3; ++i) {
                                String partitionName = updPart.getName() + "_" + "SUBPARTITION" + i;
                                TablePartition tp = this.createReferencePartition(partitionName);
                                otp.addPartition(tp);
                            }
                            continue;
                        }
                        OracleTablePartitions.PartitionType updPartType = updPart.getPartitionType();
                        if (updPartType == OracleTablePartitions.PartitionType.HASH && (updPartType != OracleTablePartitions.PartitionType.HASH || updi <= 0)) continue;
                        String partitionName = updPart.getName();
                        TablePartition tp = this.createReferencePartition(partitionName);
                        otp.addPartition(tp);
                        continue;
                    }
                    if (origi != updi) continue;
                    Difference nameChange = difference.getChildDifference("name", true);
                    if (nameChange != null) {
                        String newName;
                        String updPartName;
                        String origPartName = origPart == null ? null : origPart.getName();
                        String string = updPartName = updPart == null ? null : updPart.getName();
                        if (hasSubParts) {
                            int numOfSubParts4 = ReferencePartitionHelper.getSubPartitionsCount(updPart);
                            for (int i = shiftIndex; i < shiftIndex + numOfSubParts4; ++i) {
                                String newName2;
                                TablePartition renameTp = partitions[i];
                                String string2 = newName2 = renameTp == null ? null : renameTp.getName();
                                if (origPartName == null || updPartName == null || newName2 == null || !newName2.startsWith(origPartName)) continue;
                                String partitionName = newName2.replaceFirst(origPartName, updPartName);
                                renameTp.setName(partitionName);
                            }
                            continue;
                        }
                        TablePartition renameTp = partitions[updi];
                        String string3 = newName = renameTp == null ? null : renameTp.getName();
                        if (origPartName == null || newName == null || !newName.equals(origPartName)) continue;
                        renameTp.setName(updPartName);
                        continue;
                    }
                    if (!hasSubParts) continue;
                    Difference subpartsDiff = difference.getChildDifference("partitionLevelSubpartitions");
                    if (subpartsDiff.getUpdatedObject() == null) {
                        int endIndx2;
                        int origNumOfSubParts = ReferencePartitionHelper.getSubPartitionsCount(origPart);
                        for (int i = endIndx2 = shiftIndex + origNumOfSubParts - 1; i >= shiftIndex; --i) {
                            otp.removePartition(partitions[i]);
                        }
                        int numOfSubParts5 = ReferencePartitionHelper.getSubPartitionsCount(updPart);
                        this.addReferencePartitions(otp, updPart.getName() + "_" + "SUBPARTITION", 1, numOfSubParts5, shiftIndex);
                        continue;
                    }
                    Difference hqDiff = subpartsDiff.getChildDifference("hashQuantity");
                    if (hqDiff != null && !hqDiff.isSame()) {
                        Integer origHashQuantity = hqDiff.getOriginalObject() == null ? 0 : (Integer)hqDiff.getOriginalObject();
                        Integer updHashQuantity = hqDiff.getUpdatedObject() == null ? 0 : (Integer)hqDiff.getUpdatedObject();
                        int startIndx = shiftIndex + updHashQuantity;
                        if (origHashQuantity < updHashQuantity) {
                            if (origHashQuantity == 0) {
                                int endIndx3;
                                int numOfSubParts6 = ReferencePartitionHelper.getSubPartitionsCount(origPart);
                                for (int i = endIndx3 = shiftIndex + numOfSubParts6 - 1; i >= shiftIndex; --i) {
                                    otp.removePartition(partitions[i]);
                                }
                            }
                            this.addReferencePartitions(otp, updPart.getName() + "_" + "SUBPARTITION", origHashQuantity + 1, updHashQuantity - origHashQuantity, shiftIndex + origHashQuantity);
                            continue;
                        }
                        if (updHashQuantity < origHashQuantity) {
                            int endIndx4;
                            for (int i = endIndx4 = shiftIndex + origHashQuantity - 1; i >= startIndx; --i) {
                                otp.removePartition(partitions[i]);
                            }
                            if (updHashQuantity != 0) continue;
                            int numOfSubParts7 = ReferencePartitionHelper.getSubPartitionsCount(updPart);
                            this.addReferencePartitions(otp, updPart.getName() + "_" + "SUBPARTITION", 1, numOfSubParts7, shiftIndex);
                            continue;
                        }
                        shiftIndex += ReferencePartitionHelper.getSubPartitionsCount((TablePartition)difference.getUpdatedObject());
                        continue;
                    }
                    Difference subpartitionsDiff = subpartsDiff.getChildDifference("partitions");
                    if (subpartitionsDiff == null || subpartitionsDiff.isSame()) continue;
                    int startIndex = shiftIndex;
                    removed.clear();
                    for (Difference subDiff : subpartitionsDiff.getChildren()) {
                        String updSubName;
                        int origSubi = subDiff.getIndexOfOriginalObject();
                        int updSubi = subDiff.getIndexOfUpdatedObject();
                        TablePartition origSub = (TablePartition)(subDiff.getOriginalObject() == null ? null : subDiff.getOriginalObject());
                        TablePartition updSub = (TablePartition)subDiff.getUpdatedObject();
                        String origSubName = origSub == null ? null : origSub.getName();
                        String string = updSubName = updSub == null ? null : updSub.getName();
                        if (origSubi == updSubi && !subDiff.isSame()) {
                            TablePartition renameTp = partitions[shiftIndex += updSubi];
                            String newName = renameTp == null ? null : renameTp.getName();
                            if (newName == null || origSubName == null || updSubName == null || !newName.equals(origSubName)) continue;
                            renameTp.setName(updSubName);
                            continue;
                        }
                        if (updSubi < 0) {
                            int removeIndex = shiftIndex + origSubi;
                            otp.removePartition(partitions[removeIndex]);
                            removed.add(origi);
                            continue;
                        }
                        if (origSubi < 0) {
                            String partitionName = updSub.getName();
                            TablePartition tp = this.createReferencePartition(partitionName);
                            otp.addPartition(shiftIndex + updSubi, tp);
                            continue;
                        }
                        if (origSubi == updSubi || removed.contains(updSubi)) continue;
                        TablePartition tp = partitions[startIndex + origSubi];
                        otp.removePartition(tp);
                        otp.addPartition(startIndex + updSubi, tp);
                    }
                    TablePartition[] subpartsAtStart = (TablePartition[])subpartitionsDiff.getOriginalObject();
                    TablePartition[] subpartsLeft = (TablePartition[])subpartitionsDiff.getUpdatedObject();
                    if (subpartsLeft.length == 0) {
                        numOfSubParts = ReferencePartitionHelper.getSubPartitionsCount(updPart);
                        this.addReferencePartitions(otp, updPart.getName() + "_" + "SUBPARTITION", 1, numOfSubParts, shiftIndex);
                        continue;
                    }
                    if (subpartsAtStart != null && subpartsAtStart.length != 0) continue;
                    numOfSubParts = ReferencePartitionHelper.getSubPartitionsCount(origPart);
                    for (int i = endIndx = shiftIndex + numOfSubParts - 1; i >= shiftIndex; --i) {
                        otp.removePartition(partitions[i]);
                    }
                    continue;
                }
                if (origi != updi) {
                    reordered.put(updi, origi);
                }
                if (!hasSubParts) continue;
                shiftIndex += ReferencePartitionHelper.getSubPartitionsCount((TablePartition)difference.getUpdatedObject());
            }
            if (!reordered.isEmpty()) {
                for (Map.Entry entry : reordered.entrySet()) {
                    Integer updIndex = (Integer)entry.getKey();
                    if (removed.contains(updIndex)) continue;
                    Integer origIndex = (Integer)entry.getValue();
                    TablePartition tp = partitions[origIndex];
                    if (hasSubParts) {
                        TablePartition currPart = parentUpdOtp.getPartitions()[updIndex];
                        int numOfSubParts = ReferencePartitionHelper.getSubPartitionsCount(currPart);
                        TablePartition[] origParentPartitions = parentOrigOtp.getPartitions();
                        TablePartition[] updParentPartitions = parentUpdOtp.getPartitions();
                        ArrayList<TablePartition> toRemove = new ArrayList<TablePartition>();
                        int moveToIndex = 0;
                        int moveFromIndex = 0;
                        if (updIndex > 0) {
                            for (int i = 0; i < updIndex; ++i) {
                                TablePartition parentPart = updParentPartitions[i];
                                moveToIndex += ReferencePartitionHelper.getSubPartitionsCount(parentPart);
                            }
                        }
                        if (updIndex > origIndex) {
                            moveToIndex += numOfSubParts;
                        }
                        if (origIndex > 0) {
                            for (int i = 0; i < origIndex; ++i) {
                                TablePartition parentPart = origParentPartitions[i];
                                moveFromIndex += ReferencePartitionHelper.getSubPartitionsCount(parentPart);
                            }
                        }
                        for (int i = moveFromIndex; i < moveFromIndex + numOfSubParts; ++i) {
                            TablePartition reftp = this.createReferencePartition(partitions[i].getName());
                            toRemove.add(partitions[i]);
                            otp.addPartition(moveToIndex, reftp);
                            ++moveToIndex;
                        }
                        for (TablePartition rmtp : toRemove) {
                            otp.removePartition(rmtp);
                        }
                        continue;
                    }
                    otp.removePartition(tp);
                    otp.addPartition(updIndex.intValue(), tp);
                }
            }
            cascadeAction = CascadeAction.UPDATE;
        }
        return cascadeAction;
    }

    private CascadeAction cascadeHashQuantityChangesToReferencePartitions(CascadeAction cascadeAction, Integer origHashQuantity, Integer updHashQuantity, T obj) {
        OracleTablePartitions otp = (OracleTablePartitions)obj.getProperty("OracleTablePartitions");
        if (otp.getPartitions().length > 0) {
            if (origHashQuantity < updHashQuantity) {
                for (int i = origHashQuantity + 1; i <= updHashQuantity; ++i) {
                    String partitionName = "PARTITION" + i;
                    TablePartition tp = this.createReferencePartition(partitionName);
                    otp.addPartition(tp);
                }
            } else {
                int endIndx;
                int startIndx = updHashQuantity;
                for (int i = endIndx = origHashQuantity - 1; i >= startIndx; --i) {
                    otp.removePartition(otp.getPartitions()[i]);
                }
            }
            cascadeAction = CascadeAction.UPDATE;
        }
        return cascadeAction;
    }

    private CascadeAction cascadeHashQuantityChangesToLocalIndexPartitions(CascadeAction cascadeAction, Integer origHashQuantity, Integer updHashQuantity, T obj) {
        Collection<OracleIndexPartitions> localOips = LocalIndexPartitionHelper.getLocalIndexPartitionModels(obj);
        for (OracleIndexPartitions oip : localOips) {
            if (oip.getPartitions().length <= 0) continue;
            if (origHashQuantity < updHashQuantity) {
                for (int i = origHashQuantity + 1; i <= updHashQuantity; ++i) {
                    String partitionName = "PARTITION" + i;
                    IndexPartition ip = this.createLocalIndexPartition(null, partitionName);
                    oip.addPartition(ip);
                }
            } else {
                int endIndx;
                int startIndx = updHashQuantity;
                for (int i = endIndx = origHashQuantity - 1; i >= startIndx; --i) {
                    oip.removePartition(oip.getPartitions()[i]);
                }
            }
            cascadeAction = CascadeAction.UPDATE;
        }
        return cascadeAction;
    }

    private CascadeAction cascadeSubpartitionTemplateChangesToReferencePartitions(CascadeAction cascadeAction, Difference objDiff, T obj) {
        OracleTablePartitions otp = (OracleTablePartitions)obj.getProperty("OracleTablePartitions");
        OracleTablePartitions updParentOtp = (OracleTablePartitions)objDiff.getUpdatedObject();
        TreeSet<Integer> removed = new TreeSet<Integer>();
        Difference subpartsDiff = objDiff.getChildDifference("subpartitionModel");
        OracleTablePartitions template = (OracleTablePartitions)subpartsDiff.getUpdatedObject();
        Difference hashQuantDiff = subpartsDiff.getChildDifference("hashQuantity");
        Integer origHashQuantity = null;
        Integer updHashQuantity = null;
        if (!hashQuantDiff.isSame()) {
            origHashQuantity = hashQuantDiff.getOriginalObject() == null ? 1 : (Integer)hashQuantDiff.getOriginalObject();
            updHashQuantity = hashQuantDiff.getUpdatedObject() == null ? 1 : (Integer)hashQuantDiff.getUpdatedObject();
        }
        int shiftIndex = 0;
        TablePartition[] partitions = otp.getPartitions();
        TablePartition[] parentPartitions = updParentOtp.getPartitions();
        if (partitions.length > 0) {
            for (TablePartition parentPartition : parentPartitions) {
                int startIndex = shiftIndex;
                removed.clear();
                OracleTablePartitions subparts = parentPartition.getPartitionLevelSubpartitions();
                if (subparts == null || subparts.getPartitions().length == 0 && subparts.getHashQuantity() == null) {
                    if (!hashQuantDiff.isSame()) {
                        int endIndx;
                        int startIndx = shiftIndex + updHashQuantity;
                        if (origHashQuantity < updHashQuantity) {
                            this.addReferencePartitions(otp, parentPartition.getName() + "_" + "SUBPARTITION", origHashQuantity + 1, updHashQuantity - origHashQuantity, shiftIndex + origHashQuantity);
                            shiftIndex += updHashQuantity.intValue();
                            continue;
                        }
                        if (updHashQuantity >= origHashQuantity) continue;
                        for (int i = endIndx = shiftIndex + origHashQuantity - 1; i >= startIndx; --i) {
                            otp.removePartition(partitions[i]);
                        }
                        shiftIndex += origHashQuantity.intValue();
                        continue;
                    }
                    Difference subpartitionDiff = subpartsDiff.getChildDifference("partitions");
                    for (Difference subPartDiff : subpartitionDiff.getChildren()) {
                        TablePartition renameTp;
                        String updSubName;
                        int origi = subPartDiff.getIndexOfOriginalObject();
                        int updi = subPartDiff.getIndexOfUpdatedObject();
                        TablePartition updSubpart = (TablePartition)subPartDiff.getUpdatedObject();
                        TablePartition origSubpart = (TablePartition)subPartDiff.getOriginalObject();
                        String origSubName = origSubpart == null ? null : origSubpart.getName();
                        String string = updSubName = updSubpart == null ? null : updSubpart.getName();
                        if (updi < 0) {
                            if (template.getPartitions().length > 0) {
                                otp.removePartition(partitions[shiftIndex]);
                                removed.add(origi);
                            }
                        } else if (origi < 0) {
                            String partitionName = parentPartition.getName() + "_" + updSubName;
                            if (template.getPartitions().length > 1 && updi != 0) {
                                TablePartition tp = this.createReferencePartition(partitionName);
                                otp.addPartition(shiftIndex, tp);
                            } else {
                                renameTp = otp.getPartitions()[shiftIndex];
                                renameTp.setName(partitionName);
                            }
                        } else if (origi == updi) {
                            Difference nameChange = subPartDiff.getChildDifference("name", true);
                            if (nameChange != null) {
                                String newName;
                                renameTp = otp.getPartitions()[shiftIndex];
                                String string2 = newName = renameTp == null ? null : renameTp.getName();
                                if (newName.endsWith(origSubName)) {
                                    String partitionName = newName.replaceFirst(origSubName, updSubName);
                                    renameTp.setName(partitionName);
                                }
                            }
                        } else if (origi != updi && !removed.contains(updi)) {
                            TablePartition tp = partitions[startIndex + origi];
                            otp.removePartition(tp);
                            otp.addPartition(startIndex + updi, tp);
                        }
                        ++shiftIndex;
                    }
                    continue;
                }
                shiftIndex += ReferencePartitionHelper.getSubPartitionsCount(parentPartition);
            }
            cascadeAction = CascadeAction.UPDATE;
        }
        return cascadeAction;
    }

    private CascadeAction cascadeSubpartitionTemplateChangesToLocalIndexPartitions(CascadeAction cascadeAction, Difference objDiff, OracleIndexPartitions oip) {
        OracleTablePartitions updParentOtp = (OracleTablePartitions)objDiff.getUpdatedObject();
        TreeSet<Integer> removed = new TreeSet<Integer>();
        Difference subpartsDiff = objDiff.getChildDifference("subpartitionModel");
        OracleTablePartitions template = (OracleTablePartitions)subpartsDiff.getUpdatedObject();
        Difference hashQuantDiff = subpartsDiff.getChildDifference("hashQuantity");
        Integer origHashQuantity = null;
        Integer updHashQuantity = null;
        if (!hashQuantDiff.isSame()) {
            origHashQuantity = hashQuantDiff.getOriginalObject() == null ? 1 : (Integer)hashQuantDiff.getOriginalObject();
            updHashQuantity = hashQuantDiff.getUpdatedObject() == null ? 1 : (Integer)hashQuantDiff.getUpdatedObject();
        }
        IndexPartition[] partitions = oip.getPartitions();
        TablePartition[] parentPartitions = updParentOtp.getPartitions();
        TreeMap reordered = new TreeMap(Collections.reverseOrder());
        int tablePartPos = 0;
        if (partitions.length > 0) {
            for (TablePartition parentPartition : parentPartitions) {
                removed.clear();
                OracleTablePartitions subparts = parentPartition.getPartitionLevelSubpartitions();
                IndexPartition ip = oip.getPartitions()[tablePartPos];
                OracleIndexPartitions suboip = ip.getSubpartitions();
                IndexPartition[] subpartitions = suboip.getPartitions();
                if (subparts == null || subparts.getPartitions().length == 0 && subparts.getHashQuantity() == null) {
                    if (!hashQuantDiff.isSame()) {
                        int startIndx = updHashQuantity;
                        if (origHashQuantity < updHashQuantity) {
                            this.addLocalIndexSubpartitions(suboip, parentPartition, origHashQuantity + 1, updHashQuantity);
                        } else if (updHashQuantity < origHashQuantity) {
                            int endIndx;
                            for (int i = endIndx = origHashQuantity - 1; i >= startIndx; --i) {
                                suboip.removePartition(subpartitions[i]);
                            }
                        }
                    } else {
                        Difference subpartitionDiff = subpartsDiff.getChildDifference("partitions");
                        for (Difference subPartDiff : subpartitionDiff.getChildren()) {
                            IndexPartition renameIp;
                            String updSubName;
                            int origi = subPartDiff.getIndexOfOriginalObject();
                            int updi = subPartDiff.getIndexOfUpdatedObject();
                            TablePartition updSubpart = (TablePartition)subPartDiff.getUpdatedObject();
                            TablePartition origSubpart = (TablePartition)subPartDiff.getOriginalObject();
                            String origSubName = origSubpart == null ? null : origSubpart.getName();
                            String string = updSubName = updSubpart == null ? null : updSubpart.getName();
                            if (updi < 0) {
                                if (template.getPartitions().length <= 0) continue;
                                suboip.removePartition(subpartitions[origi]);
                                removed.add(origi);
                                continue;
                            }
                            if (origi < 0) {
                                String partitionName = parentPartition.getName() + "_" + updSubName;
                                if (template.getPartitions().length > 1 && updi != 0 || suboip.getPartitions().length == 0) {
                                    IndexPartition tp = this.createLocalIndexPartition(null, partitionName);
                                    suboip.addPartition(updi, tp);
                                    continue;
                                }
                                renameIp = suboip.getPartitions()[updi];
                                renameIp.setName(partitionName);
                                continue;
                            }
                            if (origi == updi) {
                                String newName;
                                Difference nameChange = subPartDiff.getChildDifference("name", true);
                                if (nameChange == null || !(newName = (renameIp = suboip.getPartitions()[updi]) == null ? null : renameIp.getName()).endsWith(origSubName)) continue;
                                String partitionName = newName.replaceFirst(origSubName, updSubName);
                                renameIp.setName(partitionName);
                                continue;
                            }
                            if (origi == updi || removed.contains(updi)) continue;
                            reordered.put(updi, origi);
                        }
                    }
                }
                if (!reordered.isEmpty()) {
                    for (Map.Entry entry : reordered.entrySet()) {
                        Integer updSubIndex = (Integer)entry.getKey();
                        Integer origSubIndex = (Integer)entry.getValue();
                        if (suboip == null) continue;
                        IndexPartition moveIp = subpartitions[origSubIndex];
                        suboip.removePartition(moveIp);
                        suboip.addPartition(updSubIndex.intValue(), moveIp);
                    }
                    reordered.clear();
                }
                ++tablePartPos;
            }
            cascadeAction = CascadeAction.UPDATE;
        }
        return cascadeAction;
    }

    private CascadeAction cascadePartitionChangesToLocalIndexPartitions(CascadeAction cascadeAction, Difference objDiff, T obj) {
        Collection<OracleIndexPartitions> localOips = LocalIndexPartitionHelper.getLocalIndexPartitionModels(obj);
        for (OracleIndexPartitions iop : localOips) {
            cascadeAction = this.cascadeToLocalIndexPartitions(cascadeAction, objDiff, iop);
        }
        return cascadeAction;
    }

    private CascadeAction cascadeToLocalIndexPartitions(CascadeAction cascadeAction, Difference objDiff, OracleIndexPartitions oip) {
        OracleTablePartitions parentOrigOtp = (OracleTablePartitions)objDiff.getOriginalObject();
        OracleTablePartitions parentUpdOtp = (OracleTablePartitions)objDiff.getUpdatedObject();
        boolean hasSubParts = parentUpdOtp.getSubpartitionModel() != null;
        Difference partitionDiff = objDiff.getChildDifference("partitions");
        IndexPartition[] partitions = oip.getPartitions();
        TreeSet<Integer> removed = new TreeSet<Integer>();
        TreeMap reordered = new TreeMap(Collections.reverseOrder());
        if (partitions.length > 0 && LocalIndexPartitionHelper.areTableAndIndexPartitionsSameShape(parentOrigOtp, oip)) {
            for (Difference difference : partitionDiff.getChildren()) {
                int origi = difference.getIndexOfOriginalObject();
                int updi = difference.getIndexOfUpdatedObject();
                TablePartition origPart = (TablePartition)(difference.getOriginalObject() == null ? null : difference.getOriginalObject());
                TablePartition updPart = (TablePartition)difference.getUpdatedObject();
                if (!difference.isSame()) {
                    IndexPartition ip;
                    if (updPart == null) {
                        oip.removePartition(partitions[origi]);
                        removed.add(origi);
                        continue;
                    }
                    if (origPart == null) {
                        OracleTablePartitions.PartitionType updPartType = updPart.getPartitionType();
                        if (updPartType == OracleTablePartitions.PartitionType.HASH && (updPartType != OracleTablePartitions.PartitionType.HASH || updi <= 0)) continue;
                        String partitionName = updPart.getName();
                        ip = LocalIndexPartitionHelper.createLocalIndexPartition(updPart, partitionName);
                        oip.addPartition(ip);
                        continue;
                    }
                    if (origi != updi) continue;
                    Difference nameChange = difference.getChildDifference("name", true);
                    if (nameChange != null) {
                        String newName;
                        String origPartName = origPart == null ? null : origPart.getName();
                        String updPartName = updPart == null ? null : updPart.getName();
                        IndexPartition renameIp = partitions[updi];
                        String string = newName = renameIp == null ? null : renameIp.getName();
                        if (origPartName == null || newName == null || !newName.equals(origPartName)) continue;
                        if (hasSubParts) {
                            // empty if block
                        }
                        renameIp.setName(updPartName);
                        continue;
                    }
                    if (!hasSubParts) continue;
                    Difference subpartsDiff = difference.getChildDifference("partitionLevelSubpartitions");
                    ip = oip.getPartitions()[origi];
                    OracleIndexPartitions suboip = ip.getSubpartitions();
                    if (subpartsDiff.getUpdatedObject() == null) {
                        if (suboip == null) continue;
                        suboip.setPartitions(null);
                        this.addLocalIndexSubpartitions(suboip, updPart, 1);
                        continue;
                    }
                    Difference hqDiff = subpartsDiff.getChildDifference("hashQuantity");
                    if (hqDiff != null && !hqDiff.isSame()) {
                        Integer origHashQuantity = hqDiff.getOriginalObject() == null ? 0 : (Integer)hqDiff.getOriginalObject();
                        Integer updHashQuantity = hqDiff.getUpdatedObject() == null ? 0 : (Integer)hqDiff.getUpdatedObject();
                        if (origHashQuantity < updHashQuantity) {
                            if (origHashQuantity == 0) {
                                suboip.setPartitions(null);
                            }
                            if (suboip != null) {
                                this.addLocalIndexSubpartitions(suboip, updPart, origHashQuantity + 1);
                            }
                        } else if (updHashQuantity < origHashQuantity && suboip != null) {
                            int n;
                            IndexPartition[] subpartitions = suboip.getPartitions();
                            for (int i = n = origHashQuantity - 1; i >= updHashQuantity; --i) {
                                suboip.removePartition(subpartitions[i]);
                            }
                            if (updHashQuantity == 0) {
                                this.addLocalIndexSubpartitions(suboip, updPart, 1);
                            }
                        }
                        cascadeAction = CascadeAction.UPDATE;
                        continue;
                    }
                    Difference subpartitionsDiff = subpartsDiff.getChildDifference("partitions");
                    if (subpartitionsDiff == null || subpartitionsDiff.isSame()) continue;
                    removed.clear();
                    IndexPartition[] subpartitions = suboip.getPartitions();
                    for (Difference difference2 : subpartitionsDiff.getChildren()) {
                        String updSubName;
                        int origSubi = difference2.getIndexOfOriginalObject();
                        int updSubi = difference2.getIndexOfUpdatedObject();
                        TablePartition origSub = (TablePartition)(difference2.getOriginalObject() == null ? null : difference2.getOriginalObject());
                        TablePartition updSub = (TablePartition)difference2.getUpdatedObject();
                        String origSubName = origSub == null ? null : origSub.getName();
                        String string = updSubName = updSub == null ? null : updSub.getName();
                        if (origSubi == updSubi && !difference2.isSame()) {
                            IndexPartition renameSub;
                            String newName;
                            if (suboip == null || (newName = (renameSub = suboip.getPartitions()[updSubi]) == null ? null : renameSub.getName()) == null || origSubName == null || updSubName == null || !newName.equals(origSubName)) continue;
                            renameSub.setName(updSubName);
                            continue;
                        }
                        if (updSubi < 0) {
                            if (suboip == null) continue;
                            suboip.removePartition(subpartitions[origSubi]);
                            removed.add(origi);
                            continue;
                        }
                        if (origSubi < 0) {
                            if (suboip == null) continue;
                            TablePartition[] subpartsAtStart = (TablePartition[])subpartitionsDiff.getOriginalObject();
                            if (subpartsAtStart == null || subpartsAtStart.length == 0 && updSubi == 0) {
                                suboip.setPartitions(null);
                            }
                            IndexPartition addIp = this.createLocalIndexPartition(null, updSub.getName());
                            suboip.addPartition(addIp);
                            continue;
                        }
                        if (origSubi == updSubi || removed.contains(updi)) continue;
                        reordered.put(updSubi, origSubi);
                    }
                    if (suboip.getPartitions().length == 0) {
                        this.addLocalIndexSubpartitions(suboip, updPart, 1);
                    }
                    if (reordered.isEmpty() || removed.contains(updi)) continue;
                    for (Map.Entry entry : reordered.entrySet()) {
                        Integer updSubIndex = (Integer)entry.getKey();
                        Integer origSubIndex = (Integer)entry.getValue();
                        if (suboip == null) continue;
                        IndexPartition moveIp = subpartitions[origSubIndex];
                        suboip.removePartition(moveIp);
                        suboip.addPartition(updSubIndex.intValue(), moveIp);
                    }
                    reordered.clear();
                    continue;
                }
                if (origi == updi) continue;
                reordered.put(updi, origi);
            }
            if (!reordered.isEmpty()) {
                for (Map.Entry entry : reordered.entrySet()) {
                    Integer updIndex = (Integer)entry.getKey();
                    if (removed.contains(updIndex)) continue;
                    Integer origIndex = (Integer)entry.getValue();
                    IndexPartition ip = partitions[origIndex];
                    oip.removePartition(ip);
                    oip.addPartition(updIndex.intValue(), ip);
                }
            }
            cascadeAction = CascadeAction.UPDATE;
        }
        return cascadeAction;
    }
}

