/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.Collection;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.LocalIndexPartitionHelper;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;

public class IndexPartitionValidator
extends AbstractChildDBObjectValidator<IndexPartition> {
    public IndexPartitionValidator(DBObjectProvider pro) {
        super(pro);
    }

    protected boolean canHaveEmptyName() {
        return true;
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection retval = super.listAlwaysValidProperties();
        retval.add("domainParameters");
        retval.add("useKeyCompression");
        retval.add("valuesLessThan");
        return retval;
    }

    @Override
    public DBObjectValidator.NamespaceType getNamespaceType() {
        return DBObjectValidator.NamespaceType.TYPE_PARENT;
    }

    protected void validateNameInUse(IndexPartition object) throws NameInUseException {
        if (LocalIndexPartitionHelper.getBaseTablePartition(object) == null) {
            super.validateNameInUse((DBObject)object);
        }
    }

    @DBObjectValidator.PropertyValidator(value={"globalPartitionColumns"}, level=ValidationLevel.FULL)
    public void validateGlobalRangePartition(IndexPartition original, IndexPartition indexP) throws ValidationException {
        OracleIndexPartitions parent = (OracleIndexPartitions)indexP.getParent();
        if (parent != null && parent.getPartitionType() == OracleIndexPartitions.PartitionType.GLOBAL_RANGE) {
            Object[] valuesLessThan;
            DBObjectID[] partitionColumns = parent.getGlobalPartitionColumns();
            if (partitionColumns.length != (valuesLessThan = indexP.getValuesLessThan()).length) {
                String name = indexP.getName();
                throw new ValidationException((DBObject)indexP, APIBundle.format((String)"INDEX_PARTITION_ERROR_INVALID_VALUES_COUNT", (Object[])new Object[]{ModelUtil.hasLength((String)name) ? name : APIBundle.get((String)"INDEX_PARTITION_VALUE_UNNAMED")}));
            }
            for (Object value : valuesLessThan) {
                if (!"NULL".equalsIgnoreCase(value.toString())) continue;
                String name = indexP.getName();
                throw new ValidationException((DBObject)indexP, APIBundle.format((String)"INDEX_PARTITION_ERROR_INVALID_VALUES_COUNT", (Object[])new Object[]{ModelUtil.hasLength((String)name) ? name : APIBundle.get((String)"INDEX_PARTITION_ERROR_INVALID_NULL_VALUE")}));
            }
        }
    }
}

