/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import java.util.ArrayList;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleInMemoryColumnProperties;
import oracle.javatools.db.ora.OracleInMemoryProperties;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLReader;
import oracle.javatools.db.ora.sxml.SXMLReaderException;
import oracle.javatools.util.ModelUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InMemorySXMLGenerator
extends SXMLFragmentGenerator {
    private static final String NO_INMEMORY = "NO INMEMORY";
    private static final String NONE = "NONE";
    private static final String IM_COL_LIST = "IM_COL_LIST";
    private static final String IM_COL_LIST_ITEM = "IM_COL_LIST_ITEM";
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String COMPRESSION = "COMPRESSION";

    @Override
    protected void populateNode(Node parent, Document doc, Object obj) {
        OracleInMemoryColumnProperties[] clause;
        OracleInMemoryProperties imp = (OracleInMemoryProperties)obj;
        Table tab = (Table)DBUtil.findParentOfType((DBObject)imp, Table.class);
        OracleInMemoryColumnProperties[] oracleInMemoryColumnPropertiesArray = clause = tab == null ? null : (OracleInMemoryColumnProperties[])tab.getProperty("OracleInMemoryColumnProperties");
        if (clause != null) {
            Node imColListNode = null;
            for (OracleInMemoryColumnProperties imcp : clause) {
                for (DBObjectID id : imcp.getColumnIDs()) {
                    OracleInMemoryProperties.InMemoryCompression c;
                    Column col = (Column)tab.findOwnedObject(id);
                    if (col == null) continue;
                    if (imColListNode == null) {
                        imColListNode = this.findOrCreateNode(doc, parent, IM_COL_LIST);
                    }
                    String compText = imcp.isInMemory() ? ((c = imcp.getInMemoryCompression()) == null ? NONE : c.toString()) : NO_INMEMORY;
                    Node item = this.createNode(doc, imColListNode, IM_COL_LIST_ITEM);
                    Node colName = this.createNode(doc, item, COLUMN_NAME);
                    colName.setTextContent(col.getName());
                    Node comp = this.createNode(doc, item, COMPRESSION);
                    comp.setTextContent(compText);
                }
            }
        }
    }

    @Override
    protected void readNode(Node parent, Object obj) throws SXMLReaderException {
        NodeList nl;
        Node imColList;
        SXMLReader reader = (SXMLReader)this.getParentGenerator();
        SystemObject top = reader.getCurrentObject();
        if (top instanceof Table && (imColList = this.findNode(parent, IM_COL_LIST)) != null && (nl = imColList.getChildNodes()) != null) {
            ArrayList<OracleInMemoryColumnProperties> imcps = new ArrayList<OracleInMemoryColumnProperties>();
            NameBasedID tabID = new NameBasedID((DBObject)top, (DBObjectID)null);
            for (int i = 0; i < nl.getLength(); ++i) {
                String compText;
                String colName;
                Node col;
                Node item = nl.item(i);
                if (!IM_COL_LIST_ITEM.equals(item.getLocalName()) || (col = this.findNode(item, COLUMN_NAME)) == null || !ModelUtil.hasLength((String)(colName = col.getTextContent()))) continue;
                OracleInMemoryColumnProperties imcp = new OracleInMemoryColumnProperties();
                imcps.add(imcp);
                NameBasedID colID = new NameBasedID("COLUMN", colName, (DBObjectID)tabID);
                imcp.setColumnIDs(new DBObjectID[]{colID});
                imcp.setID((DBObjectID)new NameBasedID("OracleInMemoryColumnProperties", colName, (DBObjectID)tabID));
                Node comp = this.findNode(item, COMPRESSION);
                if (comp == null || NONE.equals(compText = comp.getTextContent())) continue;
                if (NO_INMEMORY.equals(compText)) {
                    imcp.setInMemory(false);
                    continue;
                }
                imcp.setInMemoryCompression((OracleInMemoryProperties.InMemoryCompression)DBUtil.findEnumFromString((String)compText, OracleInMemoryProperties.InMemoryCompression.class));
            }
            top.setProperty("OracleInMemoryColumnProperties", (Object)imcps.toArray(new OracleInMemoryColumnProperties[imcps.size()]));
        }
    }
}

