/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.ora.sql.ExpressionFactory;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderHelper;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.WhereObject;

public class WhereObjectBuilder
extends ExpressionFactory {
    @Override
    public SQLFragment createFragment(ExpressionContext context, ParseNode node) throws SQLQueryException {
        WhereObject retval = null;
        WhereObject.WhereOperator type = null;
        OracleSQLQueryBuilderHelper helper = context.getHelper();
        List<ParseNode> kids = helper.getOrderedChildren(node);
        if (kids.size() == 3) {
            if (helper.isLeaf(kids.get(1))) {
                if (helper.isKeyword(kids.get(1), "and")) {
                    type = WhereObject.WhereOperator.AND;
                } else if (helper.isKeyword(kids.get(1), "or")) {
                    type = WhereObject.WhereOperator.OR;
                }
            }
            if (type != null) {
                SQLFragment creating = context.getCreating();
                Object queryContext = context.getQueryContext();
                SQLFragment left = context.createFragment(kids.get(0), creating, queryContext);
                SQLFragment right = context.createFragment(kids.get(2), creating, queryContext);
                SQLFragment[] operands = null;
                if (left instanceof WhereObject && type == ((WhereObject)left).getOperator()) {
                    SQLFragment[] lhsOperands = ((WhereObject)left).getArguments();
                    operands = new SQLFragment[lhsOperands.length + 1];
                    for (int i = 0; i < lhsOperands.length; ++i) {
                        operands[i] = lhsOperands[i];
                    }
                    operands[lhsOperands.length] = right;
                } else {
                    operands = new SQLFragment[]{left, right};
                }
                retval = new WhereObject(operands, type);
            }
        }
        return retval;
    }
}

