/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.ora.sql.ExpressionFactory;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderHelper;
import oracle.javatools.db.sql.ExpressionList;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;

public class PartitionByBuilder
extends ExpressionFactory {
    @Override
    public SQLFragment createFragment(ExpressionContext context, ParseNode node) throws SQLQueryException {
        ExpressionList retval = null;
        OracleSQLQueryBuilderHelper helper = context.getHelper();
        if (helper.isRule(node, "query_partition_clause", "model_column_clauses")) {
            Object queryContext = context.getQueryContext();
            retval = this.processQueryPartitionClause(node, queryContext instanceof FromObject ? (FromObject)queryContext : null, context);
        }
        return retval;
    }

    private ExpressionList processQueryPartitionClause(ParseNode queryPartitionNode, FromObject from, ExpressionContext context) throws SQLQueryException {
        ExpressionList retval = null;
        OracleSQLQueryBuilderHelper helper = context.getHelper();
        List<ParseNode> kids = helper.getOrderedChildren(queryPartitionNode);
        List<List<ParseNode>> pes = null;
        if (kids.size() == 3 && helper.isRule(kids.get(2), "compound_expression")) {
            pes = context.getCompoundExpression(kids, 2);
        } else {
            int first = 2;
            int last = kids.size();
            if (helper.isKeyword(kids.get(2), "(") && helper.isKeyword(kids.get(last - 1), ")")) {
                first = 3;
                --last;
            }
            pes = helper.getCommaSeparatedList(kids.subList(first, last));
        }
        retval = context.createExpressionList(pes, (SQLFragment)from);
        return retval;
    }
}

