/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderHelper;

public class OracleSQLViewContextHelper {
    public static String getRelationNameFromAlias(String sqlText, String alias) {
        String retval = null;
        Collection<RelationAlias> aliasObjs = OracleSQLViewContextHelper.getAliases(sqlText, alias);
        if (aliasObjs != null && aliasObjs.size() == 1) {
            RelationAlias relAlias = (RelationAlias)aliasObjs.toArray()[0];
            retval = relAlias.getRelation().toUpperCase();
        }
        return retval;
    }

    public static Collection<RelationAlias> getAliases(String sqlText) {
        return OracleSQLViewContextHelper.getAliases(sqlText, null);
    }

    public static Collection<RelationAlias> getAliases(String sqlText, String aliasMatch) {
        HashSet<RelationAlias> aliases = new HashSet<RelationAlias>();
        List lexerTokens = LexerToken.parse((String)sqlText);
        OracleSQLQueryBuilderHelper sqlHelper = OracleSQLQueryBuilderHelper.getHelper(sqlText);
        ParseNode parseRoot = sqlHelper.getRaptorRoot();
        List<ParseNode> relNodes = sqlHelper.findRuleNodes(parseRoot, "table_reference");
        for (ParseNode relNode : relNodes) {
            RelationAlias alias = OracleSQLViewContextHelper.getAlias(sqlHelper.getOrderedChildren(relNode), lexerTokens);
            if (alias == null || !alias.isComplete() || aliasMatch != null && !alias.getAlias().equals(aliasMatch)) continue;
            aliases.add(alias);
        }
        return aliases;
    }

    private static RelationAlias getAlias(List<ParseNode> nodeList, List<LexerToken> lexerTokens) {
        RelationAlias aliasPair = new RelationAlias();
        if (nodeList.size() > 1) {
            for (ParseNode tableRef : nodeList) {
                if (!lexerTokens.get((int)tableRef.from).type.toString().equalsIgnoreCase("identifier")) continue;
                if (aliasPair.getRelation() == null) {
                    aliasPair.setRelation(lexerTokens.get((int)tableRef.from).content);
                    continue;
                }
                aliasPair.setAlias(lexerTokens.get((int)tableRef.from).content);
            }
        }
        return aliasPair;
    }

    public static class RelationAlias {
        String m_relation;
        String m_alias;

        public void setRelation(String relation) {
            this.m_relation = relation;
        }

        public String getRelation() {
            return this.m_relation;
        }

        public void setAlias(String alias) {
            this.m_alias = alias;
        }

        public String getAlias() {
            return this.m_alias;
        }

        public String toString() {
            return this.m_alias;
        }

        public boolean isComplete() {
            return this.m_alias != null && this.m_relation != null;
        }
    }
}

