/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.ora.sql.ExpressionFactory;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderHelper;
import oracle.javatools.db.sql.ExpressionList;
import oracle.javatools.db.sql.ModelObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;

public class ModelBuilder
extends ExpressionFactory {
    @Override
    public SQLFragment createFragment(ExpressionContext context, ParseNode node) throws SQLQueryException {
        ModelObject retval = null;
        OracleSQLQueryBuilderHelper helper = context.getHelper();
        if (helper.isRule(node, "model_clause")) {
            ModelObject model = new ModelObject();
            List<ParseNode> kids = helper.getOrderedChildren(node);
            for (int i = 1; i < kids.size(); ++i) {
                ParseNode child = kids.get(i);
                if (helper.isRule(child, "cell_reference_options")) {
                    ModelObject.CellReferenceOptions cellReferenceOptions = this.buildCellReferenceOptions(child, context);
                    model.setCellReferenceOptions(cellReferenceOptions);
                    continue;
                }
                if (helper.isRule(child, "return_rows_clause")) {
                    this.addReturnRowsClause(model, child, context);
                    continue;
                }
                if (helper.isRule(child, "reference_model")) {
                    this.addReferenceModel(model, child, context);
                    continue;
                }
                if (!helper.isRule(child, "main_model")) continue;
                this.addMainModel(model, child, context);
                break;
            }
            retval = model;
        }
        return retval;
    }

    private ModelObject.CellReferenceOptions buildCellReferenceOptions(ParseNode node, ExpressionContext context) {
        ModelObject.CellReferenceOptions cellReferenceOptions = new ModelObject.CellReferenceOptions();
        OracleSQLQueryBuilderHelper helper = context.getHelper();
        for (ParseNode child : helper.getOrderedChildren(node)) {
            if (helper.isKeyword(child, "IGNORE")) {
                cellReferenceOptions.setIgnoreNav(true);
                continue;
            }
            if (helper.isKeyword(child, "KEEP")) {
                cellReferenceOptions.setKeepNav(true);
                continue;
            }
            if (helper.isKeyword(child, "DIMENSION")) {
                cellReferenceOptions.setUniqueDimension(true);
                continue;
            }
            if (!helper.isKeyword(child, "SINGLE")) continue;
            cellReferenceOptions.setUniqueSingleReference(true);
        }
        return cellReferenceOptions;
    }

    private void addReturnRowsClause(ModelObject model, ParseNode node, ExpressionContext context) {
        OracleSQLQueryBuilderHelper helper = context.getHelper();
        List<ParseNode> kids = helper.getOrderedChildren(node);
        if (helper.isKeyword(kids.get(1), "UPDATED")) {
            model.setReturnUpdatedRows(true);
        } else if (helper.isKeyword(kids.get(1), "ALL")) {
            model.setReturnAllRows(true);
        }
    }

    private void addReferenceModel(ModelObject model, ParseNode node, ExpressionContext context) throws SQLQueryException {
        throw new SQLQueryException("Cannot handle reference_model clause");
    }

    private void addMainModel(ModelObject model, ParseNode node, ExpressionContext context) throws SQLQueryException {
        OracleSQLQueryBuilderHelper helper = context.getHelper();
        List<ParseNode> kids = helper.getOrderedChildren(node);
        int i = 0;
        if (helper.isKeyword(kids.get(i), "MAIN")) {
            String mainModelName = helper.getContent(kids.get(i + 1));
            model.setMainModelName(mainModelName);
            i += 2;
        }
        this.addModelColumnClauses(model, kids.get(i), context);
        if (helper.isRule(kids.get(++i), "cell_reference_options")) {
            ModelObject.CellReferenceOptions cellReferenceOptions = this.buildCellReferenceOptions(kids.get(i), context);
            ++i;
            model.setMainModelCellReferenceOptions((SQLFragment)cellReferenceOptions);
        }
        this.addModelRulesClause(model, kids.get(i), context);
    }

    private void addModelColumnClauses(ModelObject model, ParseNode node, ExpressionContext context) throws SQLQueryException {
        ModelObject.ModelColumnClauses modelColumnClauses = new ModelObject.ModelColumnClauses();
        OracleSQLQueryBuilderHelper helper = context.getHelper();
        List<ParseNode> kids = helper.getOrderedChildren(node);
        Object pes = null;
        if (helper.isKeyword(kids.get(0), "PARTITION")) {
            SQLFragment partitionBy = context.createFragment(kids.get(2), (SQLFragment)model);
            modelColumnClauses.setPartitionByExpressionList(partitionBy);
        }
        int i = helper.getKeywordIndex(kids, "DIMENSION");
        SQLFragment dimensionBy = this.buildExpressionList(kids, i + 2, context);
        modelColumnClauses.setDimensionByExpressionList(dimensionBy);
        i = helper.getKeywordIndex(kids, "MEASURES");
        SQLFragment measures = this.buildExpressionList(kids, i + 1, context);
        modelColumnClauses.setMeasuresExpressionList(measures);
        model.setModelColumnClauses((SQLFragment)modelColumnClauses);
    }

    private SQLFragment buildExpressionList(List<ParseNode> kids, int start, ExpressionContext context) throws SQLQueryException {
        OracleSQLQueryBuilderHelper helper = context.getHelper();
        int rparenIndex = helper.getKeywordIndex(kids, start, ")");
        List<List<ParseNode>> pes = helper.getCommaSeparatedList(kids.subList(start + 1, rparenIndex));
        ExpressionList retval = context.createExpressionList(pes, null);
        return retval;
    }

    private void addModelRulesClause(ModelObject model, ParseNode node, ExpressionContext context) throws SQLQueryException {
        OracleSQLQueryBuilderHelper helper = context.getHelper();
        List<ParseNode> kids = helper.getOrderedChildren(node);
        ModelObject.ModelRulesClause rulesClause = new ModelObject.ModelRulesClause();
        int i = 0;
        if (helper.isKeyword(kids.get(i), "RULES")) {
            rulesClause.setRulesPresent(true);
            if (helper.isKeyword(kids.get(++i), "UPDATE")) {
                ++i;
                rulesClause.setRulesUpdate(true);
            } else if (helper.isKeyword(kids.get(i), "UPSERT")) {
                rulesClause.setRulesUpsert(true);
                if (helper.isKeyword(kids.get(++i), "ALL")) {
                    ++i;
                    rulesClause.setRulesAll(true);
                }
            }
            if (helper.isKeyword(kids.get(i), "AUTOMATIC")) {
                i += 2;
                rulesClause.setAutomatic(true);
                rulesClause.setOrder(true);
            } else if (helper.isKeyword(kids.get(i), "SEQUENTIAL")) {
                i += 2;
                rulesClause.setSequential(true);
                rulesClause.setOrder(true);
            }
            if (helper.isRule(kids.get(i), "model_iterate_clause")) {
                List<ParseNode> iterKids = helper.getOrderedChildren(kids.get(i));
                ++i;
                String iterNumber = helper.getContent(iterKids.get(2));
                rulesClause.setIterateNumber(iterNumber);
                if (iterKids.size() > 5 && helper.isKeyword(iterKids.get(4), "UNTIL")) {
                    SQLFragment untilCond = context.createFragment(iterKids.get(6), (SQLFragment)model);
                    rulesClause.setUntilCondition(untilCond);
                }
            }
        }
        ArrayList<ModelObject.ModelRulesCellAssignmentExpr> elist = new ArrayList<ModelObject.ModelRulesCellAssignmentExpr>();
        while (!helper.isKeyword(kids.get(i), ")")) {
            if (!helper.isKeyword(kids.get(i), "(", ",")) {
                throw new SQLQueryException("Failed to find expected '(' or ',' in model_rules_clause");
            }
            ModelObject.ModelRulesCellAssignmentExpr mrcaExpr = new ModelObject.ModelRulesCellAssignmentExpr();
            if (helper.isKeyword(kids.get(++i), "UPDATE")) {
                ++i;
                mrcaExpr.setUpdate(true);
            } else if (helper.isKeyword(kids.get(i), "UPSERT")) {
                mrcaExpr.setUpsert(true);
                if (helper.isKeyword(kids.get(++i), "ALL")) {
                    ++i;
                    mrcaExpr.setAll(true);
                }
            }
            SQLFragment cellAssignment = context.createFragment(kids.get(i), null);
            mrcaExpr.setModelRulesCellAssignment(cellAssignment);
            if (helper.isKeyword(kids.get(++i), "=")) {
                ++i;
            } else {
                SQLFragment orderBy = context.createFragment(kids.get(i), (SQLFragment)mrcaExpr);
                if (orderBy == null) {
                    throw new SQLQueryException("Failed to find expected order_by_clause in model_rules_clause");
                }
                mrcaExpr.setOrderBy(orderBy);
                i += 2;
            }
            SQLFragment expr = context.createFragment(kids.get(i), (SQLFragment)mrcaExpr);
            if (expr == null) {
                throw new SQLQueryException("Failed to find expected expr in model_rules_clause");
            }
            ++i;
            mrcaExpr.setExpr(expr);
            elist.add(mrcaExpr);
        }
        ExpressionList cellAssignmentExprs = new ExpressionList(elist.toArray(new SQLFragment[elist.size()]));
        rulesClause.setCellAssignmentExprs(cellAssignmentExprs);
        model.setModelRulesClause((SQLFragment)rulesClause);
    }
}

