/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.ora.sql.ExpressionFactory;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderHelper;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.DataMiningFunction;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SimpleSQLFragment;

public class DataMiningFunctionBuilder
extends ExpressionFactory {
    @Override
    public SQLFragment createFragment(ExpressionContext context, ParseNode node) throws SQLQueryException {
        DataMiningFunction retval = null;
        OracleSQLQueryBuilderHelper helper = context.getHelper();
        if (helper.isRule(node, "data_mining_function")) {
            List<ParseNode> kids = helper.getOrderedChildren(node);
            String fname = null;
            if (helper.isLeaf(kids.get(0))) {
                fname = helper.getContent(kids.get(0));
            }
            if (fname == null) {
                context.getQueryBuilder().throwException(new SQLQueryException(APIBundle.format((String)"SQL_UNKNOWN_FUNC", (Object[])new Object[]{fname})));
            }
            fname = fname.toUpperCase();
            int start = 2;
            String modelName = null;
            if (helper.isLeaf(kids.get(start))) {
                modelName = helper.getContent(kids.get(start));
                if (helper.isKeyword(kids.get(++start), ".") && helper.isLeaf(kids.get(++start))) {
                    modelName = modelName + "." + helper.getContent(kids.get(start));
                    ++start;
                }
            }
            ArrayList<SQLFragment> dmSpecificArgs = new ArrayList<SQLFragment>();
            while (!helper.isRule(kids.get(start), "cost_matrix_clause") && !helper.isRule(kids.get(start), "mining_attribute_clause")) {
                if (helper.isKeyword(kids.get(start), ",")) {
                    ++start;
                    continue;
                }
                SQLFragment arg = null;
                if (helper.isLeaf(kids.get(start))) {
                    String argValue = helper.getContent(kids.get(start));
                    arg = new SimpleSQLFragment(argValue);
                } else {
                    arg = context.createFragment(kids.get(start), context.getCreating());
                }
                dmSpecificArgs.add(arg);
                ++start;
            }
            SQLFragment[] dmCostArgs = null;
            boolean cost = false;
            if (helper.isRule(kids.get(start), "cost_matrix_clause")) {
                cost = true;
                dmCostArgs = this.getCost(kids.get(start), context);
                ++start;
            }
            SQLFragment[] usingArgs = null;
            if (helper.isRule(kids.get(start), "mining_attribute_clause")) {
                usingArgs = this.getMiningAttributes(fname, kids.get(start), context);
                ++start;
            }
            retval = new DataMiningFunction(fname, (SQLFragment)new SimpleSQLFragment(modelName), dmCostArgs, dmSpecificArgs.toArray(new SQLFragment[dmSpecificArgs.size()]), usingArgs);
        }
        return retval;
    }

    private SQLFragment[] getCost(ParseNode node, ExpressionContext context) throws SQLQueryException {
        SQLFragment[] retval = null;
        OracleSQLQueryBuilderHelper helper = context.getHelper();
        List<ParseNode> kids = helper.getOrderedChildren(node);
        boolean start = true;
        if (kids.size() == 2 && helper.isKeyword(kids.get(1), "MODEL")) {
            retval = new SQLFragment[]{new SimpleSQLFragment("MODEL")};
        } else if (kids.size() == 3 && helper.isKeyword(kids.get(1), "MODEL") && helper.isKeyword(kids.get(2), "AUTO")) {
            retval = new SQLFragment[]{new SimpleSQLFragment("AUTO")};
        } else {
            int rparenx = helper.getKeywordIndex(kids, ")");
            SQLFragment[] costClassValues = context.getArgList(null, kids, 2, rparenx);
            DataMiningFunction.DataMiningCostValues values = new DataMiningFunction.DataMiningCostValues(costClassValues);
            ArrayList<DataMiningFunction.DataMiningCostValues> cvMatrix = new ArrayList<DataMiningFunction.DataMiningCostValues>();
            cvMatrix.add(values);
            int lparenx = helper.getKeywordIndex(kids, "VALUES") + 2;
            while (lparenx != -1) {
                rparenx = helper.getKeywordIndex(kids, lparenx, ")");
                SQLFragment[] costValues = context.getArgList(null, kids, lparenx + 1, rparenx);
                values = new DataMiningFunction.DataMiningCostValues(costValues);
                cvMatrix.add(values);
                lparenx = helper.getKeywordIndex(kids, rparenx, "(");
            }
            retval = (SQLFragment[])cvMatrix.toArray(new DataMiningFunction.DataMiningCostValues[cvMatrix.size()]);
        }
        return retval;
    }

    private SQLFragment[] getMiningAttributes(Object func, ParseNode mac, ExpressionContext context) throws SQLQueryException {
        List<ParseNode> kids = context.getHelper().getOrderedChildren(mac);
        boolean start = true;
        SQLFragment[] retval = context.getArgList(func, kids, 1, kids.size());
        return retval;
    }
}

